/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.io.File;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.HeapSummary;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.JavaFrameGCRoot;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.AbstractController;
import org.netbeans.modules.profiler.heapwalk.AnalysisController;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.SummaryController;
import org.netbeans.modules.profiler.heapwalk.ui.OverviewControllerUI;
import org.netbeans.modules.profiler.utils.GoToSourceHelper;
import org.netbeans.modules.profiler.utils.JavaSourceLocation;
import org.openide.util.NbBundle;
import sun.misc.VM;

public class OverviewController
extends AbstractController {
    public static final String SHOW_SYSPROPS_URL = "file:/sysprops";
    public static final String SHOW_THREADS_URL = "file:/threads";
    private static final String OPEN_THREADS_URL = "file:/stackframe/";
    private static final String CLASS_URL_PREFIX = "file://class/";
    private static final String INSTANCE_URL_PREFIX = "file://instance/";
    private static final String NOT_AVAILABLE_MSG = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_NotAvailableMsg");
    private static final String SYSTEM_PROPERTIES_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_SystemPropertiesString");
    private static final String SUMMARY_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_SummaryString");
    private static final String ENVIRONMENT_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_EnvironmentString");
    private static final String FILE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FileItemString");
    private static final String FILE_SIZE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FileSizeItemString");
    private static final String DATE_TAKEN_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_DateTakenItemString");
    private static final String TOTAL_BYTES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalBytesItemString");
    private static final String TOTAL_CLASSES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalClassesItemString");
    private static final String TOTAL_INSTANCES_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_TotalInstancesItemString");
    private static final String CLASSLOADERS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ClassloadersItemString");
    private static final String GCROOTS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_GcRootsItemString");
    private static final String FINALIZERS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_FinalizersItemString");
    private static final String OS_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_OsItemString");
    private static final String ARCHITECTURE_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ArchitectureItemString");
    private static final String JAVA_HOME_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JavaHomeItemString");
    private static final String JVM_ITEM_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_JvmItemString");
    private static final String SHOW_SYSPROPS_LINK_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ShowSysPropsLinkString");
    private static final String THREADS_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ThreadsString");
    private static final String SHOW_THREADS_LINK_STRING = NbBundle.getMessage(OverviewController.class, (String)"OverviewController_ShowThreadsLinkString");
    private static final String CANNOT_RESOLVE_CLASS_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveClassMsg");
    private static final String CANNOT_RESOLVE_INSTANCE_MSG = NbBundle.getMessage(AnalysisController.class, (String)"AnalysisController_CannotResolveInstanceMsg");
    private HeapFragmentWalker heapFragmentWalker;
    private SummaryController summaryController;
    private boolean systemPropertiesComputed = false;
    private Properties systemProperties;
    private String stackTrace;
    private JavaClass java_lang_Class;

    public OverviewController(SummaryController summaryController) {
        this.summaryController = summaryController;
        this.heapFragmentWalker = summaryController.getHeapFragmentWalker();
        this.java_lang_Class = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(Class.class.getName());
    }

    public SummaryController getSummaryController() {
        return this.summaryController;
    }

    @Override
    protected AbstractButton createControllerPresenter() {
        return ((OverviewControllerUI)((Object)this.getPanel())).getPresenter();
    }

    @Override
    protected JPanel createControllerUI() {
        return new OverviewControllerUI(this);
    }

    void showInThreads(Instance instance) {
        ((OverviewControllerUI)((Object)this.getPanel())).showInThreads(instance);
    }

    public String computeSummary() {
        Object object;
        Object object2;
        Object object3;
        File file = this.heapFragmentWalker.getHeapDumpFile();
        Heap heap = this.heapFragmentWalker.getHeapFragment();
        HeapSummary heapSummary = heap.getSummary();
        long l = this.computeFinalizers(heap);
        int n = 0;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ClassLoader");
        if (javaClass != null) {
            n = javaClass.getInstancesCount();
            object3 = javaClass.getSubClasses();
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (JavaClass)object2.next();
                n += object.getInstancesCount();
            }
        }
        object3 = (NumberFormat)NumberFormat.getInstance().clone();
        ((NumberFormat)object3).setMaximumFractionDigits(1);
        object2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_ITEM_STRING, file != null && file.exists() ? file.getAbsolutePath() : NOT_AVAILABLE_MSG);
        object = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FILE_SIZE_ITEM_STRING, file != null && file.exists() ? ((NumberFormat)object3).format((double)file.length() / 1048576.0) + " MB" : NOT_AVAILABLE_MSG);
        String string = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(DATE_TAKEN_ITEM_STRING, new Date(heapSummary.getTime()).toString());
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_BYTES_ITEM_STRING, ((NumberFormat)object3).format(heapSummary.getTotalLiveBytes()));
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_CLASSES_ITEM_STRING, ((NumberFormat)object3).format(heap.getAllClasses().size()));
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(TOTAL_INSTANCES_ITEM_STRING, ((NumberFormat)object3).format(heapSummary.getTotalLiveInstances()));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(CLASSLOADERS_ITEM_STRING, ((NumberFormat)object3).format(n));
        String string6 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(GCROOTS_ITEM_STRING, ((NumberFormat)object3).format(heap.getGCRoots().size()));
        String string7 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(FINALIZERS_ITEM_STRING, ((NumberFormat)object3).format(l));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/memory.png'>&nbsp;&nbsp;" + SUMMARY_STRING + "</b><br><hr>" + string + "<br>" + (String)object2 + "<br>" + (String)object + "<br><br>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5 + "<br>" + string6 + "<br>" + string7;
    }

    public String computeEnvironment() {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        String string = properties.getProperty("sun.os.patch.level", "");
        String string2 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(OS_ITEM_STRING, properties.getProperty("os.name", NOT_AVAILABLE_MSG), properties.getProperty("os.version", ""), "unknown".equals(string) ? "" : string);
        String string3 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(ARCHITECTURE_ITEM_STRING, properties.getProperty("os.arch", NOT_AVAILABLE_MSG), properties.getProperty("sun.arch.data.model", "?") + "bit");
        String string4 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JAVA_HOME_ITEM_STRING, properties.getProperty("java.home", NOT_AVAILABLE_MSG));
        String string5 = "&nbsp;&nbsp;&nbsp;&nbsp;" + MessageFormat.format(JVM_ITEM_STRING, properties.getProperty("java.vm.name", NOT_AVAILABLE_MSG), properties.getProperty("java.vm.version", ""), properties.getProperty("java.vm.info", ""));
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/sysinfo.png'>&nbsp;&nbsp;" + ENVIRONMENT_STRING + "</b><br><hr>" + string2 + "<br>" + string3 + "<br>" + string4 + "<br>" + string5;
    }

    public String computeSystemProperties(boolean bl) {
        Properties properties = this.getSystemProperties();
        if (properties == null) {
            return NOT_AVAILABLE_MSG;
        }
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/heapwalk/ui/resources/properties.png'>&nbsp;&nbsp;" + SYSTEM_PROPERTIES_STRING + "</b><br><hr>" + (bl ? this.formatSystemProperties(properties) : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/sysprops'>" + SHOW_SYSPROPS_LINK_STRING + "</a>");
    }

    public String computeThreads(boolean bl) {
        return "<b><img border='0' align='bottom' src='nbresloc:/org/netbeans/modules/profiler/resources/threadsWindow.png'>&nbsp;&nbsp;" + THREADS_STRING + "</b><br><hr>" + (bl ? this.getStackTrace() : "&nbsp;&nbsp;&nbsp;&nbsp;<a href='file:/threads'>" + SHOW_THREADS_LINK_STRING + "</a><br>&nbsp;");
    }

    public void showURL(String string) {
        if (string.startsWith(OPEN_THREADS_URL)) {
            string = string.substring(OPEN_THREADS_URL.length());
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            GoToSourceHelper.openSource(this.heapFragmentWalker.getHeapDumpProject(), new JavaSourceLocation(string2, string3, n));
        } else if (string.startsWith(INSTANCE_URL_PREFIX)) {
            string = string.substring(INSTANCE_URL_PREFIX.length());
            String[] stringArray = string.split("/");
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(stringArray[0]);
            if (javaClass != null) {
                List list = javaClass.getInstances();
                Instance instance = null;
                int n = Integer.parseInt(stringArray[1]);
                if (n <= list.size()) {
                    instance = (Instance)list.get(n - 1);
                }
                if (instance != null) {
                    this.heapFragmentWalker.getClassesController().showInstance(instance);
                } else {
                    NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_INSTANCE_MSG, stringArray[1], javaClass.getName()));
                }
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, stringArray[0]));
            }
        } else if (string.startsWith(CLASS_URL_PREFIX)) {
            string = string.substring(CLASS_URL_PREFIX.length());
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByName(string);
            if (javaClass != null) {
                this.heapFragmentWalker.getClassesController().showClass(javaClass);
            } else {
                NetBeansProfiler.getDefaultNB().displayError(MessageFormat.format(CANNOT_RESOLVE_CLASS_MSG, string));
            }
        }
    }

    private long computeFinalizers(Heap heap) {
        Long l;
        Instance instance;
        JavaClass javaClass = heap.getJavaClassByName("java.lang.ref.Finalizer");
        if (javaClass != null && (instance = (Instance)javaClass.getValueOfStaticField("queue")) != null && (l = (Long)instance.getValueOfField("queueLength")) != null) {
            return l;
        }
        return -1L;
    }

    private Properties getSystemProperties() {
        if (!this.systemPropertiesComputed) {
            this.systemProperties = this.heapFragmentWalker.getHeapFragment().getSystemProperties();
            this.systemPropertiesComputed = true;
        }
        return this.systemProperties;
    }

    private String formatSystemProperties(Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(200);
        ArrayList arrayList = new ArrayList();
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            String string2 = properties.getProperty(string);
            if ("line.separator".equals(string) && string2 != null) {
                string2 = string2.replace("\n", "\\n");
                string2 = string2.replace("\r", "\\r");
            }
            stringBuffer.append("<nobr>&nbsp;&nbsp;&nbsp;&nbsp;<b>");
            stringBuffer.append(string);
            stringBuffer.append("</b>=");
            stringBuffer.append(string2);
            stringBuffer.append("</nobr><br>");
        }
        return stringBuffer.toString();
    }

    private synchronized String getStackTrace() {
        if (this.stackTrace == null) {
            StringBuilder stringBuilder = new StringBuilder();
            Heap heap = this.heapFragmentWalker.getHeapFragment();
            Collection collection = heap.getGCRoots();
            Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> map = this.computeJavaFrameMap(collection);
            stringBuilder.append("<pre>");
            for (GCRoot gCRoot : collection) {
                if (!gCRoot.getKind().equals("thread object")) continue;
                ThreadObjectGCRoot threadObjectGCRoot = (ThreadObjectGCRoot)gCRoot;
                Instance instance = threadObjectGCRoot.getInstance();
                if (instance != null) {
                    Object object2;
                    PrimitiveArrayInstance primitiveArrayInstance = (PrimitiveArrayInstance)instance.getValueOfField("name");
                    List list = primitiveArrayInstance.getValues();
                    char[] cArray = new char[list.size()];
                    int n = 0;
                    for (Object object2 : list) {
                        cArray[n++] = ((String)object2).charAt(0);
                    }
                    String string = new String(cArray);
                    object2 = (Boolean)instance.getValueOfField("daemon");
                    Integer n2 = (Integer)instance.getValueOfField("priority");
                    Long l = (Long)instance.getValueOfField("tid");
                    Integer n3 = (Integer)instance.getValueOfField("threadStatus");
                    StackTraceElement[] stackTraceElementArray = threadObjectGCRoot.getStackTrace();
                    Map<Integer, List<JavaFrameGCRoot>> map2 = map.get(threadObjectGCRoot);
                    stringBuilder.append("&nbsp;&nbsp;<b>");
                    stringBuilder.append("\"" + (String)string + "\"" + (((Boolean)object2).booleanValue() ? " daemon" : "") + " prio=" + n2);
                    if (l != null) {
                        stringBuilder.append(" tid=" + l);
                    }
                    if (n3 != null) {
                        Thread.State state = VM.toThreadState((int)n3);
                        stringBuilder.append(" " + (Object)((Object)state));
                    }
                    stringBuilder.append("</b><br>");
                    if (stackTraceElementArray != null) {
                        for (int i = 0; i < stackTraceElementArray.length; ++i) {
                            String string2;
                            String string3;
                            Object object3;
                            Object object4;
                            StackTraceElement stackTraceElement = stackTraceElementArray[i];
                            String string4 = OverviewController.htmlize(stackTraceElement.toString());
                            if (this.heapFragmentWalker.getHeapDumpProject() != null) {
                                object4 = stackTraceElement.getClassName();
                                object3 = stackTraceElement.getMethodName();
                                int n4 = stackTraceElement.getLineNumber();
                                string3 = OPEN_THREADS_URL + (String)object4 + "|" + (String)object3 + "|" + n4;
                                string2 = "<a href=\"" + string3 + "\">" + string4 + "</a>";
                            } else {
                                string2 = string4;
                            }
                            stringBuilder.append("\tat " + string2 + "<br>");
                            if (map2 == null || (object4 = map2.get(i)) == null) continue;
                            object3 = object4.iterator();
                            while (object3.hasNext()) {
                                JavaFrameGCRoot javaFrameGCRoot = (JavaFrameGCRoot)object3.next();
                                string3 = javaFrameGCRoot.getInstance();
                                stringBuilder.append("\t   Local Variable: " + this.printInstance((Instance)string3) + "<br>");
                            }
                        }
                    }
                } else {
                    stringBuilder.append("&nbsp;&nbsp;Unknown thread");
                }
                stringBuilder.append("<br>");
            }
            stringBuilder.append("</pre>");
            this.stackTrace = stringBuilder.toString();
        }
        return this.stackTrace;
    }

    private Map<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> computeJavaFrameMap(Collection<GCRoot> collection) {
        HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>> hashMap = new HashMap<ThreadObjectGCRoot, Map<Integer, List<JavaFrameGCRoot>>>();
        for (GCRoot gCRoot : collection) {
            ArrayList<JavaFrameGCRoot> arrayList;
            if (!"Java frame".equals(gCRoot.getKind())) continue;
            JavaFrameGCRoot javaFrameGCRoot = (JavaFrameGCRoot)gCRoot;
            ThreadObjectGCRoot threadObjectGCRoot = javaFrameGCRoot.getThreadGCRoot();
            Integer n = javaFrameGCRoot.getFrameNumber();
            HashMap<Integer, ArrayList<JavaFrameGCRoot>> hashMap2 = (HashMap<Integer, ArrayList<JavaFrameGCRoot>>)hashMap.get(threadObjectGCRoot);
            if (hashMap2 == null) {
                hashMap2 = new HashMap<Integer, ArrayList<JavaFrameGCRoot>>();
                hashMap.put(threadObjectGCRoot, hashMap2);
            }
            if ((arrayList = (ArrayList<JavaFrameGCRoot>)hashMap2.get(n)) == null) {
                arrayList = new ArrayList<JavaFrameGCRoot>(2);
                hashMap2.put(n, arrayList);
            }
            arrayList.add(javaFrameGCRoot);
        }
        return hashMap;
    }

    private String printInstance(Instance instance) {
        if (instance.getJavaClass().equals(this.java_lang_Class)) {
            JavaClass javaClass = this.heapFragmentWalker.getHeapFragment().getJavaClassByID(instance.getInstanceId());
            String string = javaClass.getName();
            return "<a href='file://class/" + string + "' name='" + javaClass.getJavaClassId() + "'>class " + string + "</a>";
        }
        String string = instance.getJavaClass().getName();
        return "<a href='file://instance/" + string + "/" + instance.getInstanceNumber() + "' name='" + instance.getInstanceId() + "'>" + string + '#' + instance.getInstanceNumber() + "</a>";
    }

    private static String htmlize(String string) {
        return string.replace(">", "&gt;").replace("<", "&lt;");
    }
}

