/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTProvider;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.ClassHistoryDataManager;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CodeRegionLivePanel;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.LiveFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.statistics.StatisticalModuleContainer;
import org.netbeans.lib.profiler.ui.graphs.AllocationsHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.graphs.LivenessHistoryGraphPanel;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryActionsHandler;
import org.netbeans.lib.profiler.ui.memory.ClassHistoryModels;
import org.netbeans.lib.profiler.ui.memory.LiveAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.LiveLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.DrillDownWindow;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.ResultsListener;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.ResetResultsAction;
import org.netbeans.modules.profiler.actions.TakeSnapshotAction;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDown;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownFactory;
import org.netbeans.modules.profiler.ui.stats.drilldown.DrillDownListener;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.NotifyDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;
import org.openide.windows.TopComponentGroup;
import org.openide.windows.WindowManager;

public final class LiveResultsWindow
extends TopComponent
implements ResultsListener,
ProfilingStateListener,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.profiler.LiveResultsWindow");
    private static final String UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsAutomaticallyTooltip");
    private static final String UPDATE_RESULTS_NOW_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_UpdateResultsNowTooltip");
    private static final String RUN_GC_TOOLTIP = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_RunGCTooltip");
    private static final String NO_PROFILING_RESULTS_LABEL_TEXT = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_NoProfilingResultsLabelText");
    private static final String ERROR_DISPLAYING_STACK_TRACES_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingStackTracesMsg");
    private static final String ERROR_DISPLAYING_CALL_GRAPH_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorDisplayingCallGraphMsg");
    private static final String ERROR_INSTRUMENTING_ROOT_METHOD_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ErrorInstrumentingRootMethodMsg");
    private static final String LIVE_RESULTS_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsTabName");
    private static final String HISTORY_TAB_NAME = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_HistoryTabName");
    private static final String LIVE_RESULTS_ACCESS_DESCR = NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_LiveResultsAccessDescr");
    private static final String LOGGING_CONFIRMATION_CAPTION = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingConfirmationCaption");
    private static final String LOGGING_RESET_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingResetMsg");
    private static final String LOGGING_STOP_MSG = NbBundle.getMessage(LiveResultsWindow.class, (String)"History_LoggingStopMsg");
    private static final String HELP_CTX_KEY = "LiveResultsWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LiveResultsWindow.HelpCtx");
    private static LiveResultsWindow defaultLiveInstance;
    private static final TargetAppRunner runner;
    private static final Image liveWindowIcon;
    private static final AtomicBoolean resultsDumpForced;
    private CPUResUserActionsHandler cpuActionsHandler;
    private Component lastFocusOwner;
    private DrillDown dd = null;
    private EmptyLiveResultsPanel noResultsPanel;
    private JButton runGCButton;
    private JButton updateNowButton;
    private JPanel currentDisplayComponent;
    private JPanel memoryTabPanel;
    private JTabbedPane tabs;
    private JToggleButton autoToggle;
    private JToolBar.Separator graphButtonsSeparator;
    private List<JButton> chartActions = new ArrayList<JButton>();
    private JPanel historyPanel;
    private ClassHistoryDataManager classHistoryManager;
    private ClassHistoryModels classHistoryModels;
    private AllocationsHistoryGraphPanel allocationsHistoryPanel;
    private LivenessHistoryGraphPanel livenessHistoryPanel;
    private JToolBar toolBar;
    private LiveResultsPanel currentDisplay;
    private MemoryResUserActionsHandler memoryActionsHandler;
    private HistoryActionsHandler historyActionsHandler;
    private boolean autoRefresh = true;
    private boolean drillDownGroupOpened;
    private volatile boolean profilerRunning = false;
    private volatile boolean resultsAvailable = false;

    public LiveResultsWindow() {
        this.setName(NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        this.setIcon(liveWindowIcon);
        this.getAccessibleContext().setAccessibleDescription(LIVE_RESULTS_ACCESS_DESCR);
        this.setLayout(new BorderLayout());
        this.memoryActionsHandler = new MemoryActionsHandler();
        this.historyActionsHandler = new HistoryActionsHandler();
        this.cpuActionsHandler = new CPUActionsHandler();
        this.classHistoryManager = new ClassHistoryDataManager();
        this.classHistoryModels = new ClassHistoryModels(this.classHistoryManager);
        this.toolBar = this.createToolBar();
        this.add(this.toolBar, "North");
        this.noResultsPanel = new EmptyLiveResultsPanel();
        this.noResultsPanel.setLayout(new BorderLayout());
        this.noResultsPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JLabel noResultsLabel = new JLabel(NO_PROFILING_RESULTS_LABEL_TEXT);
        noResultsLabel.setFont(noResultsLabel.getFont().deriveFont(14));
        noResultsLabel.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/ui/resources/monitoring.png", (boolean)false));
        noResultsLabel.setIconTextGap(10);
        noResultsLabel.setEnabled(false);
        this.noResultsPanel.add((Component)noResultsLabel, "North");
        this.currentDisplay = null;
        this.currentDisplayComponent = this.noResultsPanel;
        this.add(this.noResultsPanel, "Center");
        this.memoryTabPanel = new JPanel(new BorderLayout());
        this.tabs = new JTabbedPane();
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.graphButtonsSeparator = new JToolBar.Separator();
        this.toolBar.add(this.graphButtonsSeparator);
        final int chartButtonsOffset = this.toolBar.getComponentCount();
        this.memoryTabPanel.add((Component)this.tabs, "Center");
        this.tabs.setTabPlacement(3);
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (LiveResultsWindow.this.currentDisplayComponent == LiveResultsWindow.this.memoryTabPanel) {
                    if (LiveResultsWindow.this.tabs.getSelectedComponent() == LiveResultsWindow.this.historyPanel) {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.add((Component)b, chartButtonsOffset);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(true);
                    } else {
                        for (JButton b : LiveResultsWindow.this.chartActions) {
                            LiveResultsWindow.this.toolBar.remove(b);
                        }
                        LiveResultsWindow.this.graphButtonsSeparator.setVisible(false);
                    }
                }
            }
        });
        this.historyPanel = new JPanel(new BorderLayout());
        JPanel toolbarSpacer = new JPanel(new FlowLayout(3, 0, 0)){

            @Override
            public Dimension getPreferredSize() {
                if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
                    int currentWidth = ((LiveResultsWindow)LiveResultsWindow.this).toolBar.getSize().width;
                    int minimumWidth = ((LiveResultsWindow)LiveResultsWindow.this).toolBar.getMinimumSize().width;
                    int extraWidth = currentWidth - minimumWidth;
                    return new Dimension(Math.max(extraWidth, 0), 0);
                }
                return super.getPreferredSize();
            }
        };
        toolbarSpacer.setOpaque(false);
        final DrillDownWindow drillDownWin = DrillDownWindow.getDefault();
        DrillDownWindow.closeIfOpened();
        drillDownWin.getPresenter().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (drillDownWin.getPresenter().isSelected()) {
                    drillDownWin.open();
                } else {
                    drillDownWin.close();
                }
            }
        });
        this.toolBar.add(toolbarSpacer);
        this.toolBar.add(drillDownWin.getPresenter());
        this.hideDrillDown();
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        ResultsManager.getDefault().addResultsListener(this);
    }

    public static synchronized LiveResultsWindow getDefault() {
        if (!LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThreadAndWait(new Runnable(){

                @Override
                public void run() {
                    defaultLiveInstance = new LiveResultsWindow();
                }
            });
        }
        return defaultLiveInstance;
    }

    public static void setPaused(boolean value) {
    }

    public static void closeIfOpened() {
        if (LiveResultsWindow.hasDefault()) {
            IDEUtils.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    if (defaultLiveInstance.isOpened()) {
                        defaultLiveInstance.close();
                    }
                }
            });
        }
    }

    public static boolean hasDefault() {
        return defaultLiveInstance != null;
    }

    public void setAutoRefresh(boolean value) {
        if (this.autoRefresh != value) {
            this.autoRefresh = value;
            this.autoToggle.setSelected(value);
        }
    }

    public boolean isAutoRefresh() {
        return this.autoRefresh;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    public int getPersistenceType() {
        return 2;
    }

    public int getSortingColumn() {
        if (this.currentDisplay == null) {
            return -1;
        }
        return this.currentDisplay.getSortingColumn();
    }

    public boolean getSortingOrder() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.getSortingOrder();
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return UIUtils.createScreenshot((Component)this.historyPanel);
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewImage(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return "memory-history-" + this.classHistoryManager.getTrackedClassName();
        }
        if (this.currentDisplay == null) {
            return null;
        }
        return this.currentDisplay.getViewName();
    }

    public void componentActivated() {
        super.componentActivated();
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else if (this.currentDisplayComponent != null) {
            this.currentDisplayComponent.requestFocus();
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    @Override
    public boolean fitsVisibleArea() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return this.currentDisplay != null && this.currentDisplay.fitsVisibleArea();
    }

    public void handleShutdown() {
        this.profilerRunning = false;
        if (this.isShowing()) {
            this.hideDrillDown();
            this.requestProfilingDataUpdate(false);
        }
    }

    public void handleStartup() {
        this.profilerRunning = true;
    }

    public void handleCleanupBeforeProfiling() {
        this.classHistoryManager.resetClass();
    }

    @Override
    public boolean hasView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.historyPanel) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    public void ideClosing() {
        this.hideDrillDown();
    }

    public void instrumentationChanged(int oldInstrType, int currentInstrType) {
        this.requestProfilingDataUpdate(false);
    }

    public void profilingStateChanged(ProfilingStateEvent e) {
        this.updateActions(e.getNewState());
        switch (e.getNewState()) {
            case 1: {
                this.handleShutdown();
                break;
            }
            case 4: {
                this.handleStartup();
            }
        }
    }

    public boolean refreshLiveResults() {
        if (this.isAutoRefresh() && this.isShowing()) {
            this.requestProfilingDataUpdate(false);
            return true;
        }
        if (NetBeansProfiler.getDefaultNB().processesProfilingPoints()) {
            LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient(), false);
        }
        return false;
    }

    @Override
    public void resultsAvailable() {
    }

    @Override
    public void resultsReset() {
        this.reset();
    }

    public void threadsMonitoringChanged() {
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        if (this.currentDisplayComponent == this.memoryTabPanel) {
            if (this.tabs.getSelectedComponent() instanceof LiveAllocResultsPanel) {
                ((LiveAllocResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            } else if (this.tabs.getSelectedComponent() instanceof LiveLivenessResultsPanel) {
                ((LiveLivenessResultsPanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
            }
        } else if (this.currentDisplayComponent instanceof LiveFlatProfilePanel) {
            ((LiveFlatProfilePanel)this.currentDisplay).exportData(exportedFileType, eDD, NbBundle.getMessage(LiveResultsWindow.class, (String)"LAB_ResultsWindowName"));
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        if (this.currentDisplayComponent == this.memoryTabPanel && this.tabs.getSelectedComponent() == this.currentDisplay) {
            return true;
        }
        return !this.noResultsPanel.isShowing() && this.currentDisplay != null && this.currentDisplay.hasView();
    }

    protected void componentClosed() {
        super.componentClosed();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.hideDrillDown();
    }

    protected void componentOpened() {
        super.componentOpened();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.updateResultsDisplay();
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    void reset() {
        this.resultsAvailable = false;
        if (this.currentDisplay != null) {
            this.currentDisplay.reset();
            this.resetResultsDisplay();
        }
        this.resetDrillDown();
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient client) {
        return LiveResultsWindow.callForceObtainedResultsDump(client, true);
    }

    private static boolean callForceObtainedResultsDump(ProfilerClient client, boolean refreshDisplay) {
        if (refreshDisplay) {
            resultsDumpForced.set(true);
        }
        try {
            if (client.getCurrentInstrType() != 1) {
                client.forceObtainedResultsDump(true);
            }
            return true;
        }
        catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
            return false;
        }
    }

    private boolean isProfiling() {
        return runner.getProfilerClient().getCurrentInstrType() != 0;
    }

    private static boolean checkIfResultsExist(ProfilerClient client, int currentInstrType) {
        switch (currentInstrType) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return LiveResultsWindow.getDefault().resultsAvailable;
            }
            case 1: {
                try {
                    return client.cpuResultsExist();
                }
                catch (ClientUtils.TargetAppOrVMTerminated targetAppOrVMTerminated) {
                    return false;
                }
            }
        }
        return false;
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.autoToggle = new JToggleButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/autoRefresh.png", (boolean)false));
        this.autoToggle.setSelected(true);
        this.autoToggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.autoRefresh = LiveResultsWindow.this.autoToggle.isSelected();
            }
        });
        this.autoToggle.setToolTipText(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.autoToggle.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_AUTOMATICALLY_TOOLTIP);
        this.updateNowButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/updateNow.png", (boolean)false));
        this.updateNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.updateNowButton.setToolTipText(UPDATE_RESULTS_NOW_TOOLTIP);
        this.updateNowButton.getAccessibleContext().setAccessibleName(UPDATE_RESULTS_NOW_TOOLTIP);
        this.runGCButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/actions/resources/runGC.png", (boolean)false));
        this.runGCButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    runner.runGC();
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    Profiler.getDefault().displayError(ex.getMessage());
                    ProfilerLogger.log((Exception)((Object)ex));
                }
                LiveResultsWindow.this.requestProfilingDataUpdate(true);
            }
        });
        this.runGCButton.setToolTipText(RUN_GC_TOOLTIP);
        this.runGCButton.getAccessibleContext().setAccessibleName(RUN_GC_TOOLTIP);
        toolBar.add(this.autoToggle);
        toolBar.add(this.updateNowButton);
        toolBar.add(this.runGCButton);
        toolBar.add(new ResetResultsAction());
        toolBar.addSeparator();
        toolBar.add(((Presenter.Toolbar)SystemAction.get(TakeSnapshotAction.class)).getToolbarPresenter());
        toolBar.addSeparator();
        toolBar.add(new ExportAction(this, null));
        toolBar.add(new SaveViewAction(this));
        return toolBar;
    }

    private void hideDrillDown() {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (group != null) {
                    group.close();
                }
                LiveResultsWindow.this.drillDownGroupOpened = false;
                DrillDownWindow.getDefault().getPresenter().setEnabled(false);
            }
        });
    }

    private LiveResultsPanel preparePanelForInstrType(int instrumentationType) {
        CodeRegionLivePanel aPanel = null;
        this.dd = null;
        switch (instrumentationType) {
            case 4: {
                LiveAllocResultsPanel allocPanel = new LiveAllocResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)allocPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                aPanel = allocPanel;
                break;
            }
            case 5: {
                LiveLivenessResultsPanel livenessPanel = new LiveLivenessResultsPanel(runner, this.memoryActionsHandler, (ClassHistoryActionsHandler)this.historyActionsHandler, this.classHistoryManager);
                this.currentDisplayComponent = this.memoryTabPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 0, 0, 0));
                if (this.tabs.getComponentCount() > 0) {
                    this.tabs.removeAll();
                }
                this.tabs.addTab(LIVE_RESULTS_TAB_NAME, (Component)livenessPanel);
                this.tabs.addTab(HISTORY_TAB_NAME, this.historyPanel);
                this.tabs.setEnabledAt(1, false);
                aPanel = livenessPanel;
                break;
            }
            case 2: 
            case 3: {
                Project project = NetBeansProfiler.getDefaultNB().getProfiledProject();
                ArrayList additionalStats = new ArrayList();
                this.dd = ((DrillDownFactory)Lookup.getDefault().lookup(DrillDownFactory.class)).createDrillDown(project, runner.getProfilerClient());
                if (this.dd != null) {
                    StatisticalModuleContainer container = (StatisticalModuleContainer)Lookup.getDefault().lookup(StatisticalModuleContainer.class);
                    additionalStats.addAll(container.getAllModules());
                    DrillDownWindow.getDefault().setDrillDown(this.dd, additionalStats);
                    this.showDrillDown();
                } else {
                    this.hideDrillDown();
                }
                final LiveFlatProfilePanel cpuPanel = new LiveFlatProfilePanel(runner, this.cpuActionsHandler, additionalStats);
                if (this.dd != null) {
                    this.dd.addListener(new DrillDownListener(){

                        @Override
                        public void dataChanged() {
                        }

                        @Override
                        public void drillDownPathChanged(List list) {
                            cpuPanel.updateLiveResults();
                        }
                    });
                }
                this.currentDisplayComponent = cpuPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = cpuPanel;
                break;
            }
            case 1: {
                CodeRegionLivePanel regionPanel = new CodeRegionLivePanel(runner.getProfilerClient());
                this.currentDisplayComponent = regionPanel;
                this.currentDisplayComponent.setBorder(new EmptyBorder(5, 5, 5, 5));
                aPanel = regionPanel;
                break;
            }
            case 0: {
                throw new IllegalStateException();
            }
        }
        return aPanel;
    }

    private void requestProfilingDataUpdate(final boolean force) {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (!LiveResultsWindow.this.isAutoRefresh() && !force) {
                    return;
                }
                if (!LiveResultsWindow.this.isProfiling() || !LiveResultsWindow.this.isOpened()) {
                    return;
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.callForceObtainedResultsDump(runner.getProfilerClient());
                    }
                });
            }
        });
    }

    private void resetDrillDown() {
        if (this.dd != null) {
            this.dd.reset();
        }
    }

    private void resetResultsDisplay() {
        if (this.currentDisplayComponent != null && this.currentDisplayComponent != this.noResultsPanel) {
            this.remove(this.currentDisplayComponent);
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            this.add(this.noResultsPanel, "Center");
            for (JButton b : this.chartActions) {
                this.toolBar.remove(b);
            }
            this.graphButtonsSeparator.setVisible(false);
            this.revalidate();
            this.repaint();
            this.hideDrillDown();
        }
    }

    private void showDrillDown() {
        IDEUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                TopComponentGroup group = WindowManager.getDefault().findTopComponentGroup("LiveResultsGroup");
                if (group != null) {
                    group.open();
                    LiveResultsWindow.this.drillDownGroupOpened = true;
                    DrillDownWindow.getDefault().getPresenter().setEnabled(true);
                } else {
                    LOGGER.severe("LiveResultsGroup not existing!");
                }
            }
        });
    }

    private void updateActions(int newState) {
        this.runGCButton.setEnabled(newState == 4);
        this.updateNowButton.setEnabled(newState == 4);
    }

    private void updateDrillDown() {
        if (this.dd != null) {
            this.dd.refresh();
        }
        if (LOGGER.isLoggable(Level.FINE) && this.currentDisplayComponent != null) {
            LOGGER.fine("updating drilldown: " + this.currentDisplayComponent.getClass().getName());
        }
        if (this.profilerRunning && this.currentDisplayComponent instanceof LiveFlatProfilePanel && this.dd != null && this.dd.isValid()) {
            LOGGER.fine("Showing drilldown");
            if (!this.drillDownGroupOpened && this.isVisible()) {
                this.showDrillDown();
            }
        } else {
            LOGGER.fine("Hiding drilldown");
            if (this.drillDownGroupOpened) {
                this.hideDrillDown();
            }
        }
    }

    private void updateResultsDisplay() {
        if (!this.isOpened()) {
            return;
        }
        if (!resultsDumpForced.getAndSet(false) && !this.isAutoRefresh()) {
            return;
        }
        if (!this.resultsAvailable) {
            this.currentDisplay = null;
            this.currentDisplayComponent = this.noResultsPanel;
            return;
        }
        int instrType = runner.getProfilerClient().getCurrentInstrType();
        if (instrType != 0) {
            boolean instrSupported;
            boolean bl = instrSupported = this.currentDisplayComponent != null && this.currentDisplay != null && this.currentDisplay.supports(instrType);
            if (!instrSupported) {
                if (this.currentDisplayComponent != null) {
                    this.remove(this.currentDisplayComponent);
                }
                if (this.currentDisplay != null) {
                    this.currentDisplay.handleRemove();
                }
                this.currentDisplay = this.preparePanelForInstrType(instrType);
                this.add(this.currentDisplayComponent, "Center");
                this.revalidate();
                this.repaint();
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.this.currentDisplayComponent.requestFocusInWindow();
                    }
                });
            }
            if (this.currentDisplay != null) {
                this.currentDisplay.updateLiveResults();
            }
        }
        this.updateDrillDown();
    }

    static {
        runner = Profiler.getDefault().getTargetAppRunner();
        liveWindowIcon = ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/liveResultsWindow.png");
        resultsDumpForced = new AtomicBoolean(false);
    }

    private final class HistoryActionsHandler
    implements ClassHistoryActionsHandler {
        private HistoryActionsHandler() {
        }

        public void showClassHistory(int classID, final String className) {
            ProfilerDialogs.DNSAConfirmationChecked dnsa;
            int currentlyTrackedClass = LiveResultsWindow.this.classHistoryManager.getTrackedClassID();
            String currentlyTrackedClassName = LiveResultsWindow.this.classHistoryManager.getTrackedClassName();
            if (currentlyTrackedClass != -1 && (classID == currentlyTrackedClass ? !ProfilerDialogs.notify((NotifyDescriptor)(dnsa = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.reset", (Object)MessageFormat.format(LOGGING_RESET_MSG, currentlyTrackedClassName), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION) : !ProfilerDialogs.notify((NotifyDescriptor)(dnsa = new ProfilerDialogs.DNSAConfirmationChecked("History.historylogging.stop", (Object)MessageFormat.format(LOGGING_STOP_MSG, currentlyTrackedClassName), LOGGING_CONFIRMATION_CAPTION, 0))).equals(ProfilerDialogs.DNSAConfirmationChecked.YES_OPTION))) {
                return;
            }
            LiveResultsWindow.this.classHistoryManager.setupClass(classID, className);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LiveResultsWindow.this.chartActions.clear();
                    Action[] actions = null;
                    if (runner.getProfilerClient().getCurrentInstrType() == 4) {
                        if (LiveResultsWindow.this.allocationsHistoryPanel == null) {
                            LiveResultsWindow.this.allocationsHistoryPanel = AllocationsHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.allocationsHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.allocationsHistoryPanel.getActions();
                    } else if (runner.getProfilerClient().getCurrentInstrType() == 5) {
                        if (LiveResultsWindow.this.livenessHistoryPanel == null) {
                            LiveResultsWindow.this.livenessHistoryPanel = LivenessHistoryGraphPanel.createPanel((ClassHistoryModels)LiveResultsWindow.this.classHistoryModels);
                        }
                        LiveResultsWindow.this.historyPanel.removeAll();
                        LiveResultsWindow.this.historyPanel.add((Component)LiveResultsWindow.this.livenessHistoryPanel, "Center");
                        actions = LiveResultsWindow.this.livenessHistoryPanel.getActions();
                    }
                    if (actions != null) {
                        for (void var5_5 : actions) {
                            LiveResultsWindow.this.chartActions.add(new JButton((Action)var5_5));
                        }
                    }
                    Collections.reverse(LiveResultsWindow.this.chartActions);
                    LiveResultsWindow.this.tabs.setEnabledAt(1, true);
                    LiveResultsWindow.this.tabs.setTitleAt(1, NbBundle.getMessage(LiveResultsWindow.class, (String)"LiveResultsWindow_ClassHistoryTabName", (Object[])new Object[]{className}));
                    LiveResultsWindow.this.tabs.setSelectedIndex(1);
                }
            });
        }
    }

    private final class MemoryActionsHandler
    implements MemoryResUserActionsHandler {
        private MemoryActionsHandler() {
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            if (methodName == null && methodSig == null && (VMUtils.isVMPrimitiveType((String)className) || VMUtils.isPrimitiveType((String)className))) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(className) && "traceVMObjectAlloc".equals(methodName)) {
                Profiler.getDefault().displayWarning(CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                NetBeansProfiler.getDefaultNB().openJavaSource(className, methodName, methodSig);
            }
        }

        public void showStacksForClass(final int selectedClassId, final int sortingColumn, final boolean sortingOrder) {
            IDEUtils.runInProfilerRequestProcessor(new Runnable(){

                @Override
                public void run() {
                    final LoadedSnapshot ls = ResultsManager.getDefault().takeSnapshot();
                    if (ls != null) {
                        IDEUtils.runInEventDispatchThread(new Runnable(){

                            @Override
                            public void run() {
                                SnapshotResultsWindow srw = SnapshotResultsWindow.get(ls, sortingColumn, sortingOrder);
                                if (srw != null) {
                                    srw.displayStacksForClass(selectedClassId, sortingColumn, sortingOrder);
                                }
                            }
                        });
                    }
                }
            });
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String className, String methodName, String methodSig) {
            ProfilingSettings settingsToModify;
            Project project = ((NetBeansProfiler)Profiler.getDefault()).getProfiledProject();
            ProfilingSettings[] projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
            ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings settings : projectSettings) {
                if (!Utils.isCPUSettings(settings.getProfilingType())) continue;
                cpuSettings.add(settings);
            }
            ProfilingSettings lastProfilingSettings = null;
            String lastProfilingSettingsName = Profiler.getDefault().getLastProfilingSettings().getSettingsName();
            for (ProfilingSettings settings : cpuSettings) {
                if (!settings.getSettingsName().equals(lastProfilingSettingsName)) continue;
                lastProfilingSettings = settings;
                break;
            }
            if ((settingsToModify = IDEUtils.selectSettings(project, 16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), lastProfilingSettings)) == null) {
                return;
            }
            settingsToModify.addRootMethod(className, methodName, methodSig);
            if (cpuSettings.contains(settingsToModify)) {
                ProfilingSettingsManager.getDefault().storeProfilingSettings(projectSettings, settingsToModify, project);
            } else {
                ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                newProjectSettings[projectSettings.length] = settingsToModify;
                ProfilingSettingsManager.getDefault().storeProfilingSettings(newProjectSettings, settingsToModify, project);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot snapshot, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            throw new IllegalStateException(ERROR_DISPLAYING_CALL_GRAPH_MSG);
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            Profiler.getDefault().openJavaSource(className, methodName, methodSig);
        }

        public void viewChanged(int viewType) {
            if (LiveResultsWindow.this.currentDisplay != null) {
                ((FlatProfilePanel)LiveResultsWindow.this.currentDisplay).prepareResults();
            }
        }
    }

    public static class ActivateDrillDownAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DrillDownWindow drillDown;
            if (TopComponent.getRegistry().getActivated() == LiveResultsWindow.getDefault() && (drillDown = DrillDownWindow.getDefault()).isOpened()) {
                drillDown.requestActive();
            }
        }
    }

    public static final class ResultsMonitor
    implements CPUCCTProvider.Listener,
    MemoryCCTProvider.Listener {
        public void cctEstablished(RuntimeCCTNode runtimeCCTNode, boolean empty) {
            if (!empty) {
                LiveResultsWindow.getDefault().resultsAvailable = true;
                IDEUtils.runInEventDispatchThread(new Runnable(){

                    @Override
                    public void run() {
                        LiveResultsWindow.getDefault().updateResultsDisplay();
                    }
                });
            } else {
                resultsDumpForced.set(false);
            }
        }

        public void cctReset() {
            LiveResultsWindow.getDefault().resultsAvailable = false;
        }
    }

    public static final class EmptyLiveResultsPanel
    extends JPanel
    implements LiveResultsPanel {
        public int getSortingColumn() {
            return -1;
        }

        public boolean getSortingOrder() {
            return true;
        }

        public BufferedImage getViewImage(boolean b) {
            throw new UnsupportedOperationException();
        }

        public String getViewName() {
            return "Empty live results";
        }

        public boolean fitsVisibleArea() {
            return false;
        }

        public void handleRemove() {
        }

        public void handleShutdown() {
        }

        public boolean hasView() {
            return false;
        }

        public void reset() {
        }

        public boolean supports(int instrumentationType) {
            return true;
        }

        public void updateLiveResults() {
        }
    }
}

