/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeFree
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int methodId;
    protected int nCalls;
    protected long sleepTime0;
    protected long totalTime0;
    protected long totalTime1;
    protected long waitTime0;

    protected PrestimeCPUCCTNodeFree(CPUCCTContainer container, PrestimeCPUCCTNode parent, int methodId) {
        super(container, parent);
        this.methodId = methodId;
    }

    @Override
    public CCTNode getChild(int index) {
        return this.children[index];
    }

    @Override
    public CCTNode[] getChildren() {
        return this.children;
    }

    public void setMethodId(int methodId) {
        this.methodId = methodId;
    }

    @Override
    public int getMethodId() {
        return this.methodId;
    }

    @Override
    public int getNCalls() {
        return this.nCalls;
    }

    @Override
    public int getNChildren() {
        return this.children != null ? this.children.length : 0;
    }

    @Override
    public long getSleepTime0() {
        return 0L;
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        return this.totalTime0;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float result = (float)((double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0);
        return result < 100.0f ? result : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        return this.totalTime1;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)((double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0);
    }

    @Override
    public long getWaitTime0() {
        return 0L;
    }

    public void addChild(PrestimeCPUCCTNodeFree node) {
        if (this.children == null) {
            this.children = new PrestimeCPUCCTNodeFree[1];
        } else {
            PrestimeCPUCCTNodeFree[] newch = new PrestimeCPUCCTNodeFree[this.children.length + 1];
            System.arraycopy(this.children, 0, newch, 0, this.children.length);
            this.children = newch;
        }
        this.children[this.children.length - 1] = node;
    }

    public void addNCalls(int addCalls) {
        this.nCalls += addCalls;
    }

    public void addSleepTime0(long addTime) {
        this.sleepTime0 += addTime;
    }

    public void addTotalTime0(long addTime) {
        this.totalTime0 += addTime;
    }

    public void addTotalTime1(long addTime) {
        this.totalTime1 += addTime;
    }

    public void addWaitTime0(long addTime) {
        this.waitTime0 += addTime;
    }

    public PrestimeCPUCCTNodeFree createChildlessCopy() {
        try {
            PrestimeCPUCCTNodeFree res = (PrestimeCPUCCTNodeFree)this.clone();
            res.children = null;
            return res;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public void sortChildren(int sortBy, boolean sortOrder) {
        if (this.children != null) {
            this.doSortChildren(sortBy, sortOrder);
        }
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<node>" + newline);
        result.append(indent + " <Name>" + this.replaceHTMLCharacters(this.getNodeName()) + "</Name>" + newline);
        result.append(indent + " <Parent>" + this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeFree)this.getParent()).getNodeName()) + "</Parent>" + newline);
        result.append(indent + " <Time_Relative>" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</Time_Relative>" + newline);
        result.append(indent + " <Time>" + this.getTotalTime0() + "</Time>" + newline);
        result.append(indent + " <Invocations>" + this.getNCalls() + "</Invocations>" + newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportXMLData(eDD, indent + "  ");
            }
        }
        result = new StringBuffer(indent + "</node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName()) + "</pre></td><td class=\"right\">" + percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0) + "</td><td class=\"right\">" + this.getTotalTime0() + "</td><td class=\"right\">" + this.getNCalls() + "</td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportHTMLData(eDD, depth + 1);
            }
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName() + quote + separator);
        result.append(quote + this.getTotalTime0InPerCent() + quote + separator);
        result.append(quote + this.getTotalTime0() + quote + separator);
        result.append(quote + this.getNCalls() + quote + newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.getNChildren(); ++i) {
                ((PrestimeCPUCCTNodeFree)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        }
    }

    public static void setPercentFormat(NumberFormat percentFormat) {
        PrestimeCPUCCTNodeFree.percentFormat = percentFormat;
    }
}

