/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.source.usages;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;
import org.netbeans.modules.gsfret.source.usages.ClassIndexImpl;

class DocumentUtil {
    private static final String ROOT_NAME = "/";
    private static final String FIELD_RESOURCE_NAME = "resName";
    private static final String FIELD_BINARY_NAME = "binaryName";
    private static final String FIELD_PACKAGE_NAME = "packageName";
    static final String FIELD_TIME_STAMP = "timeStamp";
    static final String FIELD_FILENAME = "filename";
    private static final String FIELD_REFERENCES = "references";
    private static final String FIELD_SIMPLE_NAME = "simpleName";
    private static final String FIELD_CASE_INSENSITIVE_NAME = "ciName";
    private static final char NO = '-';
    private static final char YES = '+';
    private static final char WILDCARD = '?';
    private static final char PKG_SEPARATOR = '.';
    private static final char EK_CLASS = 'C';
    private static final char EK_INTERFACE = 'I';
    private static final char EK_ENUM = 'E';
    private static final char EK_ANNOTATION = 'A';
    private static final int SIZE = ClassIndexImpl.UsageType.values().length;
    private static final char[] MASK_ANY_USAGE = new char[SIZE];

    private DocumentUtil() {
    }

    public static String getBinaryName(Document doc) {
        assert (doc != null);
        Field pkgField = doc.getField(FIELD_PACKAGE_NAME);
        Field snField = doc.getField(FIELD_BINARY_NAME);
        if (snField == null) {
            return null;
        }
        String tmp = snField.stringValue();
        String snName = tmp.substring(0, tmp.length() - 1);
        if (pkgField == null) {
            return snName;
        }
        return pkgField.stringValue() + '.' + snName;
    }

    public static String getSimpleBinaryName(Document doc) {
        assert (doc != null);
        Field field = doc.getField(FIELD_BINARY_NAME);
        if (field == null) {
            return null;
        }
        return field.stringValue();
    }

    public static String getPackageName(Document doc) {
        assert (doc != null);
        Field field = doc.getField(FIELD_PACKAGE_NAME);
        return field == null ? null : field.stringValue();
    }

    static String getRefereneType(Document doc, String className) {
        assert (doc != null);
        assert (className != null);
        Field[] fields = doc.getFields(FIELD_REFERENCES);
        assert (fields != null);
        for (Field field : fields) {
            String rawUsage = field.stringValue();
            int rawUsageLen = rawUsage.length();
            assert (rawUsageLen > SIZE);
            int index = rawUsageLen - SIZE;
            String usageName = rawUsage.substring(0, index);
            String map = rawUsage.substring(index);
            if (!className.equals(usageName)) continue;
            return map;
        }
        return null;
    }

    public static List<String> getReferences(Document doc) {
        assert (doc != null);
        Field[] fields = doc.getFields(FIELD_REFERENCES);
        assert (fields != null);
        ArrayList<String> result = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            result.add(field.stringValue());
        }
        return result;
    }

    public static long getTimeStamp(Document doc) throws ParseException {
        assert (doc != null);
        Field field = doc.getField(FIELD_TIME_STAMP);
        assert (field != null);
        String data = field.stringValue();
        assert (data != null);
        return DateTools.stringToTime((String)data);
    }

    public static Query binaryNameQuery(String resourceName) {
        String sName;
        String pkgName;
        BooleanQuery query = new BooleanQuery();
        int index = resourceName.lastIndexOf(46);
        if (index < 0) {
            pkgName = "";
            sName = resourceName;
        } else {
            pkgName = resourceName.substring(0, index);
            sName = resourceName.substring(index + 1);
        }
        sName = sName + '?';
        query.add((Query)new TermQuery(new Term(FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
        query.add((Query)new WildcardQuery(new Term(FIELD_BINARY_NAME, sName)), BooleanClause.Occur.MUST);
        return query;
    }

    public static Query binaryContentNameQuery(String resourceName) {
        String sName;
        String pkgName;
        int index = resourceName.lastIndexOf(46);
        if (index < 0) {
            pkgName = "";
            sName = resourceName;
        } else {
            pkgName = resourceName.substring(0, index);
            sName = resourceName.substring(index + 1);
        }
        BooleanQuery query = new BooleanQuery();
        BooleanQuery subQuery = new BooleanQuery();
        subQuery.add((Query)new WildcardQuery(new Term(FIELD_BINARY_NAME, sName + '?')), BooleanClause.Occur.SHOULD);
        subQuery.add((Query)new PrefixQuery(new Term(FIELD_BINARY_NAME, sName + '$')), BooleanClause.Occur.SHOULD);
        query.add((Query)new TermQuery(new Term(FIELD_PACKAGE_NAME, pkgName)), BooleanClause.Occur.MUST);
        query.add((Query)subQuery, BooleanClause.Occur.MUST);
        return query;
    }

    public static Term rootDocumentTerm() {
        return new Term(FIELD_RESOURCE_NAME, ROOT_NAME);
    }

    public static Document createDocument(String binaryName, long timeStamp, List<String> references) {
        String pkgName;
        String fileName;
        assert (binaryName != null);
        assert (references != null);
        int index = binaryName.lastIndexOf(46);
        if (index < 0) {
            fileName = binaryName;
            pkgName = "";
        } else {
            fileName = binaryName.substring(index + 1);
            pkgName = binaryName.substring(0, index);
        }
        index = fileName.lastIndexOf(36);
        String simpleName = index < 0 ? fileName.substring(0, fileName.length() - 1) : fileName.substring(index + 1, fileName.length() - 1);
        String caseInsensitiveName = simpleName.toLowerCase();
        Document doc = new Document();
        Field field = new Field(FIELD_BINARY_NAME, fileName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
        field = new Field(FIELD_PACKAGE_NAME, pkgName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        doc.add((Fieldable)field);
        field = new Field(FIELD_SIMPLE_NAME, simpleName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
        field = new Field(FIELD_CASE_INSENSITIVE_NAME, caseInsensitiveName, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
        for (String reference : references) {
            field = new Field(FIELD_REFERENCES, reference, Field.Store.YES, Field.Index.UN_TOKENIZED);
            doc.add((Fieldable)field);
        }
        return doc;
    }

    public static Document createRootTimeStampDocument(long timeStamp) {
        Document doc = new Document();
        Field field = new Field(FIELD_RESOURCE_NAME, ROOT_NAME, Field.Store.YES, Field.Index.UN_TOKENIZED);
        doc.add((Fieldable)field);
        field = new Field(FIELD_TIME_STAMP, DateTools.timeToString((long)timeStamp, (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NO);
        doc.add((Fieldable)field);
        return doc;
    }

    public static StringBuilder createUsage(String className) {
        Set<ClassIndexImpl.UsageType> EMPTY = Collections.emptySet();
        return DocumentUtil.encodeUsage(className, EMPTY, '-');
    }

    public static void addUsage(StringBuilder rawUsage, ClassIndexImpl.UsageType type) {
        assert (rawUsage != null);
        assert (type != null);
        int rawUsageLen = rawUsage.length();
        int startIndex = rawUsageLen - SIZE;
        rawUsage.setCharAt(startIndex + type.getOffset(), '+');
    }

    public static String encodeUsage(String className, Set<ClassIndexImpl.UsageType> usageTypes) {
        return DocumentUtil.encodeUsage(className, usageTypes, '-').toString();
    }

    private static StringBuilder encodeUsage(String className, Set<ClassIndexImpl.UsageType> usageTypes, char fill) {
        assert (className != null);
        assert (usageTypes != null);
        StringBuilder builder = new StringBuilder();
        builder.append(className);
        char[] map = new char[SIZE];
        Arrays.fill(map, fill);
        for (ClassIndexImpl.UsageType usageType : usageTypes) {
            int offset = usageType.getOffset();
            assert (offset >= 0 && offset < SIZE);
            map[offset] = 43;
        }
        builder.append(map);
        return builder;
    }

    public static String encodeUsage(String className, String usageMap) {
        assert (className != null);
        assert (usageMap != null);
        StringBuilder sb = new StringBuilder();
        sb.append(className);
        sb.append(usageMap);
        return sb.toString();
    }

    public static String decodeUsage(String rawUsage, Set<ClassIndexImpl.UsageType> usageTypes) {
        assert (rawUsage != null);
        assert (usageTypes != null);
        assert (usageTypes.isEmpty());
        int rawUsageLen = rawUsage.length();
        assert (rawUsageLen > SIZE);
        int index = rawUsageLen - SIZE;
        String className = rawUsage.substring(0, index);
        String map = rawUsage.substring(index);
        for (ClassIndexImpl.UsageType usageType : ClassIndexImpl.UsageType.values()) {
            if (map.charAt(usageType.getOffset()) != '+') continue;
            usageTypes.add(usageType);
        }
        return className;
    }

    static {
        Arrays.fill(MASK_ANY_USAGE, '?');
    }
}

