/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.hyperlink;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.gsf.GsfHtmlFormatter;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.LanguageRegistry;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsf.api.DataLoadersBridge;
import org.netbeans.modules.gsf.api.DeclarationFinder;
import org.netbeans.modules.gsf.api.ElementHandle;
import org.netbeans.modules.gsf.api.HtmlFormatter;
import org.netbeans.modules.gsf.api.OffsetRange;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.modules.gsfret.editor.hyperlink.DeclarationPopup;
import org.netbeans.modules.gsfret.editor.hyperlink.PopupUtil;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.netbeans.napi.gsfret.source.UiUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GoToSupport {
    static final boolean IM_FEELING_LUCKY = Boolean.getBoolean("gsf.im_feeling_lucky");

    private GoToSupport() {
    }

    public static String getGoToElementTooltip(Document doc, int offset) {
        return GoToSupport.perform(doc, offset, true);
    }

    public static String performGoTo(Document doc, int offset) {
        return GoToSupport.perform(doc, offset, false);
    }

    private static String perform(final Document doc, final int offset, final boolean tooltip) {
        if (SourceUtils.isScanInProgress()) {
            if (!tooltip) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GsfCompletionProvider.class, (String)"scanning-in-progress"));
                Toolkit.getDefaultToolkit().beep();
            }
            return null;
        }
        if (tooltip && PopupUtil.isPopupShowing()) {
            return null;
        }
        try {
            FileObject fo = GoToSupport.getFileObject(doc);
            if (fo == null) {
                return null;
            }
            Source js = Source.forFileObject(fo);
            if (js == null) {
                return null;
            }
            final String[] result = new String[1];
            js.runUserActionTask(new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController controller) throws Exception {
                    DeclarationFinder finder;
                    if (controller.toPhase(Phase.RESOLVED).compareTo(Phase.RESOLVED) < 0) {
                        return;
                    }
                    List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)doc, offset);
                    Language language = null;
                    for (Language l : list) {
                        if (l.getDeclarationFinder() == null) continue;
                        language = l;
                        break;
                    }
                    if (language != null && (finder = language.getDeclarationFinder()) != null) {
                        GoToSupport.getIdentifierSpan(doc, offset);
                        DeclarationFinder.DeclarationLocation location = finder.findDeclaration((CompilationInfo)controller, offset);
                        if (tooltip) {
                            String documentation;
                            ElementHandle element;
                            CodeCompletionHandler completer = language.getCompletionProvider();
                            if (location != DeclarationFinder.DeclarationLocation.NONE && completer != null && (element = location.getElement()) != null && (documentation = completer.document((CompilationInfo)controller, element)) != null) {
                                result[0] = "<html><body>" + documentation;
                            }
                            return;
                        }
                        if (location != DeclarationFinder.DeclarationLocation.NONE && location != null) {
                            URL url = location.getUrl();
                            String invalid = location.getInvalidMessage();
                            if (url != null) {
                                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
                            } else {
                                if (invalid != null) {
                                    StatusDisplayer.getDefault().setStatusText(invalid);
                                    Toolkit.getDefaultToolkit().beep();
                                    return;
                                }
                                if (!IM_FEELING_LUCKY && location.getAlternativeLocations().size() > 0 && !PopupUtil.isPopupShowing() && GoToSupport.chooseAlternatives(doc, offset, location.getAlternativeLocations())) {
                                    return;
                                }
                                UiUtils.open(location.getFileObject(), location.getOffset());
                                String desc = "Description not yet implemented";
                                result[0] = "<html><body>" + desc;
                            }
                            return;
                        }
                    }
                    Toolkit.getDefaultToolkit().beep();
                    result[0] = null;
                }
            }, true);
            return result[0];
        }
        catch (IOException ioe) {
            throw new IllegalStateException(ioe);
        }
    }

    private static JTextComponent findEditor(Document doc) {
        JTextComponent comp = EditorRegistry.lastFocusedComponent();
        if (comp.getDocument() == doc) {
            return comp;
        }
        List componentList = EditorRegistry.componentList();
        for (JTextComponent component : componentList) {
            if (comp.getDocument() != doc) continue;
            return comp;
        }
        return null;
    }

    private static boolean chooseAlternatives(Document doc, int offset, List<DeclarationFinder.AlternativeLocation> alternatives) {
        Collections.sort(alternatives);
        int MAX_COUNT = 30;
        String previous = "";
        GsfHtmlFormatter formatter = new GsfHtmlFormatter();
        int count = 0;
        ArrayList<DeclarationFinder.AlternativeLocation> pruned = new ArrayList<DeclarationFinder.AlternativeLocation>(alternatives.size());
        for (DeclarationFinder.AlternativeLocation alt : alternatives) {
            String s = alt.getDisplayHtml((HtmlFormatter)formatter);
            if (s.equals(previous)) continue;
            pruned.add(alt);
            previous = s;
            if (++count != MAX_COUNT) continue;
            break;
        }
        if ((alternatives = pruned).size() <= 1) {
            return false;
        }
        JTextComponent target = GoToSupport.findEditor(doc);
        if (target != null) {
            try {
                Rectangle rectangle = target.modelToView(offset);
                Point point = new Point(rectangle.x, rectangle.y + rectangle.height);
                SwingUtilities.convertPointToScreen(point, target);
                String caption = NbBundle.getMessage(GoToSupport.class, (String)"ChooseDecl");
                PopupUtil.showPopup(new DeclarationPopup(caption, alternatives), caption, point.x, point.y, true, 0);
                return true;
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return false;
    }

    private static FileObject getFileObject(Document doc) {
        return DataLoadersBridge.getDefault().getFileObject(doc);
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        return GoToSupport.getIdentifierSpan(doc, offset);
    }

    public static int[] getIdentifierSpan(Document doc, int offset) {
        if (SourceUtils.isScanInProgress()) {
            return null;
        }
        FileObject fo = GoToSupport.getFileObject(doc);
        if (fo == null) {
            return null;
        }
        List<Language> list = LanguageRegistry.getInstance().getEmbeddedLanguages((BaseDocument)doc, offset);
        Language language = null;
        for (Language l : list) {
            if (l.getDeclarationFinder() == null) continue;
            language = l;
            break;
        }
        if (language == null) {
            return null;
        }
        DeclarationFinder finder = language.getDeclarationFinder();
        assert (finder != null);
        OffsetRange range = finder.getReferenceSpan(doc, offset);
        if (range != OffsetRange.NONE) {
            return new int[]{range.getStart(), range.getEnd()};
        }
        return null;
    }
}

