/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsfret.editor.codetemplates;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.editor.codetemplates.api.CodeTemplate;
import org.netbeans.lib.editor.codetemplates.spi.CodeTemplateFilter;
import org.netbeans.modules.gsf.api.CancellableTask;
import org.netbeans.modules.gsf.api.CodeCompletionHandler;
import org.netbeans.modules.gsf.api.CompilationInfo;
import org.netbeans.modules.gsfret.editor.completion.GsfCompletionProvider;
import org.netbeans.napi.gsfret.source.CompilationController;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.netbeans.napi.gsfret.source.SourceUtils;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class GsfCodeTemplateFilter
implements CodeTemplateFilter,
CancellableTask<CompilationController> {
    private int startOffset;
    private int endOffset;
    private Set<String> templates;
    private static final Set<String> DISABLED_TYPES = new HashSet<String>();

    private GsfCodeTemplateFilter(JTextComponent component, int offset) {
        this.startOffset = offset;
        this.endOffset = component.getSelectionStart() == offset ? component.getSelectionEnd() : -1;
        Source js = Source.forDocument(component.getDocument());
        if (js != null) {
            try {
                if (SourceUtils.isScanInProgress()) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GsfCodeTemplateFilter.class, (String)"JCT-scanning-in-progress"));
                    Toolkit.getDefaultToolkit().beep();
                } else if (GsfCodeTemplateFilter.isDisabled(js)) {
                    this.templates = Collections.emptySet();
                } else {
                    js.runUserActionTask(this, true);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean accept(CodeTemplate template) {
        if (this.templates != null && template != null && template.getParametrizedText().indexOf("${selection") != -1) {
            return this.templates.contains(template.getAbbreviation()) || template.getParametrizedText().indexOf("allowSurround") != -1;
        }
        return true;
    }

    public void cancel() {
    }

    public synchronized void run(CompilationController controller) throws IOException {
        controller.toPhase(Phase.PARSED);
        CodeCompletionHandler completer = GsfCompletionProvider.getCompletable(controller, this.startOffset);
        if (completer != null) {
            this.templates = completer.getApplicableTemplates((CompilationInfo)controller, this.startOffset, this.endOffset);
        }
    }

    private static boolean isDisabled(Source source) {
        boolean disabled = false;
        for (FileObject file : source.getFileObjects()) {
            if (!DISABLED_TYPES.contains(file.getMIMEType())) continue;
            disabled = true;
            break;
        }
        return disabled;
    }

    static {
        Collections.addAll(DISABLED_TYPES, "text/x-groovy", "text/x-gsp");
    }

    public static final class Factory
    implements CodeTemplateFilter.Factory {
        public CodeTemplateFilter createFilter(JTextComponent component, int offset) {
            return new GsfCodeTemplateFilter(component, offset);
        }
    }
}

