/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class JRubyObjectInputStream
extends RubyObject {
    JRubyObjectInputStreamImpl impl;
    private static final ObjectAllocator JROIS_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new JRubyObjectInputStream(runtime, klass);
        }
    };

    public static RubyClass createJRubyObjectInputStream(Ruby runtime) {
        RubyClass result = runtime.defineClass("JRubyObjectInputStream", runtime.getObject(), JROIS_ALLOCATOR);
        result.defineAnnotatedMethods(JRubyObjectInputStream.class);
        return result;
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args, Block block) {
        IRubyObject obj = ((RubyClass)recv).allocate();
        obj.callMethod(recv.getRuntime().getCurrentContext(), "initialize", args, block);
        return obj;
    }

    public JRubyObjectInputStream(Ruby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject wrappedStream) throws IOException {
        InputStream stream = (InputStream)JavaUtil.convertRubyToJava(wrappedStream, InputStream.class);
        this.impl = new JRubyObjectInputStreamImpl(this.getRuntime(), stream);
        return this;
    }

    @JRubyMethod(name={"read_object"}, alias={"readObject"})
    public IRubyObject readObject() throws IOException, ClassNotFoundException {
        return JavaObject.wrap(this.getRuntime(), this.impl.readObject());
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close() throws IOException {
        this.impl.close();
        return this;
    }

    class JRubyObjectInputStreamImpl
    extends ObjectInputStream {
        protected Ruby runtime;

        public JRubyObjectInputStreamImpl(Ruby rt, InputStream in) throws IOException {
            super(in);
            this.runtime = rt;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.runtime.getJRubyClassLoader());
        }
    }
}

