/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport.proxy;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"Java::JavaProxyClass"})
public class JavaProxyReflectionObject
extends RubyObject {
    public JavaProxyReflectionObject(Ruby runtime, RubyClass metaClass) {
        super(runtime, metaClass, false);
    }

    protected static void registerRubyMethods(Ruby runtime, RubyClass result) {
        result.defineAnnotatedMethods(JavaProxyReflectionObject.class);
        result.getMetaClass().defineAlias("__j_allocate", "allocate");
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    @JRubyMethod(name={"==", "eql?"})
    public IRubyObject op_equal(IRubyObject other) {
        if (!(other instanceof JavaProxyReflectionObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        boolean isEqual = this.equals(other);
        return isEqual ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    @Override
    public boolean equals(Object other) {
        return this == other;
    }

    @JRubyMethod(name={"equal?"})
    public IRubyObject same(IRubyObject other) {
        if (!(other instanceof JavaObject) && !((other = other.getInstanceVariables().fastGetInstanceVariable("@java_object")) instanceof JavaObject)) {
            return this.getRuntime().getFalse();
        }
        boolean isSame = this == other;
        return isSame ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    @JRubyMethod
    public RubyString java_type() {
        return this.getRuntime().newString(this.getJavaClass().getName());
    }

    @JRubyMethod
    public IRubyObject java_class() {
        return JavaClass.get(this.getRuntime(), this.getJavaClass());
    }

    @JRubyMethod
    public RubyFixnum length() {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject aref(IRubyObject index) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject aset(IRubyObject index, IRubyObject someValue) {
        throw this.getRuntime().newTypeError("not a java array");
    }

    @JRubyMethod(name={"java_proxy?"})
    public IRubyObject is_java_proxy() {
        return this.getRuntime().getFalse();
    }

    protected RubyArray buildRubyArray(IRubyObject[] constructors) {
        RubyArray result = this.getRuntime().newArray(constructors.length);
        for (int i = 0; i < constructors.length; ++i) {
            result.append(constructors[i]);
        }
        return result;
    }

    protected RubyArray buildRubyArray(Class[] classes) {
        RubyArray result = this.getRuntime().newArray(classes.length);
        for (int i = 0; i < classes.length; ++i) {
            result.append(JavaClass.get(this.getRuntime(), classes[i]));
        }
        return result;
    }
}

