/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyFloat;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyNil;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubyTime;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.java.proxies.JavaProxy;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaConstructor;
import org.jruby.nb.javasupport.JavaField;
import org.jruby.nb.javasupport.JavaMethod;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.TypeConverter;
import org.jruby.util.ByteList;

public class JavaUtil {
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            return rubyObject.isTrue();
        }
    };
    public static final RubyConverter RUBY_BYTE_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Byte((byte)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Byte(0);
        }
    };
    public static final RubyConverter RUBY_SHORT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Short((short)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Short(0);
        }
    };
    public static final RubyConverter RUBY_CHAR_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Character((char)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Character('\u0000');
        }
    };
    public static final RubyConverter RUBY_INTEGER_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Integer((int)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Integer(0);
        }
    };
    public static final RubyConverter RUBY_LONG_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_i")) {
                return new Long(((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_I, "to_i")).getLongValue());
            }
            return new Long(0L);
        }
    };
    public static final RubyConverter RUBY_FLOAT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_f")) {
                return new Float((float)((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Float(0.0);
        }
    };
    public static final RubyConverter RUBY_DOUBLE_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject.respondsTo("to_f")) {
                return new Double(((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue());
            }
            return new Double(0.0);
        }
    };
    public static final RubyConverter ARRAY_BOOLEAN_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject == context.getRuntime().getFalse() || rubyObject.isNil()) {
                return Boolean.FALSE;
            }
            if (rubyObject == context.getRuntime().getTrue()) {
                return Boolean.TRUE;
            }
            if (rubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)rubyObject).getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            if (rubyObject instanceof RubyString) {
                return Boolean.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return integer.getLongValue() == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_BYTE_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return (byte)((RubyNumeric)rubyObject).getLongValue();
            }
            if (rubyObject instanceof RubyString) {
                return Byte.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return (byte)integer.getLongValue();
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_SHORT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return (short)((RubyNumeric)rubyObject).getLongValue();
            }
            if (rubyObject instanceof RubyString) {
                return Short.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return (short)integer.getLongValue();
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_CHAR_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return Character.valueOf((char)((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject instanceof RubyString) {
                return Character.valueOf(rubyObject.asJavaString().charAt(0));
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return Character.valueOf((char)integer.getLongValue());
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_INT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return (int)((RubyNumeric)rubyObject).getLongValue();
            }
            if (rubyObject instanceof RubyString) {
                return Integer.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return (int)integer.getLongValue();
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_LONG_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)rubyObject).getLongValue();
            }
            if (rubyObject instanceof RubyString) {
                return Long.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return integer.getLongValue();
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_FLOAT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return Float.valueOf((float)((RubyNumeric)rubyObject).getDoubleValue());
            }
            if (rubyObject instanceof RubyString) {
                return Float.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return Float.valueOf((float)integer.getDoubleValue());
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_DOUBLE_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return ((RubyNumeric)rubyObject).getDoubleValue();
            }
            if (rubyObject instanceof RubyString) {
                return Double.valueOf(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return integer.getDoubleValue();
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_OBJECT_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyInteger) {
                long value = ((RubyInteger)rubyObject).getLongValue();
                if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                    return (int)value;
                }
                if (value >= Long.MIN_VALUE && value <= Long.MAX_VALUE) {
                    return value;
                }
                return new BigInteger(rubyObject.toString());
            }
            if (rubyObject instanceof RubyFloat) {
                return ((RubyFloat)rubyObject).getDoubleValue();
            }
            if (rubyObject instanceof JavaProxy) {
                return ((JavaProxy)rubyObject).unwrap();
            }
            return JavaUtil.java_to_ruby(context.getRuntime(), rubyObject);
        }
    };
    public static final RubyConverter ARRAY_CLASS_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof JavaClass) {
                return ((JavaClass)rubyObject).javaClass();
            }
            return JavaUtil.java_to_ruby(context.getRuntime(), rubyObject);
        }
    };
    public static final RubyConverter ARRAY_STRING_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyString) {
                return ((RubyString)rubyObject).getUnicodeValue();
            }
            return rubyObject.toString();
        }
    };
    public static final RubyConverter ARRAY_BIGINTEGER_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject instanceof RubyString) {
                return new BigDecimal(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return BigInteger.valueOf(integer.getLongValue());
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final RubyConverter ARRAY_BIGDECIMAL_CONVERTER = new RubyConverter(){

        @Override
        public Object convert(ThreadContext context, IRubyObject rubyObject) {
            if (rubyObject instanceof RubyNumeric) {
                return BigDecimal.valueOf(((RubyNumeric)rubyObject).getDoubleValue());
            }
            if (rubyObject instanceof RubyString) {
                return new BigDecimal(rubyObject.asJavaString());
            }
            if (rubyObject instanceof JavaProxy) {
                return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
            }
            if (rubyObject.respondsTo("to_f")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_f");
                return BigDecimal.valueOf(integer.getDoubleValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyInteger integer = (RubyInteger)RuntimeHelpers.invoke(context, rubyObject, "to_i");
                return BigDecimal.valueOf(integer.getLongValue());
            }
            return JavaUtil.ruby_to_java(rubyObject, rubyObject, Block.NULL_BLOCK);
        }
    };
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final Map<Class, RubyConverter> ARRAY_CONVERTERS = new HashMap<Class, RubyConverter>();
    public static final JavaConverter JAVA_DEFAULT_CONVERTER;
    public static final JavaConverter JAVA_BOOLEAN_CONVERTER;
    public static final JavaConverter JAVA_FLOAT_CONVERTER;
    public static final JavaConverter JAVA_DOUBLE_CONVERTER;
    public static final JavaConverter JAVA_CHAR_CONVERTER;
    public static final JavaConverter JAVA_BYTE_CONVERTER;
    public static final JavaConverter JAVA_SHORT_CONVERTER;
    public static final JavaConverter JAVA_INT_CONVERTER;
    public static final JavaConverter JAVA_LONG_CONVERTER;
    public static final JavaConverter JAVA_STRING_CONVERTER;
    public static final JavaConverter BYTELIST_CONVERTER;
    public static final JavaConverter JAVA_BIGINTEGER_CONVERTER;
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS;
    private static final Pattern JAVA_PROPERTY_CHOPPER;
    private static final Pattern CAMEL_CASE_SPLITTER;
    private static final Pattern RUBY_CASE_SPLITTER;

    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, Object.class);
    }

    public static RubyConverter getArrayConverter(Class type) {
        RubyConverter converter = ARRAY_CONVERTERS.get(type);
        if (converter == null) {
            return ARRAY_OBJECT_CONVERTER;
        }
        return converter;
    }

    public static byte convertRubyToJavaByte(IRubyObject rubyObject) {
        return (Byte)JavaUtil.convertRubyToJava(rubyObject, Byte.TYPE);
    }

    public static short convertRubyToJavaShort(IRubyObject rubyObject) {
        return (Short)JavaUtil.convertRubyToJava(rubyObject, Short.TYPE);
    }

    public static char convertRubyToJavaChar(IRubyObject rubyObject) {
        return ((Character)JavaUtil.convertRubyToJava(rubyObject, Character.TYPE)).charValue();
    }

    public static int convertRubyToJavaInt(IRubyObject rubyObject) {
        return (Integer)JavaUtil.convertRubyToJava(rubyObject, Integer.TYPE);
    }

    public static long convertRubyToJavaLong(IRubyObject rubyObject) {
        return (Long)JavaUtil.convertRubyToJava(rubyObject, Long.TYPE);
    }

    public static float convertRubyToJavaFloat(IRubyObject rubyObject) {
        return ((Float)JavaUtil.convertRubyToJava(rubyObject, Float.TYPE)).floatValue();
    }

    public static double convertRubyToJavaDouble(IRubyObject rubyObject) {
        return (Double)JavaUtil.convertRubyToJava(rubyObject, Double.TYPE);
    }

    public static boolean convertRubyToJavaBoolean(IRubyObject rubyObject) {
        return (Boolean)JavaUtil.convertRubyToJava(rubyObject, Boolean.TYPE);
    }

    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (javaClass == Void.TYPE || rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        ThreadContext context = rubyObject.getRuntime().getCurrentContext();
        if (rubyObject.dataGetStruct() instanceof JavaObject) {
            rubyObject = (JavaObject)rubyObject.dataGetStruct();
        } else if (rubyObject.respondsTo("java_object")) {
            rubyObject = rubyObject.callMethod(context, "java_object");
        } else if (rubyObject.respondsTo("to_java_object")) {
            rubyObject = rubyObject.callMethod(context, "to_java_object");
        }
        if (rubyObject instanceof JavaObject) {
            Object value = ((JavaObject)rubyObject).getValue();
            return JavaUtil.convertArgument(rubyObject.getRuntime(), value, value.getClass());
        }
        if (javaClass == Object.class || javaClass == null) {
            javaClass = rubyObject.getJavaClass();
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        if (javaClass.isPrimitive()) {
            RubyConverter converter = RUBY_CONVERTERS.get(javaClass);
            if (converter != null) {
                return converter.convert(context, rubyObject);
            }
            String s = ((RubyString)TypeConverter.convertToType(rubyObject, rubyObject.getRuntime().getString(), "to_s", true)).getUnicodeValue();
            if (s.length() > 0) {
                return new Character(s.charAt(0));
            }
            return new Character('\u0000');
        }
        if (javaClass == String.class) {
            RubyString rubyString = (RubyString)rubyObject.callMethod(context, MethodIndex.TO_S, "to_s");
            ByteList bytes = rubyString.getByteList();
            try {
                return new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
            }
            catch (UnsupportedEncodingException uee) {
                return new String(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            }
        }
        if (javaClass == ByteList.class) {
            return rubyObject.convertToString().getByteList();
        }
        if (javaClass == BigInteger.class) {
            if (rubyObject instanceof RubyBignum) {
                return ((RubyBignum)rubyObject).getValue();
            }
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (javaClass == BigDecimal.class && !(rubyObject instanceof JavaObject) && rubyObject.respondsTo("to_f")) {
            double double_value = ((RubyNumeric)rubyObject.callMethod(context, MethodIndex.TO_F, "to_f")).getDoubleValue();
            return new BigDecimal(double_value);
        }
        try {
            return ((JavaObject)rubyObject).getValue();
        }
        catch (ClassCastException ex) {
            if (rubyObject.getRuntime().getDebug().isTrue()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    public static IRubyObject[] convertJavaArrayToRuby(Ruby runtime, Object[] objects) {
        if (objects == null) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            rubyObjects[i] = JavaUtil.convertJavaToRuby(runtime, objects[i]);
        }
        return rubyObjects;
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter converter = JAVA_CONVERTERS.get(clazz);
        if (converter == null) {
            converter = JAVA_DEFAULT_CONVERTER;
        }
        return converter;
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object) {
        if (object == null) {
            return runtime.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        return JavaUtil.convertJavaToRuby(runtime, object, object.getClass());
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, int i) {
        return runtime.newFixnum(i);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, long l) {
        return runtime.newFixnum(l);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, float f) {
        return runtime.newFloat(f);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, double d) {
        return runtime.newFloat(d);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, boolean b) {
        return runtime.newBoolean(b);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime, Object object, Class javaClass) {
        return JavaUtil.getJavaConverter(javaClass).convert(runtime, object);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby runtime, Object object) {
        if (object == null) {
            return runtime.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        JavaConverter converter = JAVA_CONVERTERS.get(object.getClass());
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime, object);
        }
        return converter.convert(runtime, object);
    }

    public static Class<?> primitiveToWrapper(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Void.TYPE) {
                return Void.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }

    public static Object convertArgument(Ruby runtime, Object argument, Class<?> parameterType) {
        RubyObject rubyObject;
        if (argument == null) {
            if (parameterType.isPrimitive()) {
                throw runtime.newTypeError("primitives do not accept null");
            }
            return null;
        }
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class<?> type = JavaUtil.primitiveToWrapper(parameterType);
        if (type == Void.class) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type == Long.class) {
                return new Long(number.longValue());
            }
            if (type == Integer.class) {
                return new Integer(number.intValue());
            }
            if (type == Byte.class) {
                return new Byte(number.byteValue());
            }
            if (type == Character.class) {
                return new Character((char)number.intValue());
            }
            if (type == Double.class) {
                return new Double(number.doubleValue());
            }
            if (type == Float.class) {
                return new Float(number.floatValue());
            }
            if (type == Short.class) {
                return new Short(number.shortValue());
            }
        }
        if (JavaUtil.isDuckTypeConvertable(argument.getClass(), parameterType) && !(rubyObject = (RubyObject)argument).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(runtime.getCurrentContext(), rubyObject, parameterType);
        }
        return argument;
    }

    public static boolean isDuckTypeConvertable(Class providedArgumentType, Class parameterType) {
        return parameterType.isInterface() && !parameterType.isAssignableFrom(providedArgumentType) && RubyObject.class.isAssignableFrom(providedArgumentType);
    }

    public static Object convertProcToInterface(ThreadContext context, RubyObject rubyObject, Class target) {
        Ruby runtime = context.getRuntime();
        RubyModule javaUtilities = runtime.getJavaSupport().getJavaUtilitiesModule();
        IRubyObject javaInterfaceModule = Java.get_interface_module(javaUtilities, JavaClass.get(runtime, target));
        if (!((RubyModule)javaInterfaceModule).isInstance(rubyObject)) {
            rubyObject.extend(new IRubyObject[]{javaInterfaceModule});
        }
        if (rubyObject instanceof RubyProc) {
            RubyClass singletonClass = rubyObject.getSingletonClass();
            singletonClass.addMethod("method_missing", new DynamicMethod(singletonClass, Visibility.PUBLIC, CallConfiguration.NO_FRAME_NO_SCOPE){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject[] newArgs;
                    if (!(self instanceof RubyProc)) {
                        throw context.getRuntime().newTypeError("interface impl method_missing for block used with non-Proc object");
                    }
                    RubyProc proc = (RubyProc)self;
                    if (args.length == 1) {
                        newArgs = IRubyObject.NULL_ARRAY;
                    } else {
                        newArgs = new IRubyObject[args.length - 1];
                        System.arraycopy(args, 1, newArgs, 0, args.length - 1);
                    }
                    return proc.call(context, newArgs);
                }

                @Override
                public DynamicMethod dup() {
                    return this;
                }
            });
        }
        JavaObject jo = (JavaObject)RuntimeHelpers.invoke(context, rubyObject, "__jcreate_meta!");
        return jo.getValue();
    }

    public static Object convertArgumentToType(ThreadContext context, IRubyObject arg, Class target) {
        if (arg instanceof JavaObject) {
            return JavaUtil.coerceJavaObjectToType(context, ((JavaObject)arg).getValue(), target);
        }
        if (arg.dataGetStruct() instanceof JavaObject) {
            JavaObject innerWrapper = (JavaObject)arg.dataGetStruct();
            context.getRuntime().getJavaSupport().getObjectProxyCache().put(innerWrapper.getValue(), arg);
            return innerWrapper.getValue();
        }
        switch (arg.getMetaClass().index) {
            case 5: {
                return JavaUtil.coerceNilToType((RubyNil)arg, target);
            }
            case 1: {
                return JavaUtil.coerceFixnumToType((RubyFixnum)arg, target);
            }
            case 2: {
                return JavaUtil.coerceBignumToType((RubyBignum)arg, target);
            }
            case 11: {
                return JavaUtil.coerceFloatToType((RubyFloat)arg, target);
            }
            case 4: {
                return JavaUtil.coerceStringToType((RubyString)arg, target);
            }
            case 6: {
                return Boolean.TRUE;
            }
            case 7: {
                return Boolean.FALSE;
            }
            case 19: {
                return ((RubyTime)arg).getJavaDate();
            }
        }
        return JavaUtil.coerceOtherToType(context, arg, target);
    }

    public static Object coerceJavaObjectToType(ThreadContext context, Object javaObject, Class target) {
        if (javaObject != null && JavaUtil.isDuckTypeConvertable(javaObject.getClass(), target)) {
            RubyObject rubyObject = (RubyObject)javaObject;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(context, rubyObject, target);
            }
            return javaObject;
        }
        return javaObject;
    }

    public static Object coerceNilToType(RubyNil nil, Class target) {
        if (target.isPrimitive()) {
            throw nil.getRuntime().newTypeError("primitives do not accept null");
        }
        return null;
    }

    public static Object coerceFixnumToType(RubyFixnum fixnum, Class target) {
        if (target.isPrimitive()) {
            if (target == Integer.TYPE) {
                return (int)fixnum.getLongValue();
            }
            if (target == Double.TYPE) {
                return (double)fixnum.getLongValue();
            }
            if (target == Byte.TYPE) {
                return (byte)fixnum.getLongValue();
            }
            if (target == Character.TYPE) {
                return Character.valueOf((char)fixnum.getLongValue());
            }
            if (target == Float.TYPE) {
                return Float.valueOf(fixnum.getLongValue());
            }
            if (target == Long.TYPE) {
                return fixnum.getLongValue();
            }
            if (target == Short.TYPE) {
                return (short)fixnum.getLongValue();
            }
        }
        return fixnum.getLongValue();
    }

    public static Object coerceBignumToType(RubyBignum bignum, Class target) {
        if (target.isPrimitive()) {
            if (target == Integer.TYPE) {
                return (int)bignum.getLongValue();
            }
            if (target == Double.TYPE) {
                return (double)bignum.getLongValue();
            }
            if (target == Byte.TYPE) {
                return (byte)bignum.getLongValue();
            }
            if (target == Character.TYPE) {
                return Character.valueOf((char)bignum.getLongValue());
            }
            if (target == Float.TYPE) {
                return Float.valueOf(bignum.getLongValue());
            }
            if (target == Long.TYPE) {
                return bignum.getLongValue();
            }
            if (target == Short.TYPE) {
                return (short)bignum.getLongValue();
            }
        }
        return bignum.getValue();
    }

    public static Object coerceFloatToType(RubyFloat flote, Class target) {
        if (target.isPrimitive()) {
            if (target == Integer.TYPE) {
                return (int)flote.getLongValue();
            }
            if (target == Double.TYPE) {
                return flote.getDoubleValue();
            }
            if (target == Byte.TYPE) {
                return (byte)flote.getLongValue();
            }
            if (target == Character.TYPE) {
                return Character.valueOf((char)flote.getLongValue());
            }
            if (target == Float.TYPE) {
                return Float.valueOf((float)flote.getDoubleValue());
            }
            if (target == Long.TYPE) {
                return flote.getLongValue();
            }
            if (target == Short.TYPE) {
                return (short)flote.getLongValue();
            }
        }
        return flote.getDoubleValue();
    }

    public static Object coerceStringToType(RubyString string, Class target) {
        try {
            ByteList bytes = string.getByteList();
            return new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
        }
        catch (UnsupportedEncodingException uee) {
            return string.toString();
        }
    }

    public static Object coerceOtherToType(ThreadContext context, IRubyObject arg, Class target) {
        Ruby runtime = context.getRuntime();
        if (JavaUtil.isDuckTypeConvertable(arg.getClass(), target)) {
            RubyObject rubyObject = (RubyObject)arg;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(context, rubyObject, target);
            }
        } else if (arg.respondsTo("to_java_object")) {
            Object javaObject = arg.callMethod(context, "to_java_object");
            if (javaObject instanceof JavaObject) {
                runtime.getJavaSupport().getObjectProxyCache().put(((JavaObject)javaObject).getValue(), arg);
                javaObject = ((JavaObject)javaObject).getValue();
            }
            return javaObject;
        }
        return arg;
    }

    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime = recv.getRuntime();
        switch (object.getMetaClass().index) {
            case 5: {
                javaObject = null;
                break;
            }
            case 1: {
                javaObject = new Long(((RubyFixnum)object).getLongValue());
                break;
            }
            case 2: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case 11: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case 4: {
                try {
                    ByteList bytes = ((RubyString)object).getByteList();
                    javaObject = new String(bytes.unsafeBytes(), bytes.begin(), bytes.length(), "UTF8");
                }
                catch (UnsupportedEncodingException uee) {
                    javaObject = object.toString();
                }
                break;
            }
            case 6: {
                javaObject = Boolean.TRUE;
                break;
            }
            case 7: {
                javaObject = Boolean.FALSE;
                break;
            }
            case 19: {
                javaObject = ((RubyTime)object).getJavaDate();
                break;
            }
            default: {
                return object;
            }
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    public static IRubyObject java_to_ruby(Ruby runtime, IRubyObject object) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(runtime, ((JavaObject)object).getValue());
        }
        return object;
    }

    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result = (JavaObject)object.dataGetStruct();
            if (result == null) {
                result = object.callMethod(recv.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (result instanceof JavaObject) {
                recv.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)result).getValue(), object);
            }
            return result;
        }
        return JavaUtil.primitive_to_java(recv, object, unusedBlock);
    }

    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    public static boolean isJavaObject(IRubyObject candidate) {
        return candidate.dataGetStruct() instanceof JavaObject;
    }

    public static Object unwrapJavaObject(IRubyObject object) {
        return ((JavaObject)object.dataGetStruct()).getValue();
    }

    public static String getJavaPropertyName(String beanMethodName) {
        Matcher m = JAVA_PROPERTY_CHOPPER.matcher(beanMethodName);
        if (!m.find()) {
            return null;
        }
        String javaPropertyName = m.group(2).toLowerCase() + m.group(3);
        return javaPropertyName;
    }

    public static String getRubyCasedName(String javaCasedName) {
        Matcher m = CAMEL_CASE_SPLITTER.matcher(javaCasedName);
        return m.replaceAll("$1_$2").toLowerCase();
    }

    public static String getJavaCasedName(String javaCasedName) {
        Matcher m = RUBY_CASE_SPLITTER.matcher(javaCasedName);
        StringBuffer newName = new StringBuffer();
        if (!m.find()) {
            return null;
        }
        m.reset();
        while (m.find()) {
            m.appendReplacement(newName, m.group(1) + Character.toUpperCase(m.group(2).charAt(0)));
        }
        m.appendTail(newName);
        return newName.toString();
    }

    public static Set<String> getRubyNamesForJavaName(String javaName, List<Method> methods) {
        String javaPropertyName = JavaUtil.getJavaPropertyName(javaName);
        String rubyName = JavaUtil.getRubyCasedName(javaName);
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        nameSet.add(javaName);
        nameSet.add(rubyName);
        String rubyPropertyName = null;
        for (Method method : methods) {
            Class<?>[] argTypes = method.getParameterTypes();
            Class<?> resultType = method.getReturnType();
            int argCount = argTypes.length;
            if (javaPropertyName != null) {
                if (rubyName.startsWith("get_")) {
                    rubyPropertyName = rubyName.substring(4);
                    if (argCount != 0 && (argCount != 1 || argTypes[0] != Integer.TYPE)) continue;
                    nameSet.add(javaPropertyName);
                    nameSet.add(rubyPropertyName);
                    if (resultType != Boolean.TYPE) continue;
                    nameSet.add(javaPropertyName + '?');
                    nameSet.add(rubyPropertyName + '?');
                    continue;
                }
                if (rubyName.startsWith("set_")) {
                    rubyPropertyName = rubyName.substring(4);
                    if (argCount != 1 || resultType != Void.TYPE) continue;
                    nameSet.add(javaPropertyName + '=');
                    nameSet.add(rubyPropertyName + '=');
                    continue;
                }
                if (!rubyName.startsWith("is_")) continue;
                rubyPropertyName = rubyName.substring(3);
                if (resultType != Boolean.TYPE) continue;
                nameSet.add(javaPropertyName);
                nameSet.add(rubyPropertyName);
                nameSet.add(javaPropertyName + '?');
                nameSet.add(rubyPropertyName + '?');
                continue;
            }
            if (resultType != Boolean.TYPE) continue;
            nameSet.add(javaName + '?');
            nameSet.add(rubyName + '?');
        }
        return nameSet;
    }

    public static JavaObject unwrapJavaObject(Ruby runtime, IRubyObject convertee, String errorMessage) {
        IRubyObject obj = convertee;
        if (!(obj instanceof JavaObject)) {
            if (obj.dataGetStruct() != null && obj.dataGetStruct() instanceof JavaObject) {
                obj = (JavaObject)obj.dataGetStruct();
            } else {
                throw runtime.newTypeError(errorMessage);
            }
        }
        return (JavaObject)obj;
    }

    public static Object unwrapJavaValue(Ruby runtime, IRubyObject obj, String errorMessage) {
        if (obj instanceof JavaMethod) {
            return ((JavaMethod)obj).getValue();
        }
        if (obj instanceof JavaConstructor) {
            return ((JavaConstructor)obj).getValue();
        }
        if (obj instanceof JavaField) {
            return ((JavaField)obj).getValue();
        }
        if (obj instanceof JavaObject) {
            return ((JavaObject)obj).getValue();
        }
        if (obj.dataGetStruct() != null && obj.dataGetStruct() instanceof IRubyObject) {
            return JavaUtil.unwrapJavaValue(runtime, (IRubyObject)obj.dataGetStruct(), errorMessage);
        }
        throw runtime.newTypeError(errorMessage);
    }

    static {
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.class, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.TYPE, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.class, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.TYPE, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Short.class, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Short.TYPE, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Character.class, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Character.TYPE, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.class, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.TYPE, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Long.class, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Long.TYPE, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Float.class, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Float.TYPE, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Double.class, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Double.TYPE, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(String.class, ARRAY_STRING_CONVERTER);
        ARRAY_CONVERTERS.put(Class.class, ARRAY_CLASS_CONVERTER);
        ARRAY_CONVERTERS.put(BigInteger.class, ARRAY_BIGINTEGER_CONVERTER);
        ARRAY_CONVERTERS.put(BigDecimal.class, ARRAY_BIGDECIMAL_CONVERTER);
        JAVA_DEFAULT_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                if (object instanceof IRubyObject) {
                    return (IRubyObject)object;
                }
                return JavaObject.wrap(runtime, object);
            }
        };
        JAVA_BOOLEAN_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBoolean.newBoolean(runtime, (Boolean)object);
            }
        };
        JAVA_FLOAT_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, ((Float)object).doubleValue());
            }
        };
        JAVA_DOUBLE_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFloat.newFloat(runtime, (Double)object);
            }
        };
        JAVA_CHAR_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Character)object).charValue());
            }
        };
        JAVA_BYTE_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Byte)object).byteValue());
            }
        };
        JAVA_SHORT_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Short)object).shortValue());
            }
        };
        JAVA_INT_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, ((Integer)object).intValue());
            }
        };
        JAVA_LONG_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyFixnum.newFixnum(runtime, (Long)object);
            }
        };
        JAVA_STRING_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newUnicodeString(runtime, (String)object);
            }
        };
        BYTELIST_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyString.newString(runtime, (ByteList)object);
            }
        };
        JAVA_BIGINTEGER_CONVERTER = new JavaConverter(){

            @Override
            public IRubyObject convert(Ruby runtime, Object object) {
                if (object == null) {
                    return runtime.getNil();
                }
                return RubyBignum.newBignum(runtime, (BigInteger)object);
            }
        };
        JAVA_CONVERTERS = new HashMap<Class, JavaConverter>();
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
        JAVA_PROPERTY_CHOPPER = Pattern.compile("(get|set|is)([A-Z0-9])(.*)");
        CAMEL_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        RUBY_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)_([a-z])");
    }

    public static interface JavaConverter {
        public IRubyObject convert(Ruby var1, Object var2);
    }

    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }
}

