/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.javasupport;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.nb.MetaClass;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyClassPathVariable;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.java.MiniJava;
import org.jruby.nb.java.addons.ArrayJavaAddons;
import org.jruby.nb.java.addons.IOJavaAddons;
import org.jruby.nb.java.addons.KernelJavaAddons;
import org.jruby.nb.java.addons.StringJavaAddons;
import org.jruby.nb.java.proxies.ArrayJavaProxy;
import org.jruby.nb.java.proxies.ConcreteJavaProxy;
import org.jruby.nb.java.proxies.JavaInterfaceTemplate;
import org.jruby.nb.java.proxies.JavaProxy;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaArrayUtilities;
import org.jruby.nb.javasupport.JavaCallable;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaConstructor;
import org.jruby.nb.javasupport.JavaField;
import org.jruby.nb.javasupport.JavaMethod;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaProxyMethods;
import org.jruby.nb.javasupport.JavaSupport;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.ParameterTypes;
import org.jruby.nb.javasupport.proxy.JavaProxyClass;
import org.jruby.nb.javasupport.proxy.JavaProxyConstructor;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.util.ClassProvider;

@JRubyModule(name={"Java"})
public class Java
implements Library {
    private static final ClassProvider JAVA_PACKAGE_CLASS_PROVIDER;
    private static final Map<String, Boolean> JAVA_PRIMITIVES;
    private static final Pattern CAMEL_CASE_PACKAGE_SPLITTER;
    private static final CallableAcceptor Exact;
    private static final CallableAcceptor AssignableAndPrimitivable;
    private static final CallableAcceptor AssignableOrDuckable;

    @Override
    public void load(Ruby runtime, boolean wrap) throws IOException {
        Java.createJavaModule(runtime);
        runtime.getLoadService().smartLoad("builtin/javasupport");
        RubyClassPathVariable.createClassPathVariable(runtime);
    }

    public static RubyModule createJavaModule(Ruby runtime) {
        ThreadContext context = runtime.getCurrentContext();
        RubyModule javaModule = runtime.defineModule("Java");
        javaModule.defineAnnotatedMethods(Java.class);
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        JavaProxyMethods.createJavaProxyMethods(context);
        JavaProxy.createJavaProxy(context);
        ConcreteJavaProxy.createConcreteJavaProxy(context);
        ArrayJavaProxy.createArrayJavaProxy(context);
        JavaProxyClass.createJavaProxyModule(runtime);
        JavaInterfaceTemplate.createJavaInterfaceTemplateModule(context);
        RubyModule javaUtils = runtime.defineModule("JavaUtilities");
        javaUtils.defineAnnotatedMethods(JavaUtilities.class);
        runtime.getJavaSupport().setConcreteProxyCallback(new Callback(){

            @Override
            public IRubyObject execute(IRubyObject recv, IRubyObject[] args, Block block) {
                Arity.checkArgumentCount(recv.getRuntime(), args, 1, 1);
                return Java.concrete_proxy_inherited(recv, args[0]);
            }

            @Override
            public Arity getArity() {
                return Arity.ONE_ARGUMENT;
            }
        });
        JavaArrayUtilities.createJavaArrayUtilitiesModule(runtime);
        RubyClass javaProxy = runtime.defineClass("JavaProxy", runtime.getObject(), runtime.getObject().getAllocator());
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        runtime.getArray().defineAnnotatedMethods(ArrayJavaAddons.class);
        runtime.getKernel().defineAnnotatedMethods(KernelJavaAddons.class);
        runtime.getString().defineAnnotatedMethods(StringJavaAddons.class);
        runtime.getIO().defineAnnotatedMethods(IOJavaAddons.class);
        Java.addNameClassMappings(runtime, runtime.getJavaSupport().getNameClassMap());
        runtime.getJavaSupport().setObjectJavaClass(JavaClass.get(runtime, Object.class));
        runtime.getJavaSupport().setActive(true);
        return javaModule;
    }

    private static void addNameClassMappings(Ruby runtime, Map<String, JavaClass> nameClassMap) {
        JavaClass booleanPrimClass = JavaClass.get(runtime, Boolean.TYPE);
        JavaClass booleanClass = JavaClass.get(runtime, Boolean.class);
        nameClassMap.put("boolean", booleanPrimClass);
        nameClassMap.put("Boolean", booleanClass);
        nameClassMap.put("java.lang.Boolean", booleanClass);
        JavaClass bytePrimClass = JavaClass.get(runtime, Byte.TYPE);
        JavaClass byteClass = JavaClass.get(runtime, Byte.class);
        nameClassMap.put("byte", bytePrimClass);
        nameClassMap.put("Byte", byteClass);
        nameClassMap.put("java.lang.Byte", byteClass);
        JavaClass shortPrimClass = JavaClass.get(runtime, Short.TYPE);
        JavaClass shortClass = JavaClass.get(runtime, Short.class);
        nameClassMap.put("short", shortPrimClass);
        nameClassMap.put("Short", shortClass);
        nameClassMap.put("java.lang.Short", shortClass);
        JavaClass charPrimClass = JavaClass.get(runtime, Character.TYPE);
        JavaClass charClass = JavaClass.get(runtime, Character.class);
        nameClassMap.put("char", charPrimClass);
        nameClassMap.put("Character", charClass);
        nameClassMap.put("Char", charClass);
        nameClassMap.put("java.lang.Character", charClass);
        JavaClass intPrimClass = JavaClass.get(runtime, Integer.TYPE);
        JavaClass intClass = JavaClass.get(runtime, Integer.class);
        nameClassMap.put("int", intPrimClass);
        nameClassMap.put("Integer", intClass);
        nameClassMap.put("Int", intClass);
        nameClassMap.put("java.lang.Integer", intClass);
        JavaClass longPrimClass = JavaClass.get(runtime, Long.TYPE);
        JavaClass longClass = JavaClass.get(runtime, Long.class);
        nameClassMap.put("long", longPrimClass);
        nameClassMap.put("Long", longClass);
        nameClassMap.put("java.lang.Long", longClass);
        JavaClass floatPrimClass = JavaClass.get(runtime, Float.TYPE);
        JavaClass floatClass = JavaClass.get(runtime, Float.class);
        nameClassMap.put("float", floatPrimClass);
        nameClassMap.put("Float", floatClass);
        nameClassMap.put("java.lang.Float", floatClass);
        JavaClass doublePrimClass = JavaClass.get(runtime, Double.TYPE);
        JavaClass doubleClass = JavaClass.get(runtime, Double.class);
        nameClassMap.put("double", doublePrimClass);
        nameClassMap.put("Double", doubleClass);
        nameClassMap.put("java.lang.Double", doubleClass);
        JavaClass bigintClass = JavaClass.get(runtime, BigInteger.class);
        nameClassMap.put("big_int", bigintClass);
        nameClassMap.put("big_integer", bigintClass);
        nameClassMap.put("BigInteger", bigintClass);
        nameClassMap.put("java.math.BigInteger", bigintClass);
        JavaClass bigdecimalClass = JavaClass.get(runtime, BigDecimal.class);
        nameClassMap.put("big_decimal", bigdecimalClass);
        nameClassMap.put("BigDecimal", bigdecimalClass);
        nameClassMap.put("java.math.BigDecimal", bigdecimalClass);
        JavaClass objectClass = JavaClass.get(runtime, Object.class);
        nameClassMap.put("object", objectClass);
        nameClassMap.put("Object", objectClass);
        nameClassMap.put("java.lang.Object", objectClass);
        JavaClass stringClass = JavaClass.get(runtime, String.class);
        nameClassMap.put("string", stringClass);
        nameClassMap.put("String", stringClass);
        nameClassMap.put("java.lang.String", stringClass);
    }

    public static IRubyObject is_primitive_type(IRubyObject recv, IRubyObject sym) {
        return recv.getRuntime().newBoolean(JAVA_PRIMITIVES.containsKey(sym.asJavaString()));
    }

    public static IRubyObject create_proxy_class(IRubyObject recv, IRubyObject constant, IRubyObject javaClass, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw recv.getRuntime().newTypeError(module, recv.getRuntime().getModule());
        }
        return ((RubyModule)module).const_set(constant, Java.get_proxy_class(recv, javaClass));
    }

    public static IRubyObject get_java_class(IRubyObject recv, IRubyObject name) {
        try {
            return JavaClass.for_name(recv, name);
        }
        catch (Exception e) {
            return recv.getRuntime().getNil();
        }
    }

    public static IRubyObject new_instance_for(IRubyObject recv, IRubyObject java_object) {
        if (java_object instanceof JavaObject) {
            return Java.getInstance(((JavaObject)java_object).getValue(), (RubyClass)recv);
        }
        IRubyObject new_instance = ((RubyClass)recv).allocate();
        new_instance.getInstanceVariables().fastSetInstanceVariable("@java_object", java_object);
        new_instance.dataWrapStruct(java_object);
        return new_instance;
    }

    public static IRubyObject getInstance(Object rawJavaObject, RubyClass clazz) {
        return clazz.getRuntime().getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, clazz);
    }

    public static IRubyObject getInstance(Ruby runtime, Object rawJavaObject) {
        if (rawJavaObject != null) {
            return runtime.getJavaSupport().getObjectProxyCache().getOrCreate(rawJavaObject, (RubyClass)Java.getProxyClass(runtime, JavaClass.get(runtime, rawJavaObject.getClass())));
        }
        return runtime.getNil();
    }

    public static IRubyObject to_java_object(IRubyObject recv) {
        return recv.getInstanceVariables().fastGetInstanceVariable("@java_class");
    }

    @Deprecated
    public static IRubyObject add_proxy_extender(IRubyObject recv, IRubyObject extender) {
        recv.getRuntime().getWarnings().warn(IRubyWarnings.ID.DEPRECATED_METHOD, "JavaUtilities.add_proxy_extender is deprecated - use JavaUtilities.extend_proxy instead", "add_proxy_extender", "JavaUtilities.extend_proxy");
        IRubyObject javaClassVar = extender.getInstanceVariables().fastGetInstanceVariable("@java_class");
        if (!(javaClassVar instanceof JavaClass)) {
            throw recv.getRuntime().newArgumentError("extender does not have a valid @java_class");
        }
        ((JavaClass)javaClassVar).addProxyExtender(extender);
        return recv.getRuntime().getNil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getInterfaceModule(Ruby runtime, JavaClass javaClass) {
        if (!javaClass.javaClass().isInterface()) {
            throw runtime.newArgumentError(javaClass.toString() + " is not an interface");
        }
        RubyModule interfaceModule = javaClass.getProxyModule();
        if (interfaceModule != null) {
            return interfaceModule;
        }
        javaClass.lockProxy();
        try {
            interfaceModule = javaClass.getProxyModule();
            if (interfaceModule == null) {
                interfaceModule = (RubyModule)runtime.getJavaSupport().getJavaInterfaceTemplate().dup();
                interfaceModule.fastSetInstanceVariable("@java_class", javaClass);
                Java.addToJavaPackageModule(interfaceModule, javaClass);
                javaClass.setupInterfaceModule(interfaceModule);
                Class<?>[] extended = javaClass.javaClass().getInterfaces();
                int i = extended.length;
                while (--i >= 0) {
                    JavaClass extendedClass = JavaClass.get(runtime, extended[i]);
                    RubyModule extModule = Java.getInterfaceModule(runtime, extendedClass);
                    interfaceModule.includeModule(extModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return interfaceModule;
    }

    public static IRubyObject get_interface_module(IRubyObject recv, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime = recv.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        return Java.getInterfaceModule(runtime, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject get_deprecated_interface_proxy(ThreadContext context, IRubyObject recv, IRubyObject javaClassObject) {
        JavaClass javaClass;
        Ruby runtime = context.getRuntime();
        if (javaClassObject instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, javaClassObject);
        } else if (javaClassObject instanceof JavaClass) {
            javaClass = (JavaClass)javaClassObject;
        } else {
            throw runtime.newArgumentError("expected JavaClass, got " + javaClassObject);
        }
        if (!javaClass.javaClass().isInterface()) {
            throw runtime.newArgumentError("expected Java interface class, got " + javaClassObject);
        }
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                RubyModule interfaceModule = Java.getInterfaceModule(runtime, javaClass);
                RubyClass interfaceJavaProxy = runtime.fastGetClass("InterfaceJavaProxy");
                proxyClass = RubyClass.newClass(runtime, interfaceJavaProxy);
                proxyClass.setAllocator(interfaceJavaProxy.getAllocator());
                proxyClass.makeMetaClass(interfaceJavaProxy.getMetaClass());
                proxyClass.inherit(interfaceJavaProxy);
                proxyClass.callMethod(context, "java_class=", javaClass);
                proxyClass.includeModule(interfaceModule);
                javaClass.setupProxy(proxyClass);
                if (proxyClass.fastGetConstantAt("Includable") == null) {
                    proxyClass.fastSetConstant("Includable", interfaceModule);
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyModule getProxyClass(Ruby runtime, JavaClass javaClass) {
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        Class c = javaClass.javaClass();
        if (c.isInterface()) {
            return Java.getInterfaceModule(runtime, javaClass);
        }
        javaClass.lockProxy();
        try {
            proxyClass = javaClass.getProxyClass();
            if (proxyClass == null) {
                if (c.isArray()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getArrayProxyClass(), javaClass, true);
                } else if (c.isPrimitive()) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                } else if (c == Object.class) {
                    proxyClass = Java.createProxyClass(runtime, runtime.getJavaSupport().getConcreteProxyClass(), javaClass, true);
                    proxyClass.getMetaClass().defineFastMethod("inherited", runtime.getJavaSupport().getConcreteProxyCallback());
                    Java.addToJavaPackageModule(proxyClass, javaClass);
                } else {
                    proxyClass = Java.createProxyClass(runtime, (RubyClass)Java.getProxyClass(runtime, JavaClass.get(runtime, c.getSuperclass())), javaClass, false);
                    Class<?>[] interfaces = c.getInterfaces();
                    int i = interfaces.length;
                    while (--i >= 0) {
                        JavaClass ifc = JavaClass.get(runtime, interfaces[i]);
                        proxyClass.includeModule(Java.getInterfaceModule(runtime, ifc));
                    }
                    if (Modifier.isPublic(c.getModifiers())) {
                        Java.addToJavaPackageModule(proxyClass, javaClass);
                    }
                }
            }
        }
        finally {
            javaClass.unlockProxy();
        }
        return proxyClass;
    }

    public static IRubyObject get_proxy_class(IRubyObject recv, IRubyObject java_class_object) {
        JavaClass javaClass;
        Ruby runtime = recv.getRuntime();
        if (java_class_object instanceof RubyString) {
            javaClass = JavaClass.for_name(recv, java_class_object);
        } else if (java_class_object instanceof JavaClass) {
            javaClass = (JavaClass)java_class_object;
        } else {
            throw runtime.newTypeError(java_class_object, runtime.getJavaSupport().getJavaClassClass());
        }
        return Java.getProxyClass(runtime, javaClass);
    }

    private static RubyClass createProxyClass(Ruby runtime, RubyClass baseType, JavaClass javaClass, boolean invokeInherited) {
        RubyClass proxyClass = javaClass.getProxyClass();
        if (proxyClass != null) {
            return proxyClass;
        }
        RubyClass.checkInheritable(baseType);
        RubyClass superClass = baseType;
        proxyClass = RubyClass.newClass(runtime, superClass);
        proxyClass.makeMetaClass(superClass.getMetaClass());
        proxyClass.setAllocator(superClass.getAllocator());
        if (invokeInherited) {
            proxyClass.inherit(superClass);
        }
        proxyClass.callMethod(runtime.getCurrentContext(), "java_class=", javaClass);
        javaClass.setupProxy(proxyClass);
        return proxyClass;
    }

    public static IRubyObject concrete_proxy_inherited(IRubyObject recv, IRubyObject subclass) {
        Ruby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        JavaSupport javaSupport = runtime.getJavaSupport();
        RubyClass javaProxyClass = javaSupport.getJavaProxyClass().getMetaClass();
        RuntimeHelpers.invokeAs(tc, javaProxyClass, recv, "inherited", new IRubyObject[]{subclass}, CallType.SUPER, Block.NULL_BLOCK);
        return Java.setupJavaSubclass(tc, subclass, recv.callMethod(tc, "java_class"));
    }

    private static IRubyObject setupJavaSubclass(ThreadContext context, IRubyObject subclass, IRubyObject java_class) {
        Ruby runtime = context.getRuntime();
        if (!(subclass instanceof RubyClass)) {
            throw runtime.newTypeError(subclass, runtime.getClassClass());
        }
        RubyClass rubySubclass = (RubyClass)subclass;
        rubySubclass.getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", runtime.getNil());
        RubyClass subclassSingleton = rubySubclass.getSingletonClass();
        subclassSingleton.addReadWriteAttribute(context, "java_proxy_class");
        subclassSingleton.addMethod("java_interfaces", new JavaMethod.JavaMethodZero(subclassSingleton, Visibility.PUBLIC){

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
                IRubyObject javaInterfaces = self.getInstanceVariables().fastGetInstanceVariable("@java_interfaces");
                if (javaInterfaces != null) {
                    return javaInterfaces.dup();
                }
                return context.getRuntime().getNil();
            }
        });
        rubySubclass.addMethod("__jcreate!", new JavaMethod.JavaMethodNoBlock(subclassSingleton, Visibility.PUBLIC){
            private final Map<Integer, ParameterTypes> methodCache = new HashMap<Integer, ParameterTypes>();

            @Override
            public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
                IRubyObject proxyClass = self.getMetaClass().getInstanceVariables().fastGetInstanceVariable("@java_proxy_class");
                if (proxyClass == null || proxyClass.isNil()) {
                    proxyClass = JavaProxyClass.get_with_class(self, self.getMetaClass());
                    self.getMetaClass().getInstanceVariables().fastSetInstanceVariable("@java_proxy_class", proxyClass);
                }
                JavaProxyClass realProxyClass = (JavaProxyClass)proxyClass;
                RubyArray constructors = realProxyClass.constructors();
                ArrayList<JavaProxyConstructor> forArity = new ArrayList<JavaProxyConstructor>();
                for (int i = 0; i < constructors.size(); ++i) {
                    JavaProxyConstructor constructor = (JavaProxyConstructor)constructors.eltInternal(i);
                    if (constructor.getParameterTypes().length != args.length) continue;
                    forArity.add(constructor);
                }
                if (forArity.size() == 0) {
                    throw context.getRuntime().newArgumentError("wrong # of arguments for constructor");
                }
                JavaProxyConstructor matching = (JavaProxyConstructor)Java.matchingCallableArityN(self, this.methodCache, forArity.toArray(new JavaProxyConstructor[forArity.size()]), args, args.length);
                Object[] newArgs = new Object[args.length];
                Class<?>[] parameterTypes = matching.getParameterTypes();
                for (int i = 0; i < args.length; ++i) {
                    newArgs[i] = JavaUtil.convertArgumentToType(context, args[i], parameterTypes[i]);
                }
                JavaObject newObject = matching.newInstance(self, newArgs);
                return JavaUtilities.set_java_object(self, self, newObject);
            }
        });
        return runtime.getNil();
    }

    private static void addToJavaPackageModule(RubyModule proxyClass, JavaClass javaClass) {
        String className;
        String packageString;
        Class clazz = javaClass.javaClass();
        String fullName = clazz.getName();
        if (fullName == null) {
            return;
        }
        int endPackage = fullName.lastIndexOf(46);
        if (fullName.indexOf(36) != -1 || !Character.isUpperCase(fullName.charAt(endPackage + 1))) {
            return;
        }
        Ruby runtime = proxyClass.getRuntime();
        RubyModule packageModule = Java.getJavaPackageModule(runtime, packageString = endPackage < 0 ? "" : fullName.substring(0, endPackage));
        if (packageModule != null && packageModule.getConstantAt(className = fullName.substring(endPackage + 1)) == null) {
            packageModule.const_set(runtime.newSymbol(className), proxyClass);
        }
    }

    private static RubyModule getJavaPackageModule(Ruby runtime, String packageString) {
        String packageName;
        int length = packageString.length();
        if (length == 0) {
            packageName = "Default";
        } else {
            StringBuilder buf = new StringBuilder();
            int start = 0;
            int offset = 0;
            while (start < length) {
                offset = packageString.indexOf(46, start);
                if (offset == -1) {
                    offset = length;
                }
                buf.append(Character.toUpperCase(packageString.charAt(start))).append(packageString.substring(start + 1, offset));
                start = offset + 1;
            }
            packageName = buf.toString();
        }
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject packageModule = javaModule.getConstantAt(packageName);
        if (packageModule == null) {
            return Java.createPackageModule(javaModule, packageName, packageString);
        }
        if (packageModule instanceof RubyModule) {
            return (RubyModule)packageModule;
        }
        return null;
    }

    private static RubyModule createPackageModule(RubyModule parent, String name, String packageString) {
        Ruby runtime = parent.getRuntime();
        RubyModule packageModule = (RubyModule)runtime.getJavaSupport().getPackageModuleTemplate().dup();
        packageModule.fastSetInstanceVariable("@package_name", runtime.newString(packageString.length() > 0 ? packageString + '.' : packageString));
        packageModule.addClassProvider(JAVA_PACKAGE_CLASS_PROVIDER);
        parent.const_set(runtime.newSymbol(name), packageModule);
        MetaClass metaClass = (MetaClass)packageModule.getMetaClass();
        metaClass.setAttached(packageModule);
        return packageModule;
    }

    public static RubyModule getPackageModule(Ruby runtime, String name) {
        String packageName;
        RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
        IRubyObject value = javaModule.getConstantAt(name);
        if (value instanceof RubyModule) {
            return (RubyModule)value;
        }
        if ("Default".equals(name)) {
            packageName = "";
        } else {
            Matcher m = CAMEL_CASE_PACKAGE_SPLITTER.matcher(name);
            packageName = m.replaceAll("$1.$2").toLowerCase();
        }
        return Java.createPackageModule(javaModule, name, packageName);
    }

    public static IRubyObject get_package_module(IRubyObject recv, IRubyObject symObject) {
        return Java.getPackageModule(recv.getRuntime(), symObject.asJavaString());
    }

    public static IRubyObject get_package_module_dot_format(IRubyObject recv, IRubyObject dottedName) {
        Ruby runtime = recv.getRuntime();
        RubyModule module = Java.getJavaPackageModule(runtime, dottedName.asJavaString());
        return module == null ? runtime.getNil() : module;
    }

    public static RubyModule getProxyOrPackageUnderPackage(ThreadContext context, final Ruby runtime, RubyModule parentPackage, String sym) {
        IRubyObject packageNameObj = parentPackage.fastGetInstanceVariable("@package_name");
        if (packageNameObj == null) {
            throw runtime.newArgumentError("invalid package module");
        }
        String packageName = packageNameObj.asJavaString();
        String name = sym.trim().intern();
        if (name.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        String fullName = packageName + name;
        if (Character.isLowerCase(name.charAt(0))) {
            if (JAVA_PRIMITIVES.containsKey(name)) {
                throw runtime.newArgumentError("illegal package name component: " + name);
            }
            try {
                return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, fullName));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, fullName);
            if (packageModule == null) {
                return null;
            }
            final String ivarName = ("@__pkg__" + name).intern();
            parentPackage.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = parentPackage.getSingletonClass();
            singleton.addMethod(name, new org.jruby.nb.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject variable;
                    if (args.length != 0) {
                        Arity.raiseArgumentError(runtime, args.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime.getNil();
                }

                @Override
                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        return Java.getProxyClass(runtime, JavaClass.forNameVerbose(runtime, fullName));
    }

    public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv, IRubyObject parentPackage, IRubyObject sym) {
        Ruby runtime = recv.getRuntime();
        if (!(parentPackage instanceof RubyModule)) {
            throw runtime.newTypeError(parentPackage, runtime.getModule());
        }
        RubyModule result = Java.getProxyOrPackageUnderPackage(context, runtime, (RubyModule)parentPackage, sym.asJavaString());
        if (result != null) {
            return result;
        }
        return runtime.getNil();
    }

    public static RubyModule getTopLevelProxyOrPackage(ThreadContext context, final Ruby runtime, String sym) {
        String name = sym.trim().intern();
        if (name.length() == 0) {
            throw runtime.newArgumentError("empty class or package name");
        }
        if (Character.isLowerCase(name.charAt(0))) {
            try {
                return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, name));
            }
            catch (RaiseException re) {
                RubyException rubyEx = re.getException();
                if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                    RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            RubyModule packageModule = Java.getJavaPackageModule(runtime, name);
            if (packageModule == null) {
                return null;
            }
            RubyModule javaModule = runtime.getJavaSupport().getJavaModule();
            if (javaModule.getMetaClass().isMethodBound(name, false)) {
                return packageModule;
            }
            final String ivarName = ("@__pkg__" + name).intern();
            javaModule.fastSetInstanceVariable(ivarName, packageModule);
            RubyClass singleton = javaModule.getSingletonClass();
            singleton.addMethod(name, new org.jruby.nb.internal.runtime.methods.JavaMethod(singleton, Visibility.PUBLIC){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
                    IRubyObject variable;
                    if (args.length != 0) {
                        Arity.raiseArgumentError(runtime, args.length, 0, 0);
                    }
                    if ((variable = ((RubyModule)self).fastGetInstanceVariable(ivarName)) != null) {
                        return variable;
                    }
                    return runtime.getNil();
                }

                @Override
                public Arity getArity() {
                    return Arity.noArguments();
                }
            });
            return packageModule;
        }
        try {
            return Java.getProxyClass(runtime, JavaClass.forNameQuiet(runtime, name));
        }
        catch (RaiseException re) {
            RubyException rubyEx = re.getException();
            if (rubyEx.kind_of_p(context, runtime.getStandardError()).isTrue()) {
                RuntimeHelpers.setErrorInfo(runtime, runtime.getNil());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return Java.getPackageModule(runtime, name);
    }

    public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv, IRubyObject sym) {
        Ruby runtime = context.getRuntime();
        RubyModule result = Java.getTopLevelProxyOrPackage(context, runtime, sym.asJavaString());
        if (result != null) {
            return result;
        }
        return runtime.getNil();
    }

    public static IRubyObject matching_method(IRubyObject recv, IRubyObject methods, IRubyObject args) {
        Map matchCache = recv.getRuntime().getJavaSupport().getMatchCache();
        ArrayList arg_types = new ArrayList();
        int alen = ((RubyArray)args).getLength();
        IRubyObject[] aargs = ((RubyArray)args).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < alen; ++i) {
            if (aargs[i] instanceof JavaObject) {
                arg_types.add(((JavaClass)((JavaObject)aargs[i]).java_class()).javaClass());
                continue;
            }
            arg_types.add(aargs[i].getClass());
        }
        HashMap ms = (HashMap)matchCache.get(methods);
        if (ms == null) {
            ms = new HashMap();
            matchCache.put(methods, ms);
        } else {
            IRubyObject method = (IRubyObject)ms.get(arg_types);
            if (method != null) {
                return method;
            }
        }
        int mlen = ((RubyArray)methods).getLength();
        IRubyObject[] margs = ((RubyArray)methods).toJavaArrayMaybeUnsafe();
        for (int i = 0; i < 2; ++i) {
            for (int k = 0; k < mlen; ++k) {
                IRubyObject method = margs[k];
                List<Class<?>> types = Arrays.asList(((ParameterTypes)((Object)method)).getParameterTypes());
                if (arg_types.size() != types.size()) continue;
                if (((Object)types).equals(arg_types)) {
                    ms.put(arg_types, method);
                    return method;
                }
                boolean match = true;
                for (int j = 0; j < types.size(); ++j) {
                    if (JavaClass.assignable(types.get(j), (Class)arg_types.get(j)) && (i > 0 || Java.primitive_match(types.get(j), arg_types.get(j))) || JavaUtil.isDuckTypeConvertable((Class)arg_types.get(j), types.get(j))) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                ms.put(arg_types, method);
                return method;
            }
        }
        IRubyObject o1 = margs[0];
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
        }
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + arg_types + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
    }

    public static int argsHashCode(Object[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Object element : a) {
            result = 31 * result + (element == null ? 0 : element.getClass().hashCode());
        }
        return result;
    }

    public static int argsHashCode(Class[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (Class element : a) {
            result = 31 * result + (element == null ? 0 : element.hashCode());
        }
        return result;
    }

    public static int argsHashCode(IRubyObject a0) {
        return 31 + Java.classHashCode(a0);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1) {
        return 31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2) {
        return 31 * (31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1)) + Java.classHashCode(a2);
    }

    public static int argsHashCode(IRubyObject a0, IRubyObject a1, IRubyObject a2, IRubyObject a3) {
        return 31 * (31 * (31 * (31 + Java.classHashCode(a0)) + Java.classHashCode(a1)) + Java.classHashCode(a2)) + Java.classHashCode(a3);
    }

    private static int classHashCode(IRubyObject o) {
        return o == null ? 0 : o.getJavaClass().hashCode();
    }

    public static int argsHashCode(IRubyObject[] a) {
        if (a == null) {
            return 0;
        }
        int result = 1;
        for (IRubyObject element : a) {
            result = 31 * result + Java.classHashCode(element);
        }
        return result;
    }

    public static Class argClass(Object a) {
        if (a == null) {
            return Void.TYPE;
        }
        return a.getClass();
    }

    public static Class argClass(IRubyObject a) {
        if (a == null) {
            return Void.TYPE;
        }
        return a.getJavaClass();
    }

    public static JavaCallable matching_method_internal(IRubyObject recv, Map cache, JavaCallable[] methods, Object[] args, int len) {
        Class<?>[] types;
        int k;
        int signatureCode = Java.argsHashCode(args);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method != null) {
            return method;
        }
        int mlen = methods.length;
        block0: for (k = 0; k < mlen; ++k) {
            method = methods[k];
            types = method.getParameterTypes();
            if (len != types.length) continue;
            boolean same = true;
            int y = len;
            for (int x = 0; x < y; ++x) {
                if (types[x].equals(Java.argClass(args[x]))) continue;
                same = false;
                break;
            }
            if (same) {
                cache.put(signatureCode, method);
                return method;
            }
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], Java.argClass(args[j])) || !Java.primitive_match(types[j], Java.argClass(args[j]))) continue block0;
            }
            cache.put(signatureCode, method);
            return method;
        }
        block3: for (k = 0; k < mlen; ++k) {
            method = methods[k];
            types = method.getParameterTypes();
            if (len != types.length) continue;
            int m = len;
            for (int j = 0; j < m; ++j) {
                if (!JavaClass.assignable(types[j], Java.argClass(args[j])) && !JavaUtil.isDuckTypeConvertable(Java.argClass(args[j]), types[j])) continue block3;
            }
            cache.put(signatureCode, method);
            return method;
        }
        JavaCallable o1 = methods[0];
        ArrayList<Class> argTypes = new ArrayList<Class>(args.length);
        for (Object o : args) {
            argTypes.add(Java.argClass(o));
        }
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw recv.getRuntime().newNameError("no constructor with arguments matching " + argTypes + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
        }
        Thread.dumpStack();
        throw recv.getRuntime().newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + argTypes + " on object " + recv.callMethod(recv.getRuntime().getCurrentContext(), "inspect"), null);
    }

    private static JavaCallable findMatchingCallableForArgs(IRubyObject recv, Map cache, int signatureCode, JavaCallable[] methods, IRubyObject ... args) {
        JavaCallable method = Java.findCallable(methods, Exact, args);
        if (method == null) {
            method = Java.findCallable(methods, AssignableAndPrimitivable, args);
        }
        if (method == null) {
            method = Java.findCallable(methods, AssignableOrDuckable, args);
        }
        if (method == null) {
            throw Java.argTypesDoNotMatch(recv.getRuntime(), recv, methods, args);
        }
        cache.put(signatureCode, method);
        return method;
    }

    public static ParameterTypes matchingCallableArityN(IRubyObject recv, Map cache, ParameterTypes[] methods, IRubyObject[] args, int argsLength) {
        int signatureCode = Java.argsHashCode(args);
        ParameterTypes method = (ParameterTypes)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, args);
        }
        return method;
    }

    private static ParameterTypes findMatchingCallableForArgs(IRubyObject recv, Map cache, int signatureCode, ParameterTypes[] methods, IRubyObject ... args) {
        ParameterTypes method = Java.findCallable(methods, Exact, args);
        if (method == null) {
            method = Java.findCallable(methods, AssignableAndPrimitivable, args);
        }
        if (method == null) {
            method = Java.findCallable(methods, AssignableOrDuckable, args);
        }
        if (method == null) {
            throw Java.argTypesDoNotMatch(recv.getRuntime(), recv, methods, args);
        }
        cache.put(signatureCode, method);
        return method;
    }

    private static ParameterTypes findCallable(ParameterTypes[] callables, CallableAcceptor acceptor, IRubyObject ... args) {
        ParameterTypes bestCallable = null;
        int bestScore = -1;
        for (int k = 0; k < callables.length; ++k) {
            int currentScore;
            ParameterTypes callable = callables[k];
            Class<?>[] types = callable.getParameterTypes();
            if (!acceptor.accept(types, args) || (currentScore = Java.getExactnessScore(types, args)) <= bestScore) continue;
            bestCallable = callable;
            bestScore = currentScore;
        }
        return bestCallable;
    }

    private static int getExactnessScore(Class<?>[] types, IRubyObject[] args) {
        int count = 0;
        for (int i = 0; i < args.length; ++i) {
            if (types[i].equals(Java.argClass(args[i]))) continue;
            ++count;
        }
        return count;
    }

    private static RaiseException argTypesDoNotMatch(Ruby runtime, IRubyObject receiver, ParameterTypes[] methods, IRubyObject ... args) {
        ParameterTypes o1 = methods[0];
        ArrayList<Class> argTypes = new ArrayList<Class>(args.length);
        for (IRubyObject o : args) {
            argTypes.add(Java.argClass((Object)o));
        }
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw runtime.newNameError("no constructor with arguments matching " + argTypes + " on object " + receiver.callMethod(runtime.getCurrentContext(), "inspect"), null);
        }
        throw runtime.newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + argTypes + " on object " + receiver.callMethod(runtime.getCurrentContext(), "inspect"), null);
    }

    public static JavaCallable matchingCallableArityN(IRubyObject recv, Map cache, JavaCallable[] methods, IRubyObject[] args, int argsLength) {
        int signatureCode = Java.argsHashCode(args);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, args);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityOne(IRubyObject recv, Map cache, JavaCallable[] methods, IRubyObject arg0) {
        int signatureCode = Java.argsHashCode(arg0);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, arg0);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityTwo(IRubyObject recv, Map cache, JavaCallable[] methods, IRubyObject arg0, IRubyObject arg1) {
        int signatureCode = Java.argsHashCode(arg0, arg1);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, arg0, arg1);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityThree(IRubyObject recv, Map cache, JavaCallable[] methods, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        int signatureCode = Java.argsHashCode(arg0, arg1, arg2);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, arg0, arg1, arg2);
        }
        return method;
    }

    public static JavaCallable matchingCallableArityFour(IRubyObject recv, Map cache, JavaCallable[] methods, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        int signatureCode = Java.argsHashCode(arg0, arg1, arg2, arg3);
        JavaCallable method = (JavaCallable)cache.get(signatureCode);
        if (method == null) {
            method = Java.findMatchingCallableForArgs(recv, cache, signatureCode, methods, arg0, arg1, arg2, arg3);
        }
        return method;
    }

    private static JavaCallable findCallable(JavaCallable[] callables, CallableAcceptor acceptor, IRubyObject ... args) {
        for (int k = 0; k < callables.length; ++k) {
            JavaCallable callable = callables[k];
            Class<?>[] types = callable.getParameterTypes();
            if (!acceptor.accept(types, args)) continue;
            return callable;
        }
        return null;
    }

    private static boolean exactMatch(Class[] types, IRubyObject ... args) {
        for (int i = 0; i < types.length; ++i) {
            if (types[i].equals(Java.argClass(args[i]))) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableAndPrimitivable(Class[] types, IRubyObject ... args) {
        for (int i = 0; i < types.length; ++i) {
            if (Java.assignable(types[i], args[i]) && Java.primitivable(types[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignableOrDuckable(Class[] types, IRubyObject ... args) {
        for (int i = 0; i < types.length; ++i) {
            if (Java.assignable(types[i], args[i]) || Java.duckable(types[i], args[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean assignable(Class type, IRubyObject arg) {
        return JavaClass.assignable(type, Java.argClass(arg));
    }

    private static boolean primitivable(Class type, IRubyObject arg) {
        Class argClass = Java.argClass(arg);
        if (type.isPrimitive()) {
            if (type == Integer.TYPE || type == Long.TYPE || type == Short.TYPE || type == Character.TYPE) {
                return argClass == Long.TYPE || argClass == Byte.TYPE || argClass == Short.TYPE || argClass == Character.TYPE || argClass == Integer.TYPE || argClass == Long.class || argClass == Byte.class || argClass == Short.class || argClass == Character.class || argClass == Integer.class;
            }
            if (type == Float.TYPE || type == Double.TYPE) {
                return argClass == Double.TYPE || argClass == Float.TYPE || argClass == Float.class || argClass == Double.class;
            }
            if (type == Boolean.TYPE) {
                return argClass == Boolean.TYPE || argClass == Boolean.class;
            }
        }
        return false;
    }

    private static boolean duckable(Class type, IRubyObject arg) {
        return JavaUtil.isDuckTypeConvertable(Java.argClass(arg), type);
    }

    private static RaiseException argTypesDoNotMatch(Ruby runtime, IRubyObject receiver, JavaCallable[] methods, IRubyObject ... args) {
        JavaCallable o1 = methods[0];
        ArrayList<Class> argTypes = new ArrayList<Class>(args.length);
        for (IRubyObject o : args) {
            argTypes.add(Java.argClass((Object)o));
        }
        if (o1 instanceof JavaConstructor || o1 instanceof JavaProxyConstructor) {
            throw runtime.newNameError("no constructor with arguments matching " + argTypes + " on object " + receiver.callMethod(runtime.getCurrentContext(), "inspect"), null);
        }
        throw runtime.newNameError("no " + ((JavaMethod)o1).name() + " with arguments matching " + argTypes + " on object " + receiver.callMethod(runtime.getCurrentContext(), "inspect"), null);
    }

    public static IRubyObject access(IRubyObject recv, IRubyObject java_type) {
        int modifiers = ((JavaClass)java_type).javaClass().getModifiers();
        return recv.getRuntime().newString(Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : "private"));
    }

    public static IRubyObject valid_constant_name_p(IRubyObject recv, IRubyObject name) {
        RubyString sname = name.convertToString();
        if (sname.getByteList().length() == 0) {
            return recv.getRuntime().getFalse();
        }
        return Character.isUpperCase(sname.getByteList().charAt(0)) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
    }

    public static boolean primitive_match(Object v1, Object v2) {
        if (((Class)v1).isPrimitive()) {
            if (v1 == Integer.TYPE || v1 == Long.TYPE || v1 == Short.TYPE || v1 == Character.TYPE) {
                return v2 == Integer.class || v2 == Long.class || v2 == Short.class || v2 == Character.class;
            }
            if (v1 == Float.TYPE || v1 == Double.TYPE) {
                return v2 == Float.class || v2 == Double.class;
            }
            if (v1 == Boolean.TYPE) {
                return v2 == Boolean.class;
            }
            return false;
        }
        return true;
    }

    public static IRubyObject primitive_match(IRubyObject recv, IRubyObject t1, IRubyObject t2) {
        if (((JavaClass)t1).primitive_p().isTrue()) {
            Object v2;
            Object v1 = ((JavaObject)t1).getValue();
            return Java.primitive_match(v1, v2 = ((JavaObject)t2).getValue()) ? recv.getRuntime().getTrue() : recv.getRuntime().getFalse();
        }
        return recv.getRuntime().getTrue();
    }

    public static IRubyObject wrap(IRubyObject recv, IRubyObject java_object) {
        return Java.getInstance(recv.getRuntime(), ((JavaObject)java_object).getValue());
    }

    public static IRubyObject wrap(Ruby runtime, IRubyObject java_object) {
        return Java.getInstance(runtime, ((JavaObject)java_object).getValue());
    }

    @JRubyMethod(required=1, optional=1, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args, Block block) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : recv.getRuntime().newProc(Block.Type.PROC, block);
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        return JavaUtil.primitive_to_java(recv, object, unusedBlock);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_ruby(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_ruby(recv.getRuntime(), object);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        return JavaUtil.ruby_to_java(recv, object, unusedBlock);
    }

    @JRubyMethod(frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        return JavaUtil.java_to_primitive(recv, object, unusedBlock);
    }

    @JRubyMethod(required=1, rest=true, frame=true, module=true, visibility=Visibility.PRIVATE)
    @Deprecated
    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args, Block block) {
        RubyProc proc;
        int size = Arity.checkArgumentCount(recv.getRuntime(), args, 1, -1) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = recv.getRuntime().newProc(Block.Type.PROC, block);
            ++size;
        }
        Class[] interfaces = new Class[size];
        for (int i = 0; i < size; ++i) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected. got: " + args[i]);
            }
            interfaces[i] = ((JavaClass)args[i]).javaClass();
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJRubyClassLoader(), interfaces, new InvocationHandler(){
            private Map parameterTypeCache = new ConcurrentHashMap();

            @Override
            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                Class[] parameterTypes = (Class[])this.parameterTypeCache.get(method);
                if (parameterTypes == null) {
                    parameterTypes = method.getParameterTypes();
                    this.parameterTypeCache.put(method, parameterTypes);
                }
                int methodArgsLength = parameterTypes.length;
                String methodName = method.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && parameterTypes[0].equals(Object.class)) {
                    return proxy == nargs[0];
                }
                Ruby runtime = recv.getRuntime();
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(runtime, proxy);
                rubyArgs[1] = new JavaMethod(runtime, method);
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(runtime, nargs[i]);
                }
                return JavaUtil.convertArgument(runtime, proc.call(runtime.getCurrentContext(), rubyArgs), method.getReturnType());
            }
        }));
    }

    @JRubyMethod(required=2, frame=true, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject new_proxy_instance2(IRubyObject recv, IRubyObject wrapper, IRubyObject ifcs, Block block) {
        Class proxyImplClass;
        IRubyObject[] javaClasses = ((RubyArray)ifcs).toJavaArray();
        Ruby runtime = recv.getRuntime();
        Class[] interfaces = new Class[javaClasses.length];
        for (int i = 0; i < javaClasses.length; ++i) {
            if (!(javaClasses[i] instanceof JavaClass) || !((JavaClass)javaClasses[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected. got: " + javaClasses[i]);
            }
            interfaces[i] = ((JavaClass)javaClasses[i]).javaClass();
        }
        int interfacesHashCode = Java.argsHashCode(interfaces);
        interfacesHashCode = wrapper.getMetaClass().isSingleton() && wrapper.getMetaClass().getRealClass() == runtime.getProc() ? 31 * interfacesHashCode + runtime.getProc().hashCode() : 31 * interfacesHashCode + wrapper.getMetaClass().hashCode();
        String implClassName = "InterfaceImpl" + interfacesHashCode;
        try {
            proxyImplClass = Class.forName(implClassName, true, runtime.getJRubyClassLoader());
        }
        catch (ClassNotFoundException cnfe) {
            proxyImplClass = MiniJava.createOldStyleImplClass(interfaces, wrapper.getMetaClass(), runtime, implClassName);
        }
        try {
            Constructor proxyConstructor = proxyImplClass.getConstructor(IRubyObject.class);
            return JavaObject.wrap(recv.getRuntime(), proxyConstructor.newInstance(wrapper));
        }
        catch (NoSuchMethodException nsme) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + nsme);
        }
        catch (InvocationTargetException ite) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ite);
        }
        catch (InstantiationException ie) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + ie);
        }
        catch (IllegalAccessException iae) {
            throw runtime.newTypeError("Exception instantiating generated interface impl:\n" + iae);
        }
    }

    static {
        String[] primitives;
        JAVA_PACKAGE_CLASS_PROVIDER = new ClassProvider(){

            @Override
            public RubyClass defineClassUnder(RubyModule pkg, String name, RubyClass superClazz) {
                if (superClazz != null) {
                    return null;
                }
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyClass)Java.get_proxy_class(runtime.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name));
            }

            @Override
            public RubyModule defineModuleUnder(RubyModule pkg, String name) {
                IRubyObject packageName = pkg.getInstanceVariables().fastGetInstanceVariable("@package_name");
                if (packageName == null) {
                    return null;
                }
                Ruby runtime = pkg.getRuntime();
                return (RubyModule)Java.get_interface_module(runtime.getJavaSupport().getJavaUtilitiesModule(), JavaClass.forNameVerbose(runtime, packageName.asJavaString() + name));
            }
        };
        JAVA_PRIMITIVES = new HashMap<String, Boolean>();
        for (String primitive : primitives = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double"}) {
            JAVA_PRIMITIVES.put(primitive, Boolean.TRUE);
        }
        CAMEL_CASE_PACKAGE_SPLITTER = Pattern.compile("([a-z][0-9]*)([A-Z])");
        Exact = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args) {
                return Java.exactMatch(types, args);
            }
        };
        AssignableAndPrimitivable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args) {
                return Java.assignableAndPrimitivable(types, args);
            }
        };
        AssignableOrDuckable = new CallableAcceptor(){

            @Override
            public boolean accept(Class<?>[] types, IRubyObject[] args) {
                return Java.assignableOrDuckable(types, args);
            }
        };
    }

    private static interface CallableAcceptor {
        public boolean accept(Class<?>[] var1, IRubyObject[] var2);
    }

    @JRubyModule(name={"JavaUtilities"})
    public static class JavaUtilities {
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject wrap(IRubyObject recv, IRubyObject arg0) {
            return Java.wrap(recv, arg0);
        }

        @JRubyMethod(name={"valid_constant_name?"}, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject valid_constant_name_p(IRubyObject recv, IRubyObject arg0) {
            return Java.valid_constant_name_p(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject primitive_match(IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.primitive_match(recv, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject access(IRubyObject recv, IRubyObject arg0) {
            return Java.access(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject matching_method(IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.matching_method(recv, arg0, arg1);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject set_java_object(IRubyObject recv, IRubyObject self, IRubyObject java_object) {
            self.getInstanceVariables().fastSetInstanceVariable("@java_object", java_object);
            self.dataWrapStruct(java_object);
            return java_object;
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_deprecated_interface_proxy(ThreadContext context, IRubyObject recv, IRubyObject arg0) {
            return Java.get_deprecated_interface_proxy(context, recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_interface_module(IRubyObject recv, IRubyObject arg0) {
            return Java.get_interface_module(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module(IRubyObject recv, IRubyObject arg0) {
            return Java.get_package_module(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_package_module_dot_format(IRubyObject recv, IRubyObject arg0) {
            return Java.get_package_module_dot_format(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_class(IRubyObject recv, IRubyObject arg0) {
            return Java.get_proxy_class(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject is_primitive_type(IRubyObject recv, IRubyObject arg0) {
            return Java.is_primitive_type(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject create_proxy_class(IRubyObject recv, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
            return Java.create_proxy_class(recv, arg0, arg1, arg2);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_java_class(IRubyObject recv, IRubyObject arg0) {
            return Java.get_java_class(recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_top_level_proxy_or_package(ThreadContext context, IRubyObject recv, IRubyObject arg0) {
            return Java.get_top_level_proxy_or_package(context, recv, arg0);
        }

        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject get_proxy_or_package_under_package(ThreadContext context, IRubyObject recv, IRubyObject arg0, IRubyObject arg1) {
            return Java.get_proxy_or_package_under_package(context, recv, arg0, arg1);
        }

        @Deprecated
        @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject add_proxy_extender(IRubyObject recv, IRubyObject arg0) {
            return Java.add_proxy_extender(recv, arg0);
        }
    }
}

