/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.invokers;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.java.invokers.RubyToJavaInvoker;
import org.jruby.nb.javasupport.Java;
import org.jruby.nb.javasupport.JavaConstructor;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ConstructorInvoker
extends RubyToJavaInvoker {
    private Constructor[] ctors;

    public ConstructorInvoker(RubyModule host, List<Constructor> methods) {
        super(host);
        this.ctors = methods.toArray(new Constructor[methods.size()]);
        if (!Ruby.isSecurityRestricted()) {
            Method.setAccessible(this.ctors, true);
        }
    }

    synchronized void createJavaCallables(Ruby runtime) {
        if (!this.initialized) {
            if (this.ctors != null) {
                if (this.ctors.length == 1) {
                    this.javaCallable = JavaConstructor.create(runtime, this.ctors[0]);
                } else {
                    HashMap<Integer, ArrayList<JavaConstructor>> methodsMap = new HashMap<Integer, ArrayList<JavaConstructor>>();
                    int maxArity = 0;
                    for (Constructor ctor : this.ctors) {
                        int arity = ctor.getParameterTypes().length;
                        maxArity = Math.max(arity, maxArity);
                        ArrayList<JavaConstructor> methodsForArity = (ArrayList<JavaConstructor>)methodsMap.get(arity);
                        if (methodsForArity == null) {
                            methodsForArity = new ArrayList<JavaConstructor>();
                            methodsMap.put(arity, methodsForArity);
                        }
                        methodsForArity.add(JavaConstructor.create(runtime, ctor));
                    }
                    this.javaCallables = new JavaConstructor[maxArity + 1][];
                    for (Map.Entry entry : methodsMap.entrySet()) {
                        List ctorsForArity = (List)entry.getValue();
                        JavaConstructor[] methodsArray = ctorsForArity.toArray(new JavaConstructor[ctorsForArity.size()]);
                        this.javaCallables[((Integer)entry.getKey()).intValue()] = methodsArray;
                    }
                }
                this.ctors = null;
                this.cache = new ConcurrentHashMap();
            }
            this.initialized = true;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args) {
        this.createJavaCallables(self.getRuntime());
        int len = args.length;
        Object[] convertedArgs = new Object[len];
        JavaConstructor callable = (JavaConstructor)this.findCallable(self, name, args, len);
        Class<?>[] targetTypes = callable.getParameterTypes();
        int i = len;
        while (--i >= 0) {
            convertedArgs[i] = JavaUtil.convertArgumentToType(context, args[i], targetTypes[i]);
        }
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name) {
        this.createJavaCallables(self.getRuntime());
        JavaConstructor callable = (JavaConstructor)this.findCallableArityZero(self, name);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(EMPTY_OBJECT_ARRAY));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[1];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityOne(self, name, arg0);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[2];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityTwo(self, name, arg0, arg1);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        this.createJavaCallables(self.getRuntime());
        Object[] convertedArgs = new Object[3];
        JavaConstructor callable = (JavaConstructor)this.findCallableArityThree(self, name, arg0, arg1, arg2);
        convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
        convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
        convertedArgs[2] = JavaUtil.convertArgumentToType(context, arg2, callable.getParameterTypes()[2]);
        Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
        return self;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject[] args, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            int len = args.length;
            Object[] convertedArgs = new Object[len + 1];
            IRubyObject[] intermediate = new IRubyObject[len + 1];
            System.arraycopy(args, 0, intermediate, 0, len);
            intermediate[len] = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallable(self, name, intermediate, len + 1);
            for (int i = 0; i < len + 1; ++i) {
                convertedArgs[i] = JavaUtil.convertArgumentToType(context, intermediate[i], callable.getParameterTypes()[i]);
            }
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name, args);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[1];
            RubyProc proc = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityOne(self, name, proc);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, proc, callable.getParameterTypes()[0]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[2];
            RubyProc proc = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityTwo(self, name, arg0, proc);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, proc, callable.getParameterTypes()[1]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name, arg0);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[3];
            RubyProc proc = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityThree(self, name, arg0, arg1, proc);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
            convertedArgs[2] = JavaUtil.convertArgumentToType(context, proc, callable.getParameterTypes()[2]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name, arg0, arg1);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        this.createJavaCallables(self.getRuntime());
        if (block.isGiven()) {
            Object[] convertedArgs = new Object[4];
            RubyProc proc = RubyProc.newProc(self.getRuntime(), block, Block.Type.LAMBDA);
            JavaConstructor callable = (JavaConstructor)this.findCallableArityFour(self, name, arg0, arg1, arg2, proc);
            convertedArgs[0] = JavaUtil.convertArgumentToType(context, arg0, callable.getParameterTypes()[0]);
            convertedArgs[1] = JavaUtil.convertArgumentToType(context, arg1, callable.getParameterTypes()[1]);
            convertedArgs[2] = JavaUtil.convertArgumentToType(context, arg2, callable.getParameterTypes()[2]);
            convertedArgs[3] = JavaUtil.convertArgumentToType(context, proc, callable.getParameterTypes()[3]);
            Java.JavaUtilities.set_java_object(self, self, callable.new_instance(convertedArgs));
            return self;
        }
        return this.call(context, self, clazz, name, arg0, arg1, arg2);
    }
}

