/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import org.jruby.nb.Ruby;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.internal.runtime.GlobalVariable;
import org.jruby.nb.internal.runtime.ValueAccessor;
import org.jruby.nb.runtime.IAccessor;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class UndefinedAccessor
implements IAccessor {
    private final Ruby runtime;
    private final GlobalVariable globalVariable;
    private final String name;

    public UndefinedAccessor(Ruby runtime, GlobalVariable globalVariable, String name) {
        assert (runtime != null);
        assert (globalVariable != null);
        assert (name != null);
        this.runtime = runtime;
        this.globalVariable = globalVariable;
        this.name = name;
    }

    @Override
    public IRubyObject getValue() {
        this.runtime.getWarnings().warning(IRubyWarnings.ID.ACCESSOR_NOT_INITIALIZED, "global variable `" + this.name + "' not initialized", this.name);
        return this.runtime.getNil();
    }

    @Override
    public IRubyObject setValue(IRubyObject newValue) {
        assert (newValue != null);
        this.globalVariable.setAccessor(new ValueAccessor(newValue));
        return newValue;
    }
}

