/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jruby.nb.RubyThread;
import org.jruby.nb.internal.runtime.RubyRunnable;
import org.jruby.nb.internal.runtime.ThreadLike;

public class FutureThread
implements ThreadLike {
    private volatile Future future;
    private RubyRunnable runnable;
    public RubyThread rubyThread;

    public FutureThread(RubyThread rubyThread, RubyRunnable runnable) {
        this.rubyThread = rubyThread;
        this.runnable = runnable;
    }

    @Override
    public void start() {
        this.future = this.rubyThread.getRuntime().getExecutor().submit(this.runnable);
    }

    @Override
    public void interrupt() {
        if (this.runnable.getJavaThread() != null) {
            this.runnable.getJavaThread().interrupt();
        }
    }

    @Override
    public boolean isAlive() {
        return this.future == null || !this.future.isDone();
    }

    @Override
    public void join() throws InterruptedException, ExecutionException {
        try {
            this.future.get();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
    }

    @Override
    public void join(long millis) throws InterruptedException, ExecutionException {
        if (millis == 0L) {
            this.join();
        } else {
            try {
                this.future.get(millis, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException ce) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void setPriority(int priority) {
    }

    @Override
    public boolean isCurrent() {
        return this.rubyThread == this.rubyThread.getRuntime().getCurrentContext().getThread();
    }

    @Override
    public boolean isInterrupted() {
        return this.future.isCancelled();
    }
}

