/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.exceptions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jruby.nb.NativeException;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyString;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RaiseException
extends JumpException {
    public static final boolean DEBUG = false;
    private static final long serialVersionUID = -7612079169559973951L;
    private RubyException exception;

    public RaiseException(RubyException actException) {
        this(actException, false);
    }

    public RaiseException(Ruby runtime, RubyClass excptnClass, String msg, boolean nativeException) {
        super(msg);
        if (msg == null) {
            msg = "No message available";
        }
        this.setException((RubyException)RuntimeHelpers.invoke(runtime.getCurrentContext(), (IRubyObject)excptnClass, "new", RubyString.newUnicodeString(excptnClass.getRuntime(), msg)), nativeException);
    }

    public RaiseException(RubyException exception, boolean isNativeException) {
        this.setException(exception, isNativeException);
    }

    public static RaiseException createNativeRaiseException(Ruby runtime, Throwable cause) {
        NativeException nativeException = new NativeException(runtime, runtime.getClass("NativeException"), cause);
        return new RaiseException(cause, nativeException);
    }

    private static String buildMessage(Throwable exception) {
        StringBuilder sb = new StringBuilder();
        StringWriter stackTrace = new StringWriter();
        exception.printStackTrace(new PrintWriter(stackTrace));
        sb.append("Native Exception: '").append(exception.getClass()).append("'; ");
        sb.append("Message: ").append(exception.getMessage()).append("; ");
        sb.append("StackTrace: ").append(stackTrace.getBuffer().toString());
        return sb.toString();
    }

    public RaiseException(Throwable cause, NativeException nativeException) {
        super(RaiseException.buildMessage(cause), cause);
        this.setException(nativeException, false);
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException newException, boolean nativeException) {
        Ruby runtime = newException.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (!context.isWithinDefined()) {
            runtime.getGlobalVariables().set("$!", newException);
        }
        if (runtime.hasEventHooks()) {
            runtime.callEventHooks(context, RubyEvent.RAISE, context.getFile(), context.getLine(), context.getFrameName(), context.getFrameKlazz());
        }
        this.exception = newException;
        if (runtime.getStackTraces() > 5) {
            return;
        }
        runtime.setStackTraces(runtime.getStackTraces() + 1);
        StackTraceElement[] stackTrace = context.createBacktrace2(0, nativeException);
        newException.setBacktraceFrames(stackTrace);
        if (newException instanceof NativeException) {
            this.setStackTrace(((NativeException)newException).getCause().getStackTrace());
        } else {
            this.setStackTrace(stackTrace);
        }
        runtime.setStackTraces(runtime.getStackTraces() - 1);
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        StackTraceElement[] trace = this.getStackTrace();
        int externalIndex = 0;
        int i = trace.length - 1;
        while (i > 0 && trace[i].getClassName().indexOf("org.jruby.nb.evaluator") < 0) {
            externalIndex = i--;
        }
        IRubyObject backtrace = this.exception.backtrace();
        Ruby runtime = backtrace.getRuntime();
        if (runtime.getNil() != backtrace) {
            String firstLine = backtrace.callMethod(runtime.getCurrentContext(), "first").callMethod(runtime.getCurrentContext(), MethodIndex.TO_S, "to_s").toString();
            ps.print(firstLine + ": ");
        }
        ps.println(this.exception.message + " (" + this.exception.getMetaClass().toString() + ")");
        this.exception.printBacktrace(ps);
        ps.println("\t...internal jruby stack elided...");
        for (int i2 = externalIndex; i2 < trace.length; ++i2) {
            ps.println("\tfrom " + trace[i2].toString());
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.printStackTrace(new PrintStream(baos));
        pw.print(baos.toString());
    }
}

