/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler;

import java.lang.ref.SoftReference;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.ast.ArgsNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.ast.util.SexpMaker;
import org.jruby.nb.compiler.ASTCompiler;
import org.jruby.nb.compiler.ASTInspector;
import org.jruby.nb.compiler.CompilerCallback;
import org.jruby.nb.compiler.JITCompilerMBean;
import org.jruby.nb.compiler.MethodCompiler;
import org.jruby.nb.compiler.NotCompilableException;
import org.jruby.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DefaultMethod;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.util.ClassCache;
import org.jruby.nb.util.CodegenUtils;
import org.jruby.nb.util.JavaNameMangler;

public class JITCompiler
implements JITCompilerMBean {
    public static final boolean USE_CACHE = true;
    private SoftReference<Ruby> ruby;
    private AtomicLong compiledCount = new AtomicLong(0L);
    private AtomicLong successCount = new AtomicLong(0L);
    private AtomicLong failCount = new AtomicLong(0L);
    private AtomicLong abandonCount = new AtomicLong(0L);
    private AtomicLong compileTime = new AtomicLong(0L);
    private AtomicLong averageCompileTime = new AtomicLong(0L);
    private AtomicLong codeSize = new AtomicLong(0L);
    private AtomicLong averageCodeSize = new AtomicLong(0L);
    private AtomicLong largestCodeSize = new AtomicLong(0L);

    public JITCompiler(Ruby ruby) {
        this.ruby = new SoftReference<Ruby>(ruby);
        ruby.getBeanManager().register(this);
    }

    public void tryJIT(DefaultMethod method, ThreadContext context, String name) {
        if (context.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            this.jitIsEnabled(method, context, name);
        }
    }

    @Deprecated
    public void runJIT(DefaultMethod method, ThreadContext context, String name) {
        if (method.getCallCount() < 0) {
            return;
        }
        this.jitIsEnabled(method, context, name);
    }

    private void jitIsEnabled(DefaultMethod method, ThreadContext context, String name) {
        RubyInstanceConfig instanceConfig = this.ruby.get().getInstanceConfig();
        int callCount = method.incrementCallCount();
        if (callCount >= instanceConfig.getJitThreshold()) {
            this.jitThresholdReached(method, instanceConfig, context, name);
        }
    }

    private void jitThresholdReached(DefaultMethod method, RubyInstanceConfig instanceConfig, ThreadContext context, String name) {
        try {
            int methodCount;
            ClassCache classCache = instanceConfig.getClassCache();
            if (classCache.isFull()) {
                this.abandonCount.incrementAndGet();
                method.setCallCount(-1);
                return;
            }
            String moduleName = method.getImplementationClass().getName();
            if (instanceConfig.getExcludedMethods().size() > 0 && (instanceConfig.getExcludedMethods().contains(moduleName) || instanceConfig.getExcludedMethods().contains(moduleName + "#" + name) || instanceConfig.getExcludedMethods().contains(name))) {
                method.setCallCount(-1);
                return;
            }
            JITClassGenerator generator = new JITClassGenerator(name, method, context);
            String key = SexpMaker.create(name, method.getArgsNode(), method.getBodyNode());
            Class sourceClass = instanceConfig.getClassCache().cacheClassByKey(key, generator);
            if (sourceClass == null) {
                this.failCount.incrementAndGet();
                method.setCallCount(-1);
                return;
            }
            this.successCount.incrementAndGet();
            Script jitCompiledScript = (Script)sourceClass.newInstance();
            Set<Script> jittedMethods = this.ruby.get().getJittedMethods();
            jittedMethods.add(jitCompiledScript);
            if (instanceConfig.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % instanceConfig.getJitLogEvery() == 0) {
                JITCompiler.log(method, name, "live compiled methods: " + methodCount, new String[0]);
            }
            if (instanceConfig.isJitLogging()) {
                JITCompiler.log(method, name, "done jitting", new String[0]);
            }
            method.setJITCallConfig(generator.callConfig());
            method.setJITCompiledScript(jitCompiledScript);
            method.setCallCount(-1);
        }
        catch (Throwable t) {
            if (instanceConfig.isJitLoggingVerbose()) {
                JITCompiler.log(method, name, "could not compile", t.getMessage());
            }
            this.failCount.incrementAndGet();
            method.setCallCount(-1);
        }
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    static void log(DefaultMethod method, String name, String message, String ... reason) {
        String className = method.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        System.err.print(message + ":" + className + "." + name);
        if (reason.length > 0) {
            System.err.print(" because of: \"");
            for (int i = 0; i < reason.length; ++i) {
                System.err.print(reason[i]);
            }
            System.err.print('\"');
        }
        System.err.println("");
    }

    @Override
    public long getSuccessCount() {
        return this.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.codeSize.get();
    }

    @Override
    public long getAverageCodeSize() {
        return this.averageCodeSize.get();
    }

    @Override
    public long getAverageCompileTime() {
        return this.averageCompileTime.get() / 1000L;
    }

    @Override
    public long getLargestCodeSize() {
        return this.largestCodeSize.get();
    }

    public class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private StandardASMCompiler asmCompiler;
        private DefaultMethod method;
        private StaticScope staticScope;
        private Node bodyNode;
        private ArgsNode argsNode;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String name, DefaultMethod method, ThreadContext context) {
            this.method = method;
            String packageName = "ruby/jit/" + JavaNameMangler.mangleFilenameForClasspath(method.getPosition().getFile());
            String cleanName = packageName + "/" + JavaNameMangler.mangleStringForCleanJavaIdentifier(name);
            this.bodyNode = method.getBodyNode();
            this.argsNode = method.getArgsNode();
            String filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(cleanName + method.hashCode() + "_" + context.hashCode(), filename);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compile() {
            MethodCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            long start = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler compiler = new ASTCompiler();
            CompilerCallback args = new CompilerCallback(){

                @Override
                public void call(MethodCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context);
                }
            };
            ASTInspector inspector = new ASTInspector();
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startMethod("__file__", args, this.staticScope, inspector);
                compiler.compile(this.bodyNode, methodCompiler);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startMethod("__file__", args, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startMethod("__file__", null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.NO_FRAME_NO_SCOPE;
            }
            methodCompiler.endMethod();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.hasClosure() || inspector.hasScopeAwareMethods() ? CallConfiguration.FRAME_AND_SCOPE : CallConfiguration.FRAME_ONLY;
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            this.name = CodegenUtils.c(this.asmCompiler.getClassname());
            if (this.bytecode.length > ((Ruby)JITCompiler.this.ruby.get()).getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + ((Ruby)JITCompiler.this.ruby.get()).getInstanceConfig().getJitMaxSize());
            }
            JITCompiler.this.compiledCount.incrementAndGet();
            JITCompiler.this.compileTime.addAndGet(System.nanoTime() - start);
            JITCompiler.this.codeSize.addAndGet(this.bytecode.length);
            JITCompiler.this.averageCompileTime.set(JITCompiler.this.compileTime.get() / JITCompiler.this.compiledCount.get());
            JITCompiler.this.averageCodeSize.set(JITCompiler.this.codeSize.get() / JITCompiler.this.compiledCount.get());
            AtomicLong atomicLong = JITCompiler.this.largestCodeSize;
            synchronized (atomicLong) {
                if (JITCompiler.this.largestCodeSize.get() < (long)this.bytecode.length) {
                    JITCompiler.this.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        @Override
        public byte[] bytecode() {
            this.compile();
            return this.bytecode;
        }

        @Override
        public String name() {
            this.compile();
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }
    }
}

