/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast.executable;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyFile;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.executable.YARVMachine;
import org.jruby.nb.parser.LocalStaticScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class YARVCompiledRunner {
    private Ruby runtime;
    private YARVMachine ym = YARVMachine.INSTANCE;
    private YARVMachine.InstructionSequence iseq;
    private Map jumps = new IdentityHashMap();
    private Map labels = new HashMap();

    public YARVCompiledRunner(Ruby runtime, InputStream in, String filename) {
        this.runtime = runtime;
        byte[] first = new byte[4];
        try {
            in.read(first);
            if (first[0] != 82 || first[1] != 66 || first[2] != 67 || first[3] != 77) {
                throw new RuntimeException("File is not a compiled YARV file");
            }
            RubyFile f = new RubyFile(runtime, filename, in);
            IRubyObject arr = runtime.getMarshal().callMethod(runtime.getCurrentContext(), "load", f);
            this.iseq = this.transformIntoSequence(arr);
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read from source", e);
        }
    }

    public YARVCompiledRunner(Ruby runtime, YARVMachine.InstructionSequence iseq) {
        this.runtime = runtime;
        this.iseq = iseq;
    }

    public IRubyObject run() {
        ThreadContext context = this.runtime.getCurrentContext();
        LocalStaticScope scope = new LocalStaticScope(null, this.iseq.locals);
        context.setFile(this.iseq.filename);
        context.setLine(-1);
        return this.ym.exec(context, scope, this.iseq.body);
    }

    private YARVMachine.InstructionSequence transformIntoSequence(IRubyObject arr) {
        if (!(arr instanceof RubyArray)) {
            throw new RuntimeException("Error when reading compiled YARV file");
        }
        this.labels.clear();
        this.jumps.clear();
        YARVMachine.InstructionSequence seq = new YARVMachine.InstructionSequence(this.runtime, null, null, null);
        Iterator internal = ((RubyArray)arr).getList().iterator();
        seq.magic = internal.next().toString();
        seq.major = RubyNumeric.fix2int((IRubyObject)internal.next());
        seq.minor = RubyNumeric.fix2int((IRubyObject)internal.next());
        seq.format_type = RubyNumeric.fix2int((IRubyObject)internal.next());
        IRubyObject misc = (IRubyObject)internal.next();
        seq.misc = misc.isNil() ? null : misc;
        seq.name = internal.next().toString();
        seq.filename = internal.next().toString();
        seq.line = new Object[0];
        internal.next();
        seq.type = internal.next().toString();
        seq.locals = this.toStringArray((IRubyObject)internal.next());
        IRubyObject argo = (IRubyObject)internal.next();
        if (argo instanceof RubyArray) {
            List arglist = ((RubyArray)argo).getList();
            seq.args_argc = RubyNumeric.fix2int((IRubyObject)arglist.get(0));
            seq.args_arg_opts = RubyNumeric.fix2int((IRubyObject)arglist.get(1));
            seq.args_opt_labels = this.toStringArray((IRubyObject)arglist.get(2));
            seq.args_rest = RubyNumeric.fix2int((IRubyObject)arglist.get(3));
            seq.args_block = RubyNumeric.fix2int((IRubyObject)arglist.get(4));
        } else {
            seq.args_argc = RubyNumeric.fix2int(argo);
        }
        seq.exception = this.getExceptionInformation((IRubyObject)internal.next());
        List bodyl = ((RubyArray)internal.next()).getList();
        YARVMachine.Instruction[] body = new YARVMachine.Instruction[bodyl.size()];
        int real = 0;
        int i = 0;
        for (IRubyObject is : bodyl) {
            if (is instanceof RubyArray) {
                body[real] = this.intoInstruction((RubyArray)is, real, seq);
                ++real;
            } else if (is instanceof RubySymbol) {
                this.labels.put(is.toString(), new Integer(real + 1));
            }
            ++i;
        }
        YARVMachine.Instruction[] nbody = new YARVMachine.Instruction[real];
        System.arraycopy(body, 0, nbody, 0, real);
        seq.body = nbody;
        for (YARVMachine.Instruction k : this.jumps.keySet()) {
            k.l_op0 = (Integer)this.labels.get(this.jumps.get(k)) - 1;
        }
        return seq;
    }

    private String[] toStringArray(IRubyObject obj) {
        if (obj.isNil()) {
            return new String[0];
        }
        List l = ((RubyArray)obj).getList();
        String[] s = new String[l.size()];
        int i = 0;
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            s[i] = iter.next().toString();
            ++i;
        }
        return s;
    }

    private YARVMachine.Instruction intoInstruction(RubyArray obj, int n, YARVMachine.InstructionSequence iseq) {
        List internal = obj.getList();
        String name = internal.get(0).toString();
        int instruction = YARVMachine.instruction(name);
        YARVMachine.Instruction i = new YARVMachine.Instruction(instruction);
        if (internal.size() > 1) {
            IRubyObject first = (IRubyObject)internal.get(1);
            if (instruction == 1 || instruction == 2) {
                i.l_op0 = (long)(iseq.locals.length + 1) - RubyNumeric.fix2long(first);
            } else if (instruction == 18 || instruction == 74 || instruction == 56) {
                i.o_op0 = first;
            } else if (first instanceof RubyString || first instanceof RubySymbol) {
                i.s_op0 = first.toString();
            } else if (first instanceof RubyNumeric) {
                i.l_op0 = RubyNumeric.fix2long(first);
            }
            if (instruction == 47) {
                i.i_op1 = RubyNumeric.fix2int((IRubyObject)internal.get(2));
                i.i_op3 = RubyNumeric.fix2int((IRubyObject)internal.get(4));
            }
            if (instruction == 40) {
                i.iseq_op = this.transformIntoSequence((IRubyObject)internal.get(2));
            }
            if (this.isJump(instruction)) {
                i.index = n;
                this.jumps.put(i, internal.get(this.jumpIndex(instruction)).toString());
            }
        }
        return i;
    }

    private boolean isJump(int i) {
        return i == 53 || i == 54 || i == 55 || i == 56 || i == 58;
    }

    private int jumpIndex(int i) {
        if (i == 56) {
            return 2;
        }
        return 1;
    }

    private Object[] getExceptionInformation(IRubyObject obj) {
        return new Object[0];
    }
}

