/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.BinaryOperatorNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class OpAsgnAndNode
extends Node
implements BinaryOperatorNode {
    private final Node firstNode;
    private final Node secondNode;

    public OpAsgnAndNode(ISourcePosition position, Node headNode, Node valueNode) {
        super(position, NodeType.OPASGNANDNODE);
        assert (headNode != null) : "headNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.firstNode = headNode;
        this.secondNode = valueNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnAndNode(this);
    }

    @Override
    public Node getFirstNode() {
        return this.firstNode;
    }

    @Override
    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.firstNode, this.secondNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.firstNode.interpret(runtime, context, self, aBlock);
        if (!result.isTrue()) {
            return ASTInterpreter.pollAndReturn(context, result);
        }
        return this.secondNode.interpret(runtime, context, self, aBlock);
    }
}

