/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.AttrAssignOneArgNode;
import org.jruby.nb.ast.AttrAssignThreeArgNode;
import org.jruby.nb.ast.AttrAssignTwoArgNode;
import org.jruby.nb.ast.IArgumentNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class AttrAssignNode
extends Node
implements INameNode,
IArgumentNode {
    protected final Node receiverNode;
    private String name;
    private Node argsNode;
    public CallSite variableCallAdapter;
    public CallSite normalCallAdapter;

    public AttrAssignNode(ISourcePosition position, Node receiverNode, String name, Node argsNode) {
        super(position, NodeType.ATTRASSIGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        this.receiverNode = receiverNode;
        this.name = name;
        this.setArgsInternal(argsNode);
        this.normalCallAdapter = MethodIndex.getCallSite(name);
        this.variableCallAdapter = MethodIndex.getVariableCallSite(name);
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitAttrAssignNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    @Override
    public Node getArgsNode() {
        return this.argsNode;
    }

    protected Node newAttrAssignNode(ArrayNode argsNode) {
        int size = argsNode.size();
        switch (size) {
            case 1: {
                return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 2: {
                return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
            case 3: {
                return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    protected Node newMutatedAttrAssignNode(ArrayNode argsNode) {
        int size = argsNode.size();
        switch (size) {
            case 1: {
                if (!(this instanceof AttrAssignOneArgNode)) {
                    return new AttrAssignOneArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 2: {
                if (!(this instanceof AttrAssignTwoArgNode)) {
                    return new AttrAssignTwoArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
            case 3: {
                if (!(this instanceof AttrAssignThreeArgNode)) {
                    return new AttrAssignThreeArgNode(this.getPosition(), this.receiverNode, this.name, argsNode);
                }
                return this;
            }
        }
        return new AttrAssignNode(this.getPosition(), this.receiverNode, this.name, argsNode);
    }

    @Override
    public Node setArgsNode(Node argsNode) {
        if (this.argsNode == null && argsNode instanceof ArrayNode) {
            return this.newAttrAssignNode((ArrayNode)argsNode);
        }
        if (this.argsNode == argsNode) {
            return this.newMutatedAttrAssignNode((ArrayNode)argsNode);
        }
        this.setArgsInternal(argsNode);
        return this;
    }

    private void setArgsInternal(Node argsNode) {
        this.argsNode = argsNode;
        if (argsNode instanceof ArrayNode) {
            ((ArrayNode)argsNode).setLightweight(true);
        }
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.argsNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        assert (receiver.getMetaClass() != null) : receiver.getClass().getName();
        if (receiver == self) {
            this.variableCallAdapter.call(context, receiver, args);
        } else {
            this.normalCallAdapter.call(context, receiver, args);
        }
        return args[args.length - 1];
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        if (receiver == self) {
            return this.selfAssign(runtime, context, self, value, block, checkArity);
        }
        return this.otherAssign(runtime, context, self, value, block, checkArity);
    }

    private IRubyObject selfAssign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver, this.name, value, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, this.name, args.toJavaArray(), Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }

    private IRubyObject otherAssign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, block);
        if (this.argsNode == null) {
            RuntimeHelpers.invoke(context, receiver, this.name, value, CallType.NORMAL, Block.NULL_BLOCK);
        } else {
            RubyArray args = (RubyArray)this.argsNode.interpret(runtime, context, self, block);
            args.append(value);
            RuntimeHelpers.invoke(context, receiver, this.name, args.toJavaArray(), CallType.NORMAL, Block.NULL_BLOCK);
        }
        return runtime.getNil();
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.receiverNode.definition(runtime, context, self, aBlock) != null) {
            try {
                IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
                RubyClass metaClass = receiver.getMetaClass();
                DynamicMethod method = metaClass.searchMethod(this.name);
                Visibility visibility = method.getVisibility();
                if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self)) && metaClass.isMethodBound(this.name, false)) {
                    return ASTInterpreter.getArgumentDefinition(runtime, context, this.argsNode, "assignment", self, aBlock);
                }
            }
            catch (JumpException e) {
                // empty catch block
            }
        }
        return null;
    }
}

