/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyObject;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class RubyClassPathVariable
extends RubyObject {
    public static void createClassPathVariable(Ruby runtime) {
        RubyClassPathVariable self = new RubyClassPathVariable(runtime);
        runtime.getEnumerable().extend_object(self);
        runtime.defineReadonlyVariable("$CLASSPATH", self);
        self.getMetaClass().defineAnnotatedMethods(RubyClassPathVariable.class);
    }

    private RubyClassPathVariable(Ruby runtime) {
        super(runtime, runtime.getObject());
    }

    @JRubyMethod(name={"append", "<<"}, required=1)
    public IRubyObject append(IRubyObject obj) throws Exception {
        String ss = obj.convertToString().toString();
        URL url = this.getURL(ss);
        this.getRuntime().getJRubyClassLoader().addURL(url);
        return this;
    }

    private URL getURL(String target) throws MalformedURLException {
        if (target.indexOf("://") == -1) {
            return new File(target).toURI().toURL();
        }
        return new URL(target);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.getRuntime().getJRubyClassLoader().getURLs().length);
    }

    @JRubyMethod(name={"each"}, frame=true)
    public IRubyObject each(Block block) {
        URL[] urls = this.getRuntime().getJRubyClassLoader().getURLs();
        ThreadContext ctx = this.getRuntime().getCurrentContext();
        int j = urls.length;
        for (int i = 0; i < j; ++i) {
            block.yield(ctx, this.getRuntime().newString(urls[i].toString()));
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "to_s");
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "to_a").callMethod(this.getRuntime().getCurrentContext(), "inspect");
    }
}

