/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.rules;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ExpressionTree;
import javax.jws.WebParam;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.modules.websvc.editor.hints.common.Utilities;
import org.netbeans.modules.websvc.editor.hints.fixes.RemoveAnnotationArgument;
import org.netbeans.modules.websvc.editor.hints.rules.WebServiceAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class WebParamHolder
extends Rule<VariableElement>
implements WebServiceAnnotations {
    @Override
    protected ErrorDescription[] apply(VariableElement variableElement, ProblemContext problemContext) {
        AnnotationMirror annotationMirror = Utilities.findAnnotation(variableElement, "javax.jws.WebParam");
        if (annotationMirror != null) {
            AnnotationValue annotationValue = Utilities.getAnnotationAttrValue(annotationMirror, "mode");
            WebParam.Mode mode = null;
            if (annotationValue != null) {
                try {
                    mode = WebParam.Mode.valueOf((String)annotationValue.getValue().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!(WebParam.Mode.INOUT != mode && WebParam.Mode.OUT != mode || "javax.xml.ws.Holder".equals(WebParamHolder.getVariableType(variableElement)))) {
                String string = NbBundle.getMessage(WebParamHolder.class, (String)"MSG_WebParam_HolderRequired");
                RemoveAnnotationArgument removeAnnotationArgument = new RemoveAnnotationArgument(problemContext.getFileObject(), variableElement, annotationMirror, "mode");
                AnnotationTree annotationTree = (AnnotationTree)problemContext.getCompilationInfo().getTrees().getTree(variableElement, annotationMirror);
                ExpressionTree expressionTree = Utilities.getAnnotationArgumentTree(annotationTree, "mode");
                problemContext.setElementToAnnotate(expressionTree);
                ErrorDescription errorDescription = WebParamHolder.createProblem((Element)variableElement, problemContext, string, removeAnnotationArgument);
                problemContext.setElementToAnnotate(null);
                return new ErrorDescription[]{errorDescription};
            }
        }
        return null;
    }

    @Override
    protected boolean isApplicable(VariableElement variableElement, ProblemContext problemContext) {
        return Utilities.hasAnnotation(variableElement, "javax.jws.WebParam");
    }

    private static String getVariableType(VariableElement variableElement) {
        DeclaredType declaredType;
        if (variableElement.asType() instanceof DeclaredType && (declaredType = (DeclaredType)variableElement.asType()).asElement() instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            return typeElement.getQualifiedName().toString();
        }
        return null;
    }
}

