/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.charts;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartItemChange;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;

public class CompoundItemPainter
implements ItemPainter {
    private ItemPainter painter1;
    private ItemPainter painter2;

    public CompoundItemPainter(ItemPainter painter1, ItemPainter painter2) {
        this.painter1 = painter1;
        this.painter2 = painter2;
    }

    @Override
    public LongRect getItemBounds(ChartItem item) {
        LongRect itemBounds = this.painter1.getItemBounds(item);
        LongRect.add(itemBounds, this.painter2.getItemBounds(item));
        return itemBounds;
    }

    @Override
    public LongRect getItemBounds(ChartItem item, ChartContext context) {
        LongRect itemBounds = this.painter1.getItemBounds(item, context);
        LongRect.add(itemBounds, this.painter2.getItemBounds(item, context));
        return itemBounds;
    }

    @Override
    public boolean isBoundsChange(ChartItemChange itemChange) {
        return this.painter1.isBoundsChange(itemChange) || this.painter2.isBoundsChange(itemChange);
    }

    @Override
    public boolean isAppearanceChange(ChartItemChange itemChange) {
        return this.painter1.isAppearanceChange(itemChange) || this.painter2.isAppearanceChange(itemChange);
    }

    @Override
    public LongRect getDirtyBounds(ChartItemChange itemChange, ChartContext context) {
        LongRect dirtyBounds = this.painter1.getDirtyBounds(itemChange, context);
        LongRect.add(dirtyBounds, this.painter2.getDirtyBounds(itemChange, context));
        return dirtyBounds;
    }

    @Override
    public boolean supportsHovering(ChartItem item) {
        return this.painter1.supportsHovering(item) || this.painter2.supportsHovering(item);
    }

    @Override
    public boolean supportsSelecting(ChartItem item) {
        return this.painter1.supportsSelecting(item) || this.painter2.supportsSelecting(item);
    }

    @Override
    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        LongRect bounds1 = this.painter1.supportsHovering(selection.getItem()) ? this.painter1.getSelectionBounds(selection, context) : new LongRect();
        LongRect bounds2 = this.painter2.supportsHovering(selection.getItem()) ? this.painter2.getSelectionBounds(selection, context) : new LongRect();
        LongRect.add(bounds1, bounds2);
        return bounds1;
    }

    @Override
    public ItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        ItemSelection selection2;
        ItemSelection selection1 = this.painter1.supportsHovering(item) ? this.painter1.getClosestSelection(item, viewX, viewY, context) : null;
        ItemSelection itemSelection = selection2 = this.painter2.supportsHovering(item) ? this.painter2.getClosestSelection(item, viewX, viewY, context) : null;
        if (selection1 == null) {
            return selection2;
        }
        if (selection2 == null) {
            return selection1;
        }
        if (selection1.getDistance() < selection2.getDistance()) {
            return selection1;
        }
        return selection2;
    }

    @Override
    public void paintItem(ChartItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, ChartContext context) {
        this.painter1.paintItem(item, highlighted, selected, g, dirtyArea, context);
        this.painter2.paintItem(item, highlighted, selected, g, dirtyArea, context);
    }

    protected ItemPainter getPainter1() {
        return this.painter1;
    }

    protected ItemPainter getPainter2() {
        return this.painter2;
    }
}

