/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.derby.CreateDatabaseAction;
import org.netbeans.modules.derby.DerbyDatabaseNode;
import org.netbeans.modules.derby.DerbyDatabasesImpl;
import org.netbeans.modules.derby.DerbyPropertiesAction;
import org.netbeans.modules.derby.StartAction;
import org.netbeans.modules.derby.StopAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;

public class DerbyServerNode
extends AbstractNode
implements Comparable {
    private static final DerbyDatabasesImpl DATABASES_IMPL = DerbyDatabasesImpl.getDefault();
    private static final ChildFactory FACTORY = new ChildFactory(DATABASES_IMPL);
    private static final DerbyServerNode DEFAULT = new DerbyServerNode(FACTORY);
    private SystemAction[] actions = new SystemAction[]{SystemAction.get(StartAction.class), SystemAction.get(StopAction.class), SystemAction.get(CreateDatabaseAction.class), SystemAction.get(DerbyPropertiesAction.class)};
    private static final String ICON_BASE = "org/netbeans/modules/derby/resources/catalog.gif";

    public static DerbyServerNode getDefault() {
        return DEFAULT;
    }

    private DerbyServerNode(ChildFactory f) {
        super(Children.create((org.openide.nodes.ChildFactory)f, (boolean)true));
        this.setIconBaseWithExtension(ICON_BASE);
    }

    public String getDisplayName() {
        return "Java DB";
    }

    public SystemAction[] getActions(boolean b) {
        return this.actions;
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return true;
    }

    public SystemAction getPreferredAction() {
        return null;
    }

    public int compareTo(Object other) {
        Node otherNode = (Node)other;
        return this.getDisplayName().compareTo(otherNode.getDisplayName());
    }

    private static class ChildFactory
    extends org.openide.nodes.ChildFactory<String>
    implements ChangeListener {
        private DerbyDatabasesImpl databasesImpl;

        public ChildFactory(DerbyDatabasesImpl impl) {
            this.databasesImpl = impl;
            impl.addChangeListener((ChangeListener)WeakListeners.create(ChangeListener.class, (EventListener)this, (Object)impl));
        }

        protected Node createNodeForKey(String db) {
            return new DerbyDatabaseNode(db, this.databasesImpl);
        }

        protected boolean createKeys(List<String> toPopulate) {
            ArrayList<String> fresh = new ArrayList<String>();
            fresh.addAll(this.databasesImpl.getDatabases());
            Collections.sort(fresh);
            toPopulate.addAll(fresh);
            return true;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh(false);
        }
    }
}

