/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl.query;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformImpl;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public class J2eePlatformSourceForBinaryQuery
implements SourceForBinaryQueryImplementation2 {
    private final Map<URL, SourceForBinaryQueryImplementation2.Result> cache = new HashMap<URL, SourceForBinaryQueryImplementation2.Result>();
    private final Map normalizedURLCache = new HashMap();

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL uRL) {
        SourceForBinaryQueryImplementation2.Result result = this.cache.get(uRL);
        if (result != null) {
            return result;
        }
        boolean bl = J2eePlatformSourceForBinaryQuery.isNormalizedURL(uRL);
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs();
        ServerRegistry serverRegistry = ServerRegistry.getInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            J2eePlatformImpl j2eePlatformImpl;
            ServerInstance serverInstance = serverRegistry.getServerInstance(stringArray[i]);
            if (serverInstance == null || (j2eePlatformImpl = serverInstance.getJ2eePlatformImpl()) == null) continue;
            LibraryImplementation[] libraryImplementationArray = j2eePlatformImpl.getLibraries();
            for (int j = 0; j < libraryImplementationArray.length; ++j) {
                String string = libraryImplementationArray[j].getType();
                List list = libraryImplementationArray[j].getContent("classpath");
                for (URL uRL2 : list) {
                    URL uRL3 = bl ? this.getNormalizedURL(uRL2) : uRL2;
                    if (uRL3 == null || !uRL3.equals(uRL)) continue;
                    result = new Result(uRL2, libraryImplementationArray[j]);
                    this.cache.put(uRL, result);
                    return result;
                }
            }
        }
        return null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        return this.findSourceRoots2(uRL);
    }

    private URL getNormalizedURL(URL uRL) {
        FileObject fileObject;
        if (J2eePlatformSourceForBinaryQuery.isNormalizedURL(uRL)) {
            return uRL;
        }
        URL uRL2 = (URL)this.normalizedURLCache.get(uRL);
        if (uRL2 == null && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            try {
                uRL2 = fileObject.getURL();
                this.normalizedURLCache.put(uRL, uRL2);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
        }
        return uRL2;
    }

    private static boolean isNormalizedURL(URL uRL) {
        if ("jar".equals(uRL.getProtocol())) {
            uRL = FileUtil.getArchiveFile((URL)uRL);
        }
        return "file".equals(uRL.getProtocol());
    }

    private static class Result
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private LibraryImplementation lib;
        private URL entry;
        private ArrayList listeners;
        private FileObject[] cache;

        public Result(URL uRL, LibraryImplementation libraryImplementation) {
            this.entry = uRL;
            this.lib = libraryImplementation;
            this.lib.addPropertyChangeListener((PropertyChangeListener)WeakListeners.create(PropertyChangeListener.class, (EventListener)this, (Object)this.lib));
        }

        public synchronized FileObject[] getRoots() {
            if (this.cache == null) {
                if (this.lib.getContent("classpath").contains(this.entry)) {
                    List list = this.lib.getContent("src");
                    ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        FileObject fileObject = URLMapper.findFileObject((URL)((URL)iterator.next()));
                        if (fileObject == null) continue;
                        arrayList.add(fileObject);
                    }
                    this.cache = arrayList.toArray(new FileObject[arrayList.size()]);
                } else {
                    this.cache = new FileObject[0];
                }
            }
            return this.cache;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener cannot be null";
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            assert (changeListener != null) : "Listener cannot be null";
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("content".equals(propertyChangeEvent.getPropertyName())) {
                Result result = this;
                synchronized (result) {
                    this.cache = null;
                }
                this.fireChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            Iterator iterator = null;
            Object object = this;
            synchronized (object) {
                if (this.listeners == null) {
                    return;
                }
                iterator = ((ArrayList)this.listeners.clone()).iterator();
            }
            object = new ChangeEvent(this);
            while (iterator.hasNext()) {
                ((ChangeListener)iterator.next()).stateChanged((ChangeEvent)object);
            }
        }

        public boolean preferSources() {
            return false;
        }
    }
}

