/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.api;

import org.netbeans.modules.kenai.ServicesListData;

public final class KenaiService {
    private ServicesListData.ServicesListItem sli;

    KenaiService(ServicesListData.ServicesListItem sli) {
        this.sli = sli;
    }

    public String getDescription() {
        return this.sli.description;
    }

    public String getName() {
        return this.sli.name;
    }

    public String getDisplayName() {
        return this.sli.display_name;
    }

    public Type getType() {
        return Type.forId(this.sli.type);
    }

    public String toString() {
        return "KenaiService " + this.getName();
    }

    public static enum Type {
        FORUM("forum"),
        ISSUES("issues"),
        LISTS("lists"),
        SOURCE("scm"),
        WIKI("wiki"),
        CHAT("instant_messenger"),
        DOWNLOADS("downloads"),
        HUDSON("hudson"),
        PROJECTS("projects"),
        UNKNOWN("unknown");

        private String id;

        private Type(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Type forId(String id) {
            if (id.equals(Type.SOURCE.id)) {
                return SOURCE;
            }
            if (id.equals(Type.CHAT.id)) {
                return CHAT;
            }
            try {
                return Type.valueOf(id.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }

    public static final class Names {
        public static final String SUBVERSION = "subversion";
        public static final String MERCURIAL = "mercurial";
        public static final String GIT = "git";
        public static final String EXTERNAL_REPOSITORY = "external_repository";
        public static final String BUGZILLA = "bugzilla";
        public static final String JIRA = "jira";
        public static final String EXTERNAL_ISSUES = "external_issues";
        public static final String XMPP_CHAT = "instant_messenger";
        public static final String EXTERNAL_HUDSON = "external_hudson";
    }
}

