/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing.embedding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.EmbeddingProvider;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class JsEmbeddingProvider
extends EmbeddingProvider {
    private static final Logger LOG = Logger.getLogger(JsEmbeddingProvider.class.getName());
    private static final String JSP_MIME_TYPE = "text/x-jsp";
    private static final String TAG_MIME_TYPE = "text/x-tag";
    private static final String RHTML_MIME_TYPE = "application/x-httpd-eruby";
    private static final String HTML_MIME_TYPE = "text/html";
    private static final String PHP_MIME_TYPE = "text/x-php5";
    private static final Map<String, Translator> translators = new HashMap<String, Translator>();
    private static final String GENERATED_IDENTIFIER = " __UNKNOWN__ ";
    private static final String T_INLINE_HTML = "T_INLINE_HTML";
    private final String sourceMimeType;
    private final Translator translator;

    public List<Embedding> getEmbeddings(Snapshot snapshot) {
        if (this.sourceMimeType.equals(snapshot.getMimeType())) {
            List<Embedding> embeddings = this.translator.translate(snapshot);
            if (embeddings.isEmpty()) {
                return Collections.emptyList();
            }
            return Collections.singletonList(Embedding.create(embeddings));
        }
        LOG.warning("Unexpected snapshot type: '" + snapshot.getMimeType() + "'; expecting '" + this.sourceMimeType + "'");
        return Collections.emptyList();
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public void cancel() {
    }

    public static boolean isGeneratedIdentifier(String ident) {
        return GENERATED_IDENTIFIER.trim().equals(ident);
    }

    private JsEmbeddingProvider(String sourceMimeType, Translator translator) {
        this.sourceMimeType = sourceMimeType;
        this.translator = translator;
    }

    private static void extractJavaScriptFromHtml(Snapshot snapshot, TokenSequence<? extends HTMLTokenId> ts, JsAnalyzerState state, List<Embedding> embeddings) {
        ts.moveStart();
        while (ts.moveNext()) {
            char fch;
            Token htmlToken = ts.token();
            HTMLTokenId htmlId = (HTMLTokenId)htmlToken.id();
            if (htmlId == HTMLTokenId.SCRIPT) {
                int lineEnd;
                char c;
                int start;
                state.in_javascript = true;
                int sourceStart = ts.offset();
                String text = ((Object)htmlToken.text()).toString();
                for (start = 0; start < text.length() && Character.isWhitespace(c = text.charAt(start)); ++start) {
                }
                if (start < text.length() && text.startsWith("<!--", start) && (lineEnd = text.indexOf(10, start)) != -1) {
                    sourceStart += ++lineEnd;
                    text = text.substring(lineEnd);
                }
                embeddings.add(snapshot.create(sourceStart, text.length(), "text/javascript"));
                continue;
            }
            if (htmlId == HTMLTokenId.TAG_OPEN) {
                Token t;
                HTMLTokenId id;
                String text = ((Object)htmlToken.text()).toString();
                if (!"script".equals(text)) continue;
                TokenSequence ets = ts.subSequence(ts.offset());
                ets.moveStart();
                boolean foundSrc = false;
                boolean foundType = false;
                String type = null;
                String src = null;
                while (ets.moveNext() && (id = (HTMLTokenId)(t = ets.token()).id()) != HTMLTokenId.TAG_CLOSE_SYMBOL) {
                    if (foundSrc || foundType) {
                        if (id == HTMLTokenId.ARGUMENT) break;
                        if (id != HTMLTokenId.VALUE) continue;
                        if (foundSrc) {
                            src = t.toString();
                        } else {
                            assert (foundType);
                            type = t.toString();
                        }
                        foundSrc = false;
                        foundType = false;
                        continue;
                    }
                    if (id != HTMLTokenId.ARGUMENT) continue;
                    String val = t.toString();
                    if ("src".equals(val)) {
                        foundSrc = true;
                        continue;
                    }
                    if (!"type".equals(val)) continue;
                    foundType = true;
                }
                if (src == null || type != null && type.toLowerCase().indexOf("javascript") == -1) continue;
                if (src.length() > 2 && src.startsWith("\"") && src.endsWith("\"")) {
                    src = src.substring(1, src.length() - 1);
                }
                if (src.length() > 2 && src.startsWith("'") && src.endsWith("'")) {
                    src = src.substring(1, src.length() - 1);
                }
                String insertText = "__netbeans_import__('" + src + "');\n";
                embeddings.add(snapshot.create((CharSequence)insertText, "text/javascript"));
                continue;
            }
            if (state.in_javascript && htmlId == HTMLTokenId.TEXT) {
                embeddings.add(snapshot.create(ts.offset(), htmlToken.length(), "text/javascript"));
                continue;
            }
            if (htmlId == HTMLTokenId.VALUE_JAVASCRIPT) {
                int sourceStart = ts.offset();
                int sourceEnd = sourceStart + ts.token().length();
                if (!state.in_inlined_javascript) {
                    String value = htmlToken.toString();
                    if (value.length() > 0 && ((fch = value.charAt(0)) == '\'' || fch == '\"')) {
                        state.opening_quotation_stripped = true;
                        ++sourceStart;
                    }
                    embeddings.add(snapshot.create((CharSequence)";function(){\n", "text/javascript"));
                }
                state.in_inlined_javascript = true;
                state.lastInlinedJavascriptToken = ts.token();
                state.lastInlinedJavscriptEmbedding = snapshot.create(sourceStart, sourceEnd - sourceStart, "text/javascript");
                embeddings.add(state.lastInlinedJavscriptEmbedding);
                ++state.inlined_javascript_pieces;
                continue;
            }
            if (state.in_inlined_javascript && htmlId != HTMLTokenId.VALUE_JAVASCRIPT) {
                assert (state.lastInlinedJavscriptEmbedding != null);
                assert (state.lastInlinedJavascriptToken != null);
                int sourceStart = state.lastInlinedJavascriptToken.offset(snapshot.getTokenHierarchy());
                int sourceLength = state.lastInlinedJavascriptToken.length();
                CharSequence value = state.lastInlinedJavascriptToken.text();
                if (state.opening_quotation_stripped && value.length() > 0 && ((fch = value.charAt(value.length() - 1)) == '\'' || fch == '\"')) {
                    --sourceLength;
                    if (state.inlined_javascript_pieces == 1) {
                        ++sourceStart;
                        --sourceLength;
                    }
                    boolean removed = embeddings.remove(state.lastInlinedJavscriptEmbedding);
                    assert (removed);
                    embeddings.add(snapshot.create(sourceStart, sourceLength, "text/javascript"));
                }
                state.in_inlined_javascript = false;
                state.opening_quotation_stripped = false;
                state.lastInlinedJavascriptToken = null;
                state.lastInlinedJavscriptEmbedding = null;
                state.inlined_javascript_pieces = 0;
                embeddings.add(snapshot.create((CharSequence)"\n}\n", "text/javascript"));
                continue;
            }
            if (htmlId == HTMLTokenId.TAG_CLOSE && "script".equals(htmlToken.toString())) {
                embeddings.add(snapshot.create((CharSequence)"\n", "text/javascript"));
                continue;
            }
            state.in_javascript = false;
        }
    }

    static {
        translators.put(JSP_MIME_TYPE, new JspTranslator());
        translators.put(TAG_MIME_TYPE, new JspTranslator());
        translators.put(RHTML_MIME_TYPE, new RhtmlTranslator());
        translators.put(HTML_MIME_TYPE, new HtmlTranslator());
        translators.put(PHP_MIME_TYPE, new PhpTranslator());
    }

    private static final class JsAnalyzerState {
        int inlined_javascript_pieces = 0;
        boolean in_javascript = false;
        boolean in_inlined_javascript = false;
        boolean opening_quotation_stripped = false;
        Token<?> lastInlinedJavascriptToken = null;
        Embedding lastInlinedJavscriptEmbedding = null;

        private JsAnalyzerState() {
        }
    }

    private static final class HtmlTranslator
    implements Translator {
        private HtmlTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenSequence tokenSequence = snapshot.getTokenHierarchy().tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            TokenSequence htmlTokenSequence = tokenSequence;
            JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)htmlTokenSequence, state, embeddings);
            return embeddings;
        }
    }

    private static final class RhtmlTranslator
    implements Translator {
        private RhtmlTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.info("Cannot get TokenHierarchy from snapshot " + snapshot);
                return embeddings;
            }
            TokenSequence tokenSequence = th.tokenSequence();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().primaryCategory().equals("html")) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!token.id().primaryCategory().equals("ruby") || !state.in_inlined_javascript && !state.in_javascript) continue;
                int sourceStart = tokenSequence.offset();
                int sourceEnd = sourceStart + token.length();
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return embeddings;
        }
    }

    private static final class PhpTranslator
    implements Translator {
        private PhpTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                LOG.info("Cannot get TokenHierarchy from snapshot " + snapshot);
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = th.tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                boolean hasNext;
                Token token = tokenSequence.token();
                if (token.id().name().equals(JsEmbeddingProvider.T_INLINE_HTML)) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                }
                if (!state.in_inlined_javascript && !state.in_javascript) continue;
                boolean wasInPhp = false;
                while ((hasNext = tokenSequence.moveNext()) && !tokenSequence.token().id().name().equals(JsEmbeddingProvider.T_INLINE_HTML)) {
                    wasInPhp = true;
                }
                if (hasNext) {
                    tokenSequence.movePrevious();
                }
                if (!wasInPhp) continue;
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return embeddings;
        }
    }

    private static final class JspTranslator
    implements Translator {
        private JspTranslator() {
        }

        @Override
        public List<Embedding> translate(Snapshot snapshot) {
            TokenHierarchy th = snapshot.getTokenHierarchy();
            if (th == null) {
                return Collections.emptyList();
            }
            TokenSequence tokenSequence = th.tokenSequence();
            ArrayList<Embedding> embeddings = new ArrayList<Embedding>();
            JsAnalyzerState state = new JsAnalyzerState();
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id().primaryCategory().equals("text")) {
                    TokenSequence ts = tokenSequence.embedded(HTMLTokenId.language());
                    if (ts == null) continue;
                    JsEmbeddingProvider.extractJavaScriptFromHtml(snapshot, (TokenSequence<? extends HTMLTokenId>)ts, state, embeddings);
                    continue;
                }
                if (!token.id().primaryCategory().equals("expression-language") && !token.id().primaryCategory().equals("scriptlet") && (!token.id().primaryCategory().equals("symbol") || !"/>".equals(((Object)token.text()).toString())) || !state.in_inlined_javascript && !state.in_javascript) continue;
                embeddings.add(snapshot.create((CharSequence)JsEmbeddingProvider.GENERATED_IDENTIFIER, "text/javascript"));
            }
            return embeddings;
        }
    }

    private static interface Translator {
        public List<Embedding> translate(Snapshot var1);
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            if (!snapshot.getSource().getMimeType().equals("text/xhtml") && snapshot.getMimeType().equals(JsEmbeddingProvider.HTML_MIME_TYPE) && snapshot.getMimePath().size() > 1) {
                return null;
            }
            Translator t = (Translator)translators.get(snapshot.getMimeType());
            if (t != null) {
                return Collections.singleton(new JsEmbeddingProvider(snapshot.getMimeType(), t));
            }
            return Collections.emptyList();
        }
    }
}

