/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.javascript.editing.lexer.JsCommentTokenId;
import org.openide.util.NbBundle;

public class JsCommentFormatter {
    private static final String PARAM_TAG = "@param";
    private static final String RETURN_TAG = "@return";
    private static final String TYPE_TAG = "@type";
    private static final String THROWS_TAG = "@throws";
    private static final String DEPRECATED_TAG = "@deprecated";
    private static final String CODE_TAG = "@code";
    private static final String EXAMPLE_TAG = "@example";
    private static final String DESCRIPTION_TAG = "@description";
    private final TokenSequence<? extends JsCommentTokenId> ts;
    private final StringBuilder summary = new StringBuilder();
    private String returnTag;
    private String returnType;
    private String deprecation;
    private String code;
    private final List<String> params;
    private final List<String> exceptions;
    private boolean formattedComment;
    private final StringBuilder rest = new StringBuilder();

    public JsCommentFormatter(List<String> comments) {
        this.params = new ArrayList<String>();
        this.exceptions = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String line : comments) {
            sb.append(line);
            sb.append("\n");
        }
        boolean haveJsTag = false;
        boolean haveMDC = false;
        int n = comments.size();
        for (int i = 0; i < n; ++i) {
            String s = comments.get(i);
            if (s.indexOf("MDC:Copyrights") != -1) {
                haveMDC = true;
                break;
            }
            if (s.indexOf(64) == -1) continue;
            haveJsTag = true;
        }
        if (haveMDC) {
            this.formattedComment = true;
        } else if (!haveJsTag) {
            this.formattedComment = true;
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)sb.toString(), JsCommentTokenId.language());
        this.ts = hi.tokenSequence(JsCommentTokenId.language());
        this.process();
    }

    void setSeqName(String name) {
    }

    String toHtml() {
        StringBuilder sb = new StringBuilder();
        if (!this.formattedComment && this.summary.length() > 0) {
            String summaryText = this.summary.toString().trim();
            if (summaryText.length() > 0) {
                sb.append("<b>");
                sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Summary"));
                sb.append("</b><blockquote>").append(summaryText).append("</blockquote>");
            }
        } else {
            sb.append((CharSequence)this.summary);
        }
        if (this.deprecation != null) {
            boolean hasDescription = this.deprecation.trim().length() > 0;
            sb.append("<b");
            if (!hasDescription) {
                sb.append(" style=\"background:#ffcccc\"");
            }
            sb.append(">");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Deprecated"));
            sb.append("</b>");
            sb.append("<blockquote");
            if (hasDescription) {
                sb.append(" style=\"background:#ffcccc\">");
                sb.append(this.deprecation);
            } else {
                sb.append(">");
            }
            sb.append("</blockquote>");
        }
        if (this.params.size() > 0) {
            sb.append("<b>");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Parameters"));
            sb.append("</b><blockquote>");
            int n = this.params.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append("<br><br>");
                }
                String tag = this.params.get(i);
                sb.append(tag);
            }
            sb.append("</blockquote>");
        }
        if (this.returnTag != null || this.returnType != null) {
            sb.append("<b>");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Returns"));
            sb.append("</b><blockquote>");
            if (this.returnTag != null) {
                sb.append(this.returnTag);
                if (this.returnType != null) {
                    sb.append("<br>");
                }
            }
            if (this.returnType != null) {
                sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"ReturnType"));
                sb.append(" <i>");
                sb.append(this.returnType);
                sb.append("</i>");
            }
            sb.append("</blockquote>");
        }
        if (this.exceptions.size() > 0) {
            sb.append("<b>");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Throws"));
            sb.append("</b><blockquote>");
            for (String tag : this.exceptions) {
                sb.append(tag);
                sb.append("<br>");
            }
            sb.append("</blockquote>");
        }
        if (this.code != null) {
            sb.append("<b>");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"CodeExample"));
            sb.append("</b><blockquote>");
            sb.append("<pre>").append(this.code).append("</pre></blockquote>");
        }
        if (this.rest.length() > 0) {
            sb.append("<b>");
            sb.append(NbBundle.getMessage(JsCommentFormatter.class, (String)"Miscellaneous"));
            sb.append("</b><blockquote>");
            sb.append((CharSequence)this.rest);
            sb.append("</blockquote>");
        }
        return sb.toString();
    }

    String getSummary() {
        return this.summary.toString().trim();
    }

    List<String> getParams() {
        return this.params;
    }

    List<String> getExceptions() {
        return this.exceptions;
    }

    String getReturn() {
        return this.returnTag;
    }

    private void process() {
        while (this.ts.moveNext() && this.ts.token().id() != JsCommentTokenId.COMMENT_TAG) {
            this.summary.append(this.ts.token().text());
        }
        this.ts.movePrevious();
        StringBuilder sb = null;
        while (this.ts.moveNext()) {
            if (this.ts.token().id() == JsCommentTokenId.COMMENT_TAG) {
                if (sb != null) {
                    this.processTag(sb.toString().trim());
                }
                sb = new StringBuilder();
            }
            if (sb == null) continue;
            sb.append(this.ts.token().text());
        }
        if (sb != null) {
            this.processTag(sb.toString().trim());
        }
    }

    private void processTag(String tag) {
        if (tag.startsWith(PARAM_TAG)) {
            int end;
            String s = tag.substring(PARAM_TAG.length()).trim();
            if (s.length() == 0) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            int index = 0;
            if (s.charAt(0) == '{') {
                end = s.indexOf(125);
                if (end != -1) {
                    sb.append("<i>");
                    sb.append(s.substring(0, ++end));
                    sb.append("</i>");
                }
                for (index = end; index < s.length() && Character.isWhitespace(s.charAt(index)); ++index) {
                }
            }
            if (index < s.length()) {
                for (end = index; end < s.length() && !Character.isWhitespace(s.charAt(end)); ++end) {
                }
                if (end < s.length()) {
                    sb.append(" <b>");
                    sb.append(s.substring(index, end));
                    sb.append("</b>");
                    sb.append(s.substring(end));
                    this.params.add(sb.toString());
                    return;
                }
            }
            this.params.add(s);
        } else if (tag.startsWith(DESCRIPTION_TAG)) {
            String desc = tag.substring(DESCRIPTION_TAG.length()).trim();
            this.summary.insert(0, desc);
        } else if (tag.startsWith(RETURN_TAG)) {
            this.returnTag = tag.substring(RETURN_TAG.length()).trim();
        } else if (tag.startsWith(TYPE_TAG)) {
            this.returnType = tag.substring(TYPE_TAG.length()).trim();
        } else if (tag.startsWith(THROWS_TAG)) {
            this.exceptions.add(tag.substring(THROWS_TAG.length()).trim());
        } else if (tag.startsWith(DEPRECATED_TAG)) {
            this.deprecation = tag.substring(DEPRECATED_TAG.length()).trim();
        } else if (tag.startsWith(CODE_TAG)) {
            this.code = tag.substring(CODE_TAG.length()).trim();
            this.code = this.code.replace("&", "&amp;");
            this.code = this.code.replace("<", "&lt;");
            this.code = this.code.replace(">", "&gt;");
        } else if (tag.startsWith(EXAMPLE_TAG)) {
            this.code = tag.substring(EXAMPLE_TAG.length()).trim();
            this.code = this.code.replace("&", "&amp;");
            this.code = this.code.replace("<", "&lt;");
            this.code = this.code.replace(">", "&gt;");
        } else if (!(tag.startsWith("@id ") || tag.startsWith("@name ") || tag.startsWith("@attribute") || tag.startsWith("@compat") || tag.startsWith("@method") || tag.startsWith("@property"))) {
            this.rest.append(tag);
            this.rest.append("<br>");
        }
    }
}

