/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli.configuration;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.maven.artifact.InvalidRepositoryException;
import org.apache.maven.bridge.MavenRepositorySystem;
import org.apache.maven.building.Source;
import org.apache.maven.cli.CliRequest;
import org.apache.maven.cli.configuration.ConfigurationProcessor;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;

@Component(role=ConfigurationProcessor.class, hint="settings")
public class SettingsXmlConfigurationProcessor
implements ConfigurationProcessor {
    public static final String HINT = "settings";
    public static final String USER_HOME = System.getProperty("user.home");
    public static final File USER_MAVEN_CONFIGURATION_HOME = new File(USER_HOME, ".m2");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(USER_MAVEN_CONFIGURATION_HOME, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    @Requirement
    private Logger logger;
    @Requirement
    private SettingsBuilder settingsBuilder;
    @Requirement
    private SettingsDecrypter settingsDecrypter;

    @Override
    public void process(CliRequest cliRequest) throws Exception {
        File globalSettingsFile;
        File userSettingsFile;
        CommandLine commandLine = cliRequest.getCommandLine();
        String workingDirectory = cliRequest.getWorkingDirectory();
        MavenExecutionRequest request = cliRequest.getRequest();
        if (commandLine.hasOption('s')) {
            userSettingsFile = new File(commandLine.getOptionValue('s'));
            if (!(userSettingsFile = SettingsXmlConfigurationProcessor.resolveFile(userSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified user settings file does not exist: " + userSettingsFile);
            }
        } else {
            userSettingsFile = DEFAULT_USER_SETTINGS_FILE;
        }
        if (commandLine.hasOption("gs")) {
            globalSettingsFile = new File(commandLine.getOptionValue("gs"));
            if (!(globalSettingsFile = SettingsXmlConfigurationProcessor.resolveFile(globalSettingsFile, workingDirectory)).isFile()) {
                throw new FileNotFoundException("The specified global settings file does not exist: " + globalSettingsFile);
            }
        } else {
            globalSettingsFile = DEFAULT_GLOBAL_SETTINGS_FILE;
        }
        request.setGlobalSettingsFile(globalSettingsFile);
        request.setUserSettingsFile(userSettingsFile);
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        settingsRequest.setGlobalSettingsFile(globalSettingsFile);
        settingsRequest.setUserSettingsFile(userSettingsFile);
        settingsRequest.setSystemProperties(cliRequest.getSystemProperties());
        settingsRequest.setUserProperties(cliRequest.getUserProperties());
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsRequest);
        }
        this.logger.debug("Reading global settings from " + this.getLocation((Source)settingsRequest.getGlobalSettingsSource(), settingsRequest.getGlobalSettingsFile()));
        this.logger.debug("Reading user settings from " + this.getLocation((Source)settingsRequest.getUserSettingsSource(), settingsRequest.getUserSettingsFile()));
        SettingsBuildingResult settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
        if (request.getEventSpyDispatcher() != null) {
            request.getEventSpyDispatcher().onEvent((Object)settingsResult);
        }
        this.populateFromSettings(request, settingsResult.getEffectiveSettings());
        if (!settingsResult.getProblems().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.logger.warn("");
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies(request.getProxies());
        decrypt.setServers(request.getServers());
        SettingsDecryptionResult decrypted = this.settingsDecrypter.decrypt((SettingsDecryptionRequest)decrypt);
        if (this.logger.isDebugEnabled()) {
            for (SettingsProblem problem : decrypted.getProblems()) {
                this.logger.debug(problem.getMessage(), (Throwable)problem.getException());
            }
        }
        request.setProxies(decrypt.getProxies());
        request.setServers(decrypt.getServers());
    }

    public MavenExecutionRequest populateFromSettings(MavenExecutionRequest request, Settings settings) throws MavenExecutionRequestPopulationException {
        if (settings == null) {
            return request;
        }
        request.setOffline(settings.isOffline());
        request.setInteractiveMode(settings.isInteractiveMode());
        request.setPluginGroups(settings.getPluginGroups());
        request.setLocalRepositoryPath(settings.getLocalRepository());
        for (Server server : settings.getServers()) {
            server = server.clone();
            request.addServer(server);
        }
        for (Proxy proxy : settings.getProxies()) {
            if (!proxy.isActive()) continue;
            proxy = proxy.clone();
            request.addProxy(proxy);
        }
        for (Mirror mirror : settings.getMirrors()) {
            mirror = mirror.clone();
            request.addMirror(mirror);
        }
        request.setActiveProfiles(settings.getActiveProfiles());
        for (Profile rawProfile : settings.getProfiles()) {
            request.addProfile(SettingsUtils.convertFromSettingsProfile((Profile)rawProfile));
            if (!settings.getActiveProfiles().contains(rawProfile.getId())) continue;
            List remoteRepositories = rawProfile.getRepositories();
            for (Repository remoteRepository : remoteRepositories) {
                try {
                    request.addRemoteRepository(MavenRepositorySystem.buildArtifactRepository((Repository)remoteRepository));
                }
                catch (InvalidRepositoryException e) {}
            }
            List pluginRepositories = rawProfile.getPluginRepositories();
            for (Repository pluginRepository : pluginRepositories) {
                try {
                    request.addPluginArtifactRepository(MavenRepositorySystem.buildArtifactRepository((Repository)pluginRepository));
                }
                catch (InvalidRepositoryException e) {}
            }
        }
        return request;
    }

    private Object getLocation(Source source, File defaultLocation) {
        if (source != null) {
            return source.getLocation();
        }
        return defaultLocation;
    }

    static File resolveFile(File file, String workingDirectory) {
        if (file == null) {
            return null;
        }
        if (file.isAbsolute()) {
            return file;
        }
        if (file.getPath().startsWith(File.separator)) {
            return file.getAbsoluteFile();
        }
        return new File(workingDirectory, file.getPath()).getAbsoluteFile();
    }
}

