/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.X509TrustManager;
import org.jruby.Ruby;
import org.jruby.ext.openssl.x509store.CRL;
import org.jruby.ext.openssl.x509store.Certificate;
import org.jruby.ext.openssl.x509store.CertificateFile;
import org.jruby.ext.openssl.x509store.CertificateHashDir;
import org.jruby.ext.openssl.x509store.Function1;
import org.jruby.ext.openssl.x509store.Function2;
import org.jruby.ext.openssl.x509store.Function3;
import org.jruby.ext.openssl.x509store.Lookup;
import org.jruby.ext.openssl.x509store.LookupMethod;
import org.jruby.ext.openssl.x509store.StoreContext;
import org.jruby.ext.openssl.x509store.VerifyParameter;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;
import org.jruby.ext.openssl.x509store.X509Error;
import org.jruby.ext.openssl.x509store.X509Object;

public class Store
implements X509TrustManager {
    @Deprecated
    int cache = 1;
    private volatile X509Object[] objects = new X509Object[0];
    private volatile Lookup[] certLookups = new Lookup[0];
    public final VerifyParameter verifyParameter;
    VerifyFunction verify = VerifyFunction.EMPTY;
    VerifyCallbackFunction verifyCallback = VerifyCallbackFunction.EMPTY;
    GetIssuerFunction getIssuer = GetIssuerFunction.EMPTY;
    CheckIssuedFunction checkIssued = CheckIssuedFunction.EMPTY;
    CheckRevocationFunction checkRevocation = CheckRevocationFunction.EMPTY;
    GetCRLFunction getCRL = GetCRLFunction.EMPTY;
    CheckCRLFunction checkCRL = CheckCRLFunction.EMPTY;
    CertificateCRLFunction certificateCRL = CertificateCRLFunction.EMPTY;
    CleanupFunction cleanup = CleanupFunction.EMPTY;
    private final List<Object> extraData;

    public Store() {
        this.verifyParameter = new VerifyParameter();
        this.extraData = new ArrayList<Object>(10);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
        this.extraData.add(null);
    }

    public List<X509Object> getObjects() {
        return Arrays.asList(this.objects);
    }

    public List<Lookup> getCertificateMethods() {
        return Arrays.asList(this.certLookups);
    }

    public VerifyParameter getVerifyParameter() {
        return this.verifyParameter;
    }

    public VerifyFunction getVerifyFunction() {
        return this.verify;
    }

    public void setVerifyFunction(VerifyFunction func) {
        this.verify = func;
    }

    public VerifyCallbackFunction getVerifyCallback() {
        return this.verifyCallback;
    }

    public void setVerifyCallbackFunction(VerifyCallbackFunction func) {
        this.verifyCallback = func;
    }

    public void free() throws Exception {
        for (Lookup lu : this.certLookups) {
            lu.shutdown();
            lu.free();
        }
        if (this.verifyParameter != null) {
            this.verifyParameter.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setExtraData(int idx, Object data) {
        List<Object> list = this.extraData;
        synchronized (list) {
            this.extraData.set(idx, data);
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getExtraData(int idx) {
        List<Object> list = this.extraData;
        synchronized (list) {
            return this.extraData.get(idx);
        }
    }

    public int setDepth(int depth) {
        this.verifyParameter.setDepth(depth);
        return 1;
    }

    public int setFlags(long flags) {
        return this.verifyParameter.setFlags(flags);
    }

    public int setPurpose(int purpose) {
        return this.verifyParameter.setPurpose(purpose);
    }

    public int setTrust(int trust) {
        return this.verifyParameter.setTrust(trust);
    }

    public int setParam(VerifyParameter pm) {
        return this.verifyParameter.set(this.verifyParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup addLookup(Ruby runtime, LookupMethod method) {
        Lookup[] certLookups = this.certLookups;
        Lookup foundLookup = Store.findLookupMethod(certLookups, method);
        if (foundLookup != null) {
            return foundLookup;
        }
        Lookup newLookup = new Lookup(runtime, method);
        newLookup.store = this;
        Store store = this;
        synchronized (store) {
            int length = this.certLookups.length;
            if (certLookups.length != length && (foundLookup = Store.findLookupMethod(this.certLookups, method)) != null) {
                return foundLookup;
            }
            Lookup[] newCertLookups = Arrays.copyOf(this.certLookups, length + 1);
            newCertLookups[length] = newLookup;
            this.certLookups = newCertLookups;
        }
        return newLookup;
    }

    private static Lookup findLookupMethod(Lookup[] lookups, LookupMethod method) {
        for (Lookup lookup : lookups) {
            if (!lookup.method.equals(method)) continue;
            return lookup;
        }
        return null;
    }

    public int addCertificate(X509Certificate cert2) {
        if (cert2 == null) {
            return 0;
        }
        X509Object[] objects = this.objects;
        Certificate certObj = new Certificate(StoreContext.ensureAux(cert2));
        if (Store.matchedObject(objects, certObj)) {
            X509Error.addError(101);
            return 0;
        }
        return this.addObject(certObj, objects.length);
    }

    public int addCRL(java.security.cert.CRL crl2) {
        if (crl2 == null) {
            return 0;
        }
        CRL crlObj = new CRL();
        crlObj.crl = crl2;
        X509Object[] objects = this.objects;
        if (Store.matchedObject(objects, crlObj)) {
            X509Error.addError(101);
            return 0;
        }
        return this.addObject(crlObj, objects.length);
    }

    private static boolean matchedObject(X509Object[] objects, X509Object xObject) {
        for (int i2 = 0; i2 < objects.length; ++i2) {
            if (!objects[i2].matches(xObject)) continue;
            return true;
        }
        return false;
    }

    private synchronized int addObject(X509Object xObject, int prevLength) {
        int length = this.objects.length;
        if (length != prevLength && Store.matchedObject(this.objects, xObject)) {
            X509Error.addError(101);
            return 0;
        }
        X509Object[] newObjects = Arrays.copyOf(this.objects, length + 1);
        newObjects[length] = xObject;
        this.objects = newObjects;
        return 1;
    }

    public int loadLocations(Ruby runtime, String file, String path) throws Exception {
        Lookup lookup;
        if (file != null) {
            lookup = this.addLookup(runtime, Lookup.fileLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.loadFile(new CertificateFile.Path(file, 1)) != 1) {
                return 0;
            }
        }
        if (path != null) {
            lookup = this.addLookup(runtime, Lookup.hashDirLookup());
            if (lookup == null) {
                return 0;
            }
            if (lookup.addDir(new CertificateHashDir.Dir(path, 1)) != 1) {
                return 0;
            }
        }
        if (path == null && file == null) {
            return 0;
        }
        return 1;
    }

    public int setDefaultPaths(Ruby runtime) throws Exception {
        block7: {
            Lookup lookup;
            block6: {
                lookup = this.addLookup(runtime, Lookup.fileLookup());
                try {
                    lookup.loadFile(new CertificateFile.Path(null, 3));
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException e) {
                    if (e.getClass().getSimpleName().equals("NotFound")) break block6;
                    throw e;
                }
            }
            lookup = this.addLookup(runtime, Lookup.hashDirLookup());
            try {
                lookup.addDir(new CertificateHashDir.Dir(null, 3));
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                if (e.getClass().getSimpleName().equals("NotFound")) break block7;
                throw e;
            }
        }
        X509Error.clearErrors();
        return 1;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain2, String authType) {
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain2, String authType) {
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        X509Object[] objects = this.objects;
        ArrayList<X509AuxCertificate> issuers = new ArrayList<X509AuxCertificate>(objects.length);
        for (int i2 = 0; i2 < objects.length; ++i2) {
            X509Object object = objects[i2];
            if (!(object instanceof Certificate)) continue;
            issuers.add(((Certificate)object).x509);
        }
        return issuers.toArray(new X509Certificate[issuers.size()]);
    }

    static interface CleanupFunction
    extends Function1<StoreContext> {
        public static final CleanupFunction EMPTY = new CleanupFunction(){

            @Override
            public int call(StoreContext context2) {
                return -1;
            }
        };
    }

    static interface CertificateCRLFunction
    extends Function3<StoreContext, X509CRL, X509AuxCertificate> {
        public static final CertificateCRLFunction EMPTY = new CertificateCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL crl2, X509AuxCertificate cert2) {
                return -1;
            }
        };
    }

    static interface CheckCRLFunction
    extends Function2<StoreContext, X509CRL> {
        public static final CheckCRLFunction EMPTY = new CheckCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL crl2) {
                return -1;
            }
        };
    }

    static interface GetCRLFunction
    extends Function3<StoreContext, X509CRL[], X509AuxCertificate> {
        public static final GetCRLFunction EMPTY = new GetCRLFunction(){

            @Override
            public int call(StoreContext context2, X509CRL[] crls2, X509AuxCertificate cert2) {
                return -1;
            }
        };
    }

    static interface CheckRevocationFunction
    extends Function1<StoreContext> {
        public static final CheckRevocationFunction EMPTY = new CheckRevocationFunction(){

            @Override
            public int call(StoreContext context2) {
                return -1;
            }
        };
    }

    static interface CheckIssuedFunction
    extends Function3<StoreContext, X509AuxCertificate, X509AuxCertificate> {
        public static final CheckIssuedFunction EMPTY = new CheckIssuedFunction(){

            @Override
            public int call(StoreContext context2, X509AuxCertificate cert2, X509AuxCertificate issuer2) throws Exception {
                return -1;
            }
        };
    }

    static interface GetIssuerFunction
    extends Function3<StoreContext, X509AuxCertificate[], X509AuxCertificate> {
        public static final GetIssuerFunction EMPTY = new GetIssuerFunction(){

            @Override
            public int call(StoreContext context2, X509AuxCertificate[] issuer2, X509AuxCertificate cert2) {
                return -1;
            }
        };
    }

    public static interface VerifyCallbackFunction
    extends Function2<StoreContext, Integer> {
        public static final VerifyCallbackFunction EMPTY = new VerifyCallbackFunction(){

            @Override
            public int call(StoreContext context2, Integer outcome) {
                return -1;
            }
        };
    }

    public static interface VerifyFunction
    extends Function1<StoreContext> {
        public static final VerifyFunction EMPTY = new VerifyFunction(){

            @Override
            public int call(StoreContext context2) {
                return -1;
            }
        };
    }
}

