/*
 * Decompiled with CFR 0.152.
 */
package nokogiri;

import java.util.List;
import nokogiri.NokogiriService;
import nokogiri.XmlNamespace;
import nokogiri.XmlNode;
import nokogiri.internals.NokogiriHelpers;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@JRubyClass(name={"Nokogiri::XML::NodeSet"})
public class XmlNodeSet
extends RubyObject
implements NodeList {
    private List<?> list;
    private RubyArray nodes;
    private IRubyObject doc;

    public XmlNodeSet(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    void setNodes(RubyArray rubyArray) {
        this.nodes = rubyArray;
        IRubyObject iRubyObject = rubyArray.first();
        this.initialize(rubyArray.getRuntime(), iRubyObject);
    }

    private void setReference(XmlNodeSet xmlNodeSet) {
        this.nodes = null;
        IRubyObject iRubyObject = xmlNodeSet.nodes.first();
        this.initialize(xmlNodeSet.getRuntime(), iRubyObject);
    }

    public void setNodeList(NodeList nodeList) {
        this.setNodes(NokogiriHelpers.nodeListToRubyArray(this.getRuntime(), nodeList));
    }

    public void initialize(Ruby ruby, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode) {
            XmlNode xmlNode = (XmlNode)iRubyObject;
            this.doc = xmlNode.document(ruby.getCurrentContext());
            this.setInstanceVariable("@document", this.doc);
            if (this.doc != null) {
                RuntimeHelpers.invoke((ThreadContext)ruby.getCurrentContext(), (IRubyObject)this.doc, (String)"decorate", (IRubyObject)this);
            }
        }
    }

    public static IRubyObject newEmptyNodeSet(ThreadContext threadContext) {
        return (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::NodeSet"));
    }

    public long length() {
        if (this.nodes == null) {
            return 0L;
        }
        return this.nodes.length().getLongValue();
    }

    public void relink_namespace(ThreadContext threadContext) {
        List list = this.nodes.getList();
        for (int i = 0; i < list.size(); ++i) {
            if (!(list.get(i) instanceof XmlNode)) continue;
            ((XmlNode)((Object)list.get(i))).relink_namespace(threadContext);
        }
    }

    @JRubyMethod(name={"&"})
    public IRubyObject and(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)this.nodes.op_and((IRubyObject)this.asXmlNodeSet((ThreadContext)threadContext, (IRubyObject)iRubyObject).nodes));
    }

    @JRubyMethod
    public IRubyObject delete(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        if (iRubyObject instanceof XmlNamespace) {
            ((XmlNamespace)iRubyObject).deleteHref();
        }
        return this.nodes.delete(threadContext, this.asXmlNodeOrNamespace(threadContext, iRubyObject), Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject dup(ThreadContext threadContext) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, this.nodes.aryDup());
    }

    @JRubyMethod(name={"include?"})
    public IRubyObject include_p(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return this.nodes.include_p(threadContext, this.asXmlNodeOrNamespace(threadContext, iRubyObject));
    }

    @JRubyMethod(name={"length", "size"})
    public IRubyObject length(ThreadContext threadContext) {
        if (this.nodes != null) {
            return this.nodes.length();
        }
        return threadContext.getRuntime().newFixnum(0);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_diff(ThreadContext threadContext, IRubyObject iRubyObject) {
        XmlNodeSet xmlNodeSet = this.newXmlNodeSet(threadContext, this);
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        xmlNodeSet.setNodes((RubyArray)this.nodes.op_diff((IRubyObject)this.asXmlNodeSet((ThreadContext)threadContext, (IRubyObject)iRubyObject).nodes));
        return xmlNodeSet;
    }

    @JRubyMethod(name={"|", "+"})
    public IRubyObject op_or(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)this.nodes.op_or((IRubyObject)this.asXmlNodeSet((ThreadContext)threadContext, (IRubyObject)iRubyObject).nodes));
    }

    @JRubyMethod(name={"push", "<<"})
    public IRubyObject push(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        this.nodes.append(this.asXmlNodeOrNamespace(threadContext, iRubyObject));
        return this;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        IRubyObject iRubyObject2 = threadContext.getRuntime().is1_9() ? this.nodes.aref19(iRubyObject) : this.nodes.aref(iRubyObject);
        if (iRubyObject2 instanceof RubyArray) {
            return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)iRubyObject2);
        }
        return iRubyObject2;
    }

    @JRubyMethod(name={"[]", "slice"})
    public IRubyObject slice(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        if (this.nodes == null) {
            return threadContext.getRuntime().getNil();
        }
        IRubyObject iRubyObject3 = threadContext.getRuntime().is1_9() ? this.nodes.aref19(iRubyObject, iRubyObject2) : this.nodes.aref(iRubyObject, iRubyObject2);
        if (iRubyObject3 instanceof RubyArray) {
            return XmlNodeSet.newXmlNodeSet(threadContext, (RubyArray)iRubyObject3);
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"to_a", "to_ary"})
    public IRubyObject to_a(ThreadContext threadContext) {
        return this.nodes;
    }

    @JRubyMethod(name={"unlink", "remove"})
    public IRubyObject unlink(ThreadContext threadContext) {
        if (this.nodes == null) {
            this.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        IRubyObject[] iRubyObjectArray = this.nodes.toJavaArrayUnsafe();
        long l = iRubyObjectArray.length;
        int n = 0;
        while ((long)n < l) {
            if (iRubyObjectArray[n] instanceof XmlNode) {
                ((XmlNode)iRubyObjectArray[n]).unlink(threadContext);
            }
            ++n;
        }
        return this;
    }

    public static XmlNodeSet newXmlNodeSet(ThreadContext threadContext, RubyArray rubyArray) {
        XmlNodeSet xmlNodeSet = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::NodeSet"));
        xmlNodeSet.setNodes(rubyArray);
        return xmlNodeSet;
    }

    private XmlNodeSet newXmlNodeSet(ThreadContext threadContext, XmlNodeSet xmlNodeSet) {
        XmlNodeSet xmlNodeSet2 = (XmlNodeSet)NokogiriService.XML_NODESET_ALLOCATOR.allocate(threadContext.getRuntime(), NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::NodeSet"));
        xmlNodeSet2.setReference(xmlNodeSet);
        return xmlNodeSet2;
    }

    private IRubyObject asXmlNodeOrNamespace(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (iRubyObject instanceof XmlNode || iRubyObject instanceof XmlNamespace) {
            return iRubyObject;
        }
        throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::Node or Nokogiri::XML::Namespace");
    }

    private XmlNodeSet asXmlNodeSet(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!RuntimeHelpers.invoke((ThreadContext)threadContext, (IRubyObject)iRubyObject, (String)"is_a?", (IRubyObject)NokogiriHelpers.getNokogiriClass(threadContext.getRuntime(), "Nokogiri::XML::NodeSet")).isTrue()) {
            throw threadContext.getRuntime().newArgumentError("node must be a Nokogiri::XML::NodeSet");
        }
        XmlNodeSet xmlNodeSet = (XmlNodeSet)iRubyObject;
        if (xmlNodeSet.nodes == null) {
            xmlNodeSet.setNodes(RubyArray.newEmptyArray((Ruby)threadContext.getRuntime()));
        }
        return xmlNodeSet;
    }

    @Override
    public int getLength() {
        if (this.nodes == null) {
            return 0;
        }
        return this.nodes.size();
    }

    @Override
    public Node item(int n) {
        if (this.nodes == null) {
            return null;
        }
        Object object = this.nodes.get(n);
        if (object instanceof XmlNode) {
            return ((XmlNode)((Object)object)).node;
        }
        if (object instanceof XmlNamespace) {
            return ((XmlNamespace)((Object)object)).getNode();
        }
        return null;
    }
}

