/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.puma;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class MiniSSL
extends RubyObject {
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new MiniSSL(ruby, rubyClass);
        }
    };
    private static boolean DEBUG = false;
    private SSLEngine engine;
    private MiniSSLBuffer inboundNetData;
    private MiniSSLBuffer outboundAppData;
    private MiniSSLBuffer outboundNetData;

    public static void createMiniSSL(Ruby ruby) {
        RubyModule rubyModule = ruby.defineModule("Puma");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("MiniSSL");
        rubyModule.defineClassUnder("SSLError", ruby.getClass("IOError"), ruby.getClass("IOError").getAllocator());
        RubyClass rubyClass = rubyModule2.defineClassUnder("Engine", ruby.getObject(), ALLOCATOR);
        rubyClass.defineAnnotatedMethods(MiniSSL.class);
    }

    public MiniSSL(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject server(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        RubyClass rubyClass = (RubyClass)iRubyObject;
        return rubyClass.newInstance(threadContext, new IRubyObject[]{iRubyObject2}, Block.NULL_BLOCK);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        char[] cArray = iRubyObject.callMethod(threadContext, "keystore_pass").convertToString().asJavaString().toCharArray();
        keyStore.load(new FileInputStream(iRubyObject.callMethod(threadContext, "keystore").convertToString().asJavaString()), cArray);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, cArray);
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        sSLContext.init(keyManagerFactory.getKeyManagers(), null, null);
        this.engine = sSLContext.createSSLEngine();
        String[] stringArray = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        this.engine.setEnabledProtocols(stringArray);
        this.engine.setUseClientMode(false);
        SSLSession sSLSession = this.engine.getSession();
        this.inboundNetData = new MiniSSLBuffer(sSLSession.getPacketBufferSize());
        this.outboundAppData = new MiniSSLBuffer(sSLSession.getApplicationBufferSize());
        this.outboundAppData.flip();
        this.outboundNetData = new MiniSSLBuffer(sSLSession.getPacketBufferSize());
        return this;
    }

    @JRubyMethod
    public IRubyObject inject(IRubyObject iRubyObject) {
        try {
            byte[] byArray = iRubyObject.convertToString().getBytes();
            MiniSSL.log("Net Data post pre-inject: " + this.inboundNetData);
            this.inboundNetData.put(byArray);
            MiniSSL.log("Net Data post post-inject: " + this.inboundNetData);
            MiniSSL.log("inject(): " + byArray.length + " encrypted bytes from request");
            return this;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    private SSLEngineResult doOp(SSLOperation sSLOperation, MiniSSLBuffer miniSSLBuffer, MiniSSLBuffer miniSSLBuffer2) throws SSLException {
        SSLEngineResult sSLEngineResult = null;
        boolean bl = true;
        block8: while (bl) {
            switch (sSLOperation) {
                case WRAP: {
                    sSLEngineResult = this.engine.wrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                case UNWRAP: {
                    sSLEngineResult = this.engine.unwrap(miniSSLBuffer.getRawBuffer(), miniSSLBuffer2.getRawBuffer());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown SSLOperation: " + (Object)((Object)sSLOperation));
                }
            }
            switch (sSLEngineResult.getStatus()) {
                case BUFFER_OVERFLOW: {
                    MiniSSL.log("SSLOp#doRun(): overflow");
                    MiniSSL.log("SSLOp#doRun(): dst data at overflow: " + miniSSLBuffer2);
                    int n = Math.max(this.engine.getSession().getPacketBufferSize(), this.engine.getSession().getApplicationBufferSize());
                    miniSSLBuffer2.resize(n + miniSSLBuffer2.position());
                    bl = true;
                    continue block8;
                }
                case BUFFER_UNDERFLOW: {
                    MiniSSL.log("SSLOp#doRun(): underflow");
                    MiniSSL.log("SSLOp#doRun(): src data at underflow: " + miniSSLBuffer);
                    bl = false;
                    continue block8;
                }
            }
            bl = false;
        }
        if (this.engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable runnable;
            while ((runnable = this.engine.getDelegatedTask()) != null) {
                runnable.run();
            }
        }
        return sSLEngineResult;
    }

    @JRubyMethod
    public IRubyObject read() throws Exception {
        try {
            this.inboundNetData.flip();
            if (!this.inboundNetData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            MiniSSL.log("read(): inboundNetData prepped for read: " + this.inboundNetData);
            MiniSSLBuffer miniSSLBuffer = new MiniSSLBuffer(this.engine.getSession().getApplicationBufferSize());
            SSLEngineResult sSLEngineResult = this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
            MiniSSL.log("read(): after initial unwrap", this.engine, sSLEngineResult);
            MiniSSL.log("read(): Net Data post unwrap: " + this.inboundNetData);
            SSLEngineResult.HandshakeStatus handshakeStatus = this.engine.getHandshakeStatus();
            boolean bl = false;
            while (!bl) {
                switch (handshakeStatus) {
                    case NEED_WRAP: {
                        sSLEngineResult = this.doOp(SSLOperation.WRAP, miniSSLBuffer, this.outboundNetData);
                        MiniSSL.log("read(): after handshake wrap", this.engine, sSLEngineResult);
                        break;
                    }
                    case NEED_UNWRAP: {
                        sSLEngineResult = this.doOp(SSLOperation.UNWRAP, this.inboundNetData, miniSSLBuffer);
                        MiniSSL.log("read(): after handshake unwrap", this.engine, sSLEngineResult);
                        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) break;
                        bl = true;
                        break;
                    }
                    default: {
                        bl = true;
                    }
                }
                handshakeStatus = this.engine.getHandshakeStatus();
            }
            if (this.inboundNetData.hasRemaining()) {
                MiniSSL.log("Net Data post pre-compact: " + this.inboundNetData);
                this.inboundNetData.compact();
                MiniSSL.log("Net Data post post-compact: " + this.inboundNetData);
            } else {
                MiniSSL.log("Net Data post pre-reset: " + this.inboundNetData);
                this.inboundNetData.clear();
                MiniSSL.log("Net Data post post-reset: " + this.inboundNetData);
            }
            ByteList byteList = miniSSLBuffer.asByteList();
            if (byteList == null) {
                return this.getRuntime().getNil();
            }
            RubyString rubyString = this.getRuntime().newString("");
            rubyString.setValue(byteList);
            MiniSSL.logPlain("\n");
            MiniSSL.log("read(): begin dump of request data >>>>\n");
            if (rubyString.asJavaString().getBytes().length < 1000) {
                MiniSSL.logPlain(rubyString.asJavaString() + "\n");
            }
            MiniSSL.logPlain("Num bytes: " + rubyString.asJavaString().getBytes().length + "\n");
            MiniSSL.log("read(): end dump of request data   <<<<\n");
            return rubyString;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            throw this.getRuntime().newEOFError(exception.getMessage());
        }
    }

    private static void log(String string, SSLEngine sSLEngine, SSLEngineResult sSLEngineResult) {
        if (DEBUG) {
            MiniSSL.log(string + " " + (Object)((Object)sSLEngineResult.getStatus()) + "/" + (Object)((Object)sSLEngine.getHandshakeStatus()) + "---bytes consumed: " + sSLEngineResult.bytesConsumed() + ", bytes produced: " + sSLEngineResult.bytesProduced());
        }
    }

    private static void log(String string) {
        if (DEBUG) {
            System.out.println("MiniSSL.java: " + string);
        }
    }

    private static void logPlain(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    @JRubyMethod
    public IRubyObject write(IRubyObject iRubyObject) {
        try {
            MiniSSL.log("write(): begin dump of response data >>>>\n");
            MiniSSL.logPlain("\n");
            if (iRubyObject.asJavaString().getBytes().length < 1000) {
                MiniSSL.logPlain(iRubyObject.asJavaString() + "\n");
            }
            MiniSSL.logPlain("Num bytes: " + iRubyObject.asJavaString().getBytes().length + "\n");
            MiniSSL.log("write(): end dump of response data   <<<<\n");
            byte[] byArray = iRubyObject.convertToString().getBytes();
            this.outboundAppData = new MiniSSLBuffer(byArray);
            return this.getRuntime().newFixnum(byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    @JRubyMethod
    public IRubyObject extract() throws SSLException {
        try {
            ByteList byteList = this.outboundNetData.asByteList();
            if (byteList != null) {
                RubyString rubyString = this.getRuntime().newString("");
                rubyString.setValue(byteList);
                return rubyString;
            }
            if (!this.outboundAppData.hasRemaining()) {
                return this.getRuntime().getNil();
            }
            this.outboundNetData.clear();
            SSLEngineResult sSLEngineResult = this.doOp(SSLOperation.WRAP, this.outboundAppData, this.outboundNetData);
            MiniSSL.log("extract(): bytes consumed: " + sSLEngineResult.bytesConsumed() + "\n");
            MiniSSL.log("extract(): bytes produced: " + sSLEngineResult.bytesProduced() + "\n");
            byteList = this.outboundNetData.asByteList();
            if (byteList == null) {
                return this.getRuntime().getNil();
            }
            RubyString rubyString = this.getRuntime().newString("");
            rubyString.setValue(byteList);
            MiniSSL.log("extract(): " + byteList.getRealSize() + " encrypted bytes for response");
            return rubyString;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SSLOperation {
        WRAP,
        UNWRAP;

    }

    private static class MiniSSLBuffer {
        ByteBuffer buffer;

        private MiniSSLBuffer(int n) {
            this.buffer = ByteBuffer.allocate(n);
        }

        private MiniSSLBuffer(byte[] byArray) {
            this.buffer = ByteBuffer.wrap(byArray);
        }

        public void clear() {
            this.buffer.clear();
        }

        public void compact() {
            this.buffer.compact();
        }

        public void flip() {
            this.buffer.flip();
        }

        public boolean hasRemaining() {
            return this.buffer.hasRemaining();
        }

        public int position() {
            return this.buffer.position();
        }

        public ByteBuffer getRawBuffer() {
            return this.buffer;
        }

        public void put(byte[] byArray) {
            if (this.buffer.remaining() < byArray.length) {
                this.resize(this.buffer.limit() + byArray.length);
            }
            this.buffer.put(byArray);
        }

        public void resize(int n) {
            if (n > this.buffer.capacity()) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n);
                this.buffer.flip();
                byteBuffer.put(this.buffer);
                this.buffer = byteBuffer;
            } else {
                this.buffer.limit(n);
            }
        }

        public ByteList asByteList() {
            this.buffer.flip();
            if (!this.buffer.hasRemaining()) {
                this.buffer.clear();
                return null;
            }
            byte[] byArray = new byte[this.buffer.limit()];
            this.buffer.get(byArray);
            this.buffer.clear();
            return new ByteList(byArray);
        }

        public String toString() {
            return this.buffer.toString();
        }
    }
}

