/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.template;

import java.io.IOException;
import org.msgpack.MessageTypeException;
import org.msgpack.packer.Packer;
import org.msgpack.template.AbstractTemplate;
import org.msgpack.unpacker.Unpacker;

public class FloatTemplate
extends AbstractTemplate<Float> {
    static final FloatTemplate instance = new FloatTemplate();

    private FloatTemplate() {
    }

    @Override
    public void write(Packer pk, Float target, boolean required) throws IOException {
        if (target == null) {
            if (required) {
                throw new MessageTypeException("Attempted to write null");
            }
            pk.writeNil();
            return;
        }
        pk.write(target.floatValue());
    }

    @Override
    public Float read(Unpacker u, Float to, boolean required) throws IOException {
        if (!required && u.trySkipNil()) {
            return null;
        }
        return Float.valueOf(u.readFloat());
    }

    public static FloatTemplate getInstance() {
        return instance;
    }
}

