/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jruby.ir.util.Edge;
import org.jruby.ir.util.EdgeTypeIterable;
import org.jruby.ir.util.Vertex;

public class DirectedGraph<T> {
    private Map<T, Vertex<T>> vertices = new HashMap<T, Vertex<T>>();
    private Set<Edge<T>> edges = new HashSet<Edge<T>>();
    private ArrayList inOrderVerticeData = new ArrayList();
    int vertexIDCounter = 0;

    public Collection<Vertex<T>> vertices() {
        return this.vertices.values();
    }

    public Collection<Edge<T>> edges() {
        return this.edges;
    }

    public Iterable<Edge<T>> edgesOfType(Object type2) {
        return new EdgeTypeIterable<T>(this.edges, type2);
    }

    public Collection<T> allData() {
        return this.vertices.keySet();
    }

    public Collection<T> getInorderData() {
        return this.inOrderVerticeData;
    }

    public void addEdge(T source2, T destination, Object type2) {
        this.vertexFor(source2).addEdgeTo(destination, type2);
    }

    public void removeEdge(Edge edge) {
        edge.getSource().removeEdgeTo(edge.getDestination());
    }

    public void removeEdge(T source2, T destination) {
        if (this.findVertexFor(source2) != null) {
            for (Edge<T> edge : this.vertexFor(source2).getOutgoingEdges()) {
                if (edge.getDestination().getData() != destination) continue;
                this.vertexFor(source2).removeEdgeTo(edge.getDestination());
                return;
            }
        }
    }

    public Vertex<T> findVertexFor(T data2) {
        return this.vertices.get(data2);
    }

    public Vertex<T> vertexFor(T data2) {
        Vertex<T> vertex = this.vertices.get(data2);
        if (vertex != null) {
            return vertex;
        }
        vertex = new Vertex<T>(this, data2, this.vertexIDCounter++);
        this.inOrderVerticeData.add(data2);
        this.vertices.put(data2, vertex);
        return vertex;
    }

    public void removeVertexFor(T data2) {
        if (this.findVertexFor(data2) != null) {
            Vertex<T> vertex = this.vertexFor(data2);
            this.vertices.remove(data2);
            this.inOrderVerticeData.remove(data2);
            vertex.removeAllEdges();
        }
    }

    public int size() {
        return this.allData().size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        ArrayList<Vertex<T>> verts = new ArrayList<Vertex<T>>(this.vertices.values());
        Collections.sort(verts);
        for (Vertex<T> vertex : verts) {
            buf.append(vertex);
        }
        return buf.toString();
    }
}

