'use strict';

Object.defineProperty(exports, '__esModule', {
    value: true
});

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var _postcss = require('postcss');

var _postcss2 = _interopRequireDefault(_postcss);

var _uniqid = require('uniqid');

var _uniqid2 = _interopRequireDefault(_uniqid);

exports['default'] = _postcss2['default'].plugin('postcss-filter-plugins', function () {
    var _ref = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];

    var _ref$template = _ref.template;
    var template = _ref$template === undefined ? function (_ref2) {
        var postcssPlugin = _ref2.postcssPlugin;
        return 'Found duplicate plugin: ' + postcssPlugin;
    } : _ref$template;
    var _ref$silent = _ref.silent;
    var silent = _ref$silent === undefined ? false : _ref$silent;
    var _ref$exclude = _ref.exclude;
    var exclude = _ref$exclude === undefined ? [] : _ref$exclude;
    var _ref$direction = _ref.direction;
    var direction = _ref$direction === undefined ? 'both' : _ref$direction;

    var id = (0, _uniqid2['default'])();
    var prev = undefined,
        next = undefined,
        both = undefined;

    switch (direction) {
        case 'both':
            both = true;
            break;
        case 'backward':
            prev = true;
            break;
        case 'forward':
            next = true;
            break;
    }

    var plugin = function plugin(css, result) {
        var previousPlugins = [];
        var nextPlugins = [];
        var bothPlugins = [];
        var filter = false;
        var position = 0;

        var detect = function detect(list, plugin) {
            var name = plugin.postcssPlugin;
            if (typeof name === 'undefined') {
                position++;
                return;
            }
            if (~list.indexOf(name)) {
                if (!silent) {
                    result.warn(template(plugin));
                }
                result.processor.plugins.splice(position, 1);
            } else {
                list.push(name);
                position++;
            }
        };

        while (position < result.processor.plugins.length) {
            var _plugin = result.processor.plugins[position];
            if (~exclude.indexOf(_plugin.postcssPlugin)) {
                position++;
                continue;
            }
            if (_plugin._id === id) {
                position++;
                filter = true;
                continue;
            } else if (_plugin.postcssPlugin === 'postcss-filter-plugins') {
                position++;
                continue;
            }
            if (both) {
                detect(bothPlugins, _plugin);
                continue;
            }
            if (filter && next) {
                detect(nextPlugins, _plugin);
                continue;
            }
            if (!filter && prev) {
                detect(previousPlugins, _plugin);
                continue;
            }
            position++;
        }
    };

    plugin._id = id;

    return plugin;
});
module.exports = exports['default'];