/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.subsystems;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.List;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.subsystems.SafepointAction;
import org.jruby.truffle.runtime.subsystems.SimpleShell;

public class InstrumentationServerManager {
    private final RubyContext context;
    private final int port;
    private final HttpServer server;
    private volatile boolean shuttingDown = false;

    public InstrumentationServerManager(RubyContext context, int port) {
        this.context = context;
        this.port = port;
        HttpServer server = null;
        try {
            server = HttpServer.create(new InetSocketAddress(port), 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.server = server;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        this.server.createContext("/stacks", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) {
                try {
                    final StringBuilder builder = new StringBuilder();
                    InstrumentationServerManager.this.context.getSafepointManager().pauseAllThreadsAndExecuteFromNonRubyThread(false, new SafepointAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run(DynamicObject thread, Node currentNode) {
                            try {
                                Backtrace backtrace = RubyCallStack.getBacktrace(null);
                                1 var4_5 = this;
                                synchronized (var4_5) {
                                    List<String> lines = BacktraceFormatter.createDefaultFormatter(InstrumentationServerManager.this.context).formatBacktrace(null, backtrace);
                                    builder.append(String.format("#%d %s", Thread.currentThread().getId(), Thread.currentThread().getName()));
                                    builder.append("\n");
                                    for (String line : lines) {
                                        builder.append(line);
                                        builder.append("\n");
                                    }
                                    builder.append("\n");
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    byte[] bytes = builder.toString().getBytes("UTF-8");
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, bytes.length);
                    OutputStream stream = httpExchange.getResponseBody();
                    stream.write(bytes);
                    stream.close();
                }
                catch (IOException e) {
                    if (InstrumentationServerManager.this.shuttingDown) {
                        return;
                    }
                    e.printStackTrace();
                }
            }
        });
        this.server.createContext("/break", new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) {
                try {
                    Thread mainThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(InstrumentationServerManager.this.context.getThreadManager().getRootThread()).getCurrentFiber());
                    InstrumentationServerManager.this.context.getSafepointManager().pauseMainThreadAndExecuteLaterFromNonRubyThread(mainThread, new SafepointAction(){

                        @Override
                        public void run(DynamicObject thread, Node currentNode) {
                            new SimpleShell(InstrumentationServerManager.this.context).run(Truffle.getRuntime().getCurrentFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), currentNode);
                        }
                    });
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, 0L);
                    httpExchange.getResponseBody().close();
                }
                catch (IOException e) {
                    if (InstrumentationServerManager.this.shuttingDown) {
                        return;
                    }
                    e.printStackTrace();
                }
            }
        });
        this.server.start();
    }

    public void shutdown() {
        if (this.server != null) {
            this.shuttingDown = true;
            this.server.stop(1);
        }
    }
}

