/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.signal;

import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.ProcNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.signal.Signal;
import org.jruby.truffle.runtime.signal.SignalHandler;
import org.jruby.truffle.runtime.subsystems.SafepointAction;

public class ProcSignalHandler
implements SignalHandler {
    private final RubyContext context;
    private final DynamicObject proc;

    public ProcSignalHandler(RubyContext context, DynamicObject proc) {
        assert (RubyGuards.isRubyProc(proc));
        this.context = context;
        this.proc = proc;
    }

    @Override
    public void handle(Signal signal) {
        Thread mainThread = Layouts.FIBER.getThread(Layouts.THREAD.getFiberManager(this.context.getThreadManager().getRootThread()).getCurrentFiber());
        this.context.getSafepointManager().pauseMainThreadAndExecuteLaterFromNonRubyThread(mainThread, new SafepointAction(){

            @Override
            public void run(DynamicObject thread, Node currentNode) {
                ProcNodes.rootCall(ProcSignalHandler.this.proc, new Object[0]);
            }
        });
    }
}

