/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts.rubinius;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.rubinius.IOBufferLayout;

public class IOBufferLayoutImpl
extends BasicObjectLayoutImpl
implements IOBufferLayout {
    public static final IOBufferLayout INSTANCE = new IOBufferLayoutImpl();
    protected static final Shape.Allocator I_O_BUFFER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final Property WRITE_SYNCED_PROPERTY = Property.create("@write_synced", I_O_BUFFER_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property STORAGE_PROPERTY = Property.create("@storage", I_O_BUFFER_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property USED_PROPERTY = Property.create("@used", I_O_BUFFER_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property START_PROPERTY = Property.create("@start", I_O_BUFFER_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final Property TOTAL_PROPERTY = Property.create("@total", I_O_BUFFER_ALLOCATOR.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);

    protected IOBufferLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createIOBufferShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new IOBufferType(logicalClass, metaClass)).addProperty(WRITE_SYNCED_PROPERTY).addProperty(STORAGE_PROPERTY).addProperty(USED_PROPERTY).addProperty(START_PROPERTY).addProperty(TOTAL_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createIOBuffer(DynamicObjectFactory factory, boolean writeSynced, DynamicObject storage, int used, int start, int total) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsIOBuffer(factory));
        assert (factory.getShape().hasProperty("@write_synced"));
        assert (factory.getShape().hasProperty("@storage"));
        assert (factory.getShape().hasProperty("@used"));
        assert (factory.getShape().hasProperty("@start"));
        assert (factory.getShape().hasProperty("@total"));
        assert (storage != null);
        return factory.newInstance(writeSynced, storage, used, start, total);
    }

    private boolean isIOBuffer(DynamicObject object) {
        return this.isIOBuffer(object.getShape().getObjectType());
    }

    private boolean isIOBuffer(ObjectType objectType) {
        return objectType instanceof IOBufferType;
    }

    private boolean createsIOBuffer(DynamicObjectFactory factory) {
        return this.isIOBuffer(factory.getShape().getObjectType());
    }

    @Override
    public boolean getWriteSynced(DynamicObject object) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@write_synced"));
        return (Boolean)WRITE_SYNCED_PROPERTY.get(object, true);
    }

    @Override
    public void setWriteSynced(DynamicObject object, boolean value) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@write_synced"));
        try {
            WRITE_SYNCED_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public DynamicObject getStorage(DynamicObject object) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@storage"));
        return (DynamicObject)STORAGE_PROPERTY.get(object, true);
    }

    @Override
    public void setStorage(DynamicObject object, DynamicObject value) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@storage"));
        assert (value != null);
        try {
            STORAGE_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getUsed(DynamicObject object) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@used"));
        return (Integer)USED_PROPERTY.get(object, true);
    }

    @Override
    public void setUsed(DynamicObject object, int value) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@used"));
        try {
            USED_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getStart(DynamicObject object) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@start"));
        return (Integer)START_PROPERTY.get(object, true);
    }

    @Override
    public void setStart(DynamicObject object, int value) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@start"));
        try {
            START_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public int getTotal(DynamicObject object) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@total"));
        return (Integer)TOTAL_PROPERTY.get(object, true);
    }

    @Override
    public void setTotal(DynamicObject object, int value) {
        assert (this.isIOBuffer(object));
        assert (object.getShape().hasProperty("@total"));
        try {
            TOTAL_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    protected static class IOBufferType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public IOBufferType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public IOBufferType setLogicalClass(DynamicObject logicalClass) {
            return new IOBufferType(logicalClass, this.metaClass);
        }

        @Override
        public IOBufferType setMetaClass(DynamicObject metaClass) {
            return new IOBufferType(this.logicalClass, metaClass);
        }
    }
}

