/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime.layouts;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.FinalLocationException;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.IncompatibleLocationException;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import java.util.EnumSet;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.truffle.nodes.core.FiberNodes;
import org.jruby.truffle.om.dsl.api.UnexpectedLayoutRefusalException;
import org.jruby.truffle.runtime.layouts.BasicObjectLayoutImpl;
import org.jruby.truffle.runtime.layouts.FiberLayout;

public class FiberLayoutImpl
extends BasicObjectLayoutImpl
implements FiberLayout {
    public static final FiberLayout INSTANCE = new FiberLayoutImpl();
    protected static final Shape.Allocator FIBER_ALLOCATOR = LAYOUT.createAllocator();
    protected static final HiddenKey ROOT_FIBER_IDENTIFIER = new HiddenKey("rootFiber");
    protected static final Property ROOT_FIBER_PROPERTY = Property.create(ROOT_FIBER_IDENTIFIER, FIBER_ALLOCATOR.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey INITIALIZED_LATCH_IDENTIFIER = new HiddenKey("initializedLatch");
    protected static final Property INITIALIZED_LATCH_PROPERTY = Property.create(INITIALIZED_LATCH_IDENTIFIER, FIBER_ALLOCATOR.locationForType(CountDownLatch.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey MESSAGE_QUEUE_IDENTIFIER = new HiddenKey("messageQueue");
    protected static final Property MESSAGE_QUEUE_PROPERTY = Property.create(MESSAGE_QUEUE_IDENTIFIER, FIBER_ALLOCATOR.locationForType(BlockingQueue.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey RUBY_THREAD_IDENTIFIER = new HiddenKey("rubyThread");
    protected static final Property RUBY_THREAD_PROPERTY = Property.create(RUBY_THREAD_IDENTIFIER, FIBER_ALLOCATOR.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey NAME_IDENTIFIER = new HiddenKey("name");
    protected static final Property NAME_PROPERTY = Property.create(NAME_IDENTIFIER, FIBER_ALLOCATOR.locationForType(String.class), 0);
    protected static final HiddenKey LAST_RESUMED_BY_FIBER_IDENTIFIER = new HiddenKey("lastResumedByFiber");
    protected static final Property LAST_RESUMED_BY_FIBER_PROPERTY = Property.create(LAST_RESUMED_BY_FIBER_IDENTIFIER, FIBER_ALLOCATOR.locationForType(AtomicReference.class), 0);
    protected static final HiddenKey ALIVE_IDENTIFIER = new HiddenKey("alive");
    protected static final Property ALIVE_PROPERTY = Property.create(ALIVE_IDENTIFIER, FIBER_ALLOCATOR.locationForType(AtomicBoolean.class, EnumSet.of(LocationModifier.NonNull)), 0);
    protected static final HiddenKey THREAD_IDENTIFIER = new HiddenKey("thread");
    protected static final Property THREAD_PROPERTY = Property.create(THREAD_IDENTIFIER, FIBER_ALLOCATOR.locationForType(AtomicReference.class), 0);

    protected FiberLayoutImpl() {
    }

    @Override
    public DynamicObjectFactory createFiberShape(DynamicObject logicalClass, DynamicObject metaClass) {
        return LAYOUT.createShape(new FiberType(logicalClass, metaClass)).addProperty(ROOT_FIBER_PROPERTY).addProperty(INITIALIZED_LATCH_PROPERTY).addProperty(MESSAGE_QUEUE_PROPERTY).addProperty(RUBY_THREAD_PROPERTY).addProperty(NAME_PROPERTY).addProperty(LAST_RESUMED_BY_FIBER_PROPERTY).addProperty(ALIVE_PROPERTY).addProperty(THREAD_PROPERTY).createFactory();
    }

    @Override
    public DynamicObject createFiber(DynamicObjectFactory factory, boolean rootFiber, CountDownLatch initializedLatch, BlockingQueue<FiberNodes.FiberMessage> messageQueue, DynamicObject rubyThread, String name, DynamicObject lastResumedByFiber, boolean alive, Thread thread) {
        assert (factory != null);
        CompilerAsserts.partialEvaluationConstant(factory);
        assert (this.createsFiber(factory));
        assert (factory.getShape().hasProperty(ROOT_FIBER_IDENTIFIER));
        assert (factory.getShape().hasProperty(INITIALIZED_LATCH_IDENTIFIER));
        assert (factory.getShape().hasProperty(MESSAGE_QUEUE_IDENTIFIER));
        assert (factory.getShape().hasProperty(RUBY_THREAD_IDENTIFIER));
        assert (factory.getShape().hasProperty(NAME_IDENTIFIER));
        assert (factory.getShape().hasProperty(LAST_RESUMED_BY_FIBER_IDENTIFIER));
        assert (factory.getShape().hasProperty(ALIVE_IDENTIFIER));
        assert (factory.getShape().hasProperty(THREAD_IDENTIFIER));
        assert (initializedLatch != null);
        assert (messageQueue != null);
        assert (rubyThread != null);
        return factory.newInstance(rootFiber, initializedLatch, messageQueue, rubyThread, name, new AtomicReference<DynamicObject>(lastResumedByFiber), new AtomicBoolean(alive), new AtomicReference<Thread>(thread));
    }

    @Override
    public boolean isFiber(DynamicObject object) {
        return this.isFiber(object.getShape().getObjectType());
    }

    private boolean isFiber(ObjectType objectType) {
        return objectType instanceof FiberType;
    }

    private boolean createsFiber(DynamicObjectFactory factory) {
        return this.isFiber(factory.getShape().getObjectType());
    }

    @Override
    public boolean getRootFiber(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(ROOT_FIBER_IDENTIFIER));
        return (Boolean)ROOT_FIBER_PROPERTY.get(object, true);
    }

    @Override
    public CountDownLatch getInitializedLatch(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(INITIALIZED_LATCH_IDENTIFIER));
        return (CountDownLatch)INITIALIZED_LATCH_PROPERTY.get(object, true);
    }

    @Override
    public BlockingQueue<FiberNodes.FiberMessage> getMessageQueue(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(MESSAGE_QUEUE_IDENTIFIER));
        return (BlockingQueue)MESSAGE_QUEUE_PROPERTY.get(object, true);
    }

    @Override
    public DynamicObject getRubyThread(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(RUBY_THREAD_IDENTIFIER));
        return (DynamicObject)RUBY_THREAD_PROPERTY.get(object, true);
    }

    @Override
    public String getName(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        return (String)NAME_PROPERTY.get(object, true);
    }

    @Override
    public void setName(DynamicObject object, String value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(NAME_IDENTIFIER));
        try {
            NAME_PROPERTY.set(object, value, object.getShape());
        }
        catch (FinalLocationException | IncompatibleLocationException e) {
            throw new UnexpectedLayoutRefusalException(e);
        }
    }

    @Override
    public DynamicObject getLastResumedByFiber(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(LAST_RESUMED_BY_FIBER_IDENTIFIER));
        return (DynamicObject)((AtomicReference)LAST_RESUMED_BY_FIBER_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setLastResumedByFiber(DynamicObject object, DynamicObject value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(LAST_RESUMED_BY_FIBER_IDENTIFIER));
        ((AtomicReference)LAST_RESUMED_BY_FIBER_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public boolean getAlive(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(ALIVE_IDENTIFIER));
        return ((AtomicBoolean)ALIVE_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setAlive(DynamicObject object, boolean value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(ALIVE_IDENTIFIER));
        ((AtomicBoolean)ALIVE_PROPERTY.get(object, true)).set(value);
    }

    @Override
    public Thread getThread(DynamicObject object) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(THREAD_IDENTIFIER));
        return (Thread)((AtomicReference)THREAD_PROPERTY.get(object, true)).get();
    }

    @Override
    public void setThread(DynamicObject object, Thread value) {
        assert (this.isFiber(object));
        assert (object.getShape().hasProperty(THREAD_IDENTIFIER));
        ((AtomicReference)THREAD_PROPERTY.get(object, true)).set(value);
    }

    protected static class FiberType
    extends BasicObjectLayoutImpl.BasicObjectType {
        public FiberType(DynamicObject logicalClass, DynamicObject metaClass) {
            super(logicalClass, metaClass);
        }

        @Override
        public FiberType setLogicalClass(DynamicObject logicalClass) {
            return new FiberType(logicalClass, this.metaClass);
        }

        @Override
        public FiberType setMetaClass(DynamicObject metaClass) {
            return new FiberType(this.logicalClass, metaClass);
        }
    }
}

