/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.runtime;

import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.methods.MarkerNode;
import org.jruby.truffle.runtime.array.ArrayUtils;
import org.jruby.truffle.runtime.methods.InternalMethod;

public final class RubyArguments {
    public static final int METHOD_INDEX = 0;
    public static final int DECLARATION_FRAME_INDEX = 1;
    public static final int CALLER_FRAME_INDEX = 2;
    public static final int SELF_INDEX = 3;
    public static final int BLOCK_INDEX = 4;
    public static final int DECLARATION_CONTEXT_INDEX = 5;
    public static final int RUNTIME_ARGUMENT_COUNT = 6;

    public static Object[] pack(InternalMethod method, MaterializedFrame declarationFrame, MaterializedFrame callerFrame, Object self, DynamicObject block, DeclarationContext declarationContext, Object[] arguments) {
        assert (method != null);
        assert (self != null);
        assert (block == null || RubyGuards.isRubyProc(block));
        assert (declarationContext != null);
        assert (arguments != null);
        Object[] packed = new Object[arguments.length + 6];
        packed[0] = method;
        packed[1] = declarationFrame;
        packed[2] = callerFrame;
        packed[3] = self;
        packed[4] = block;
        packed[5] = declarationContext;
        ArrayUtils.arraycopy(arguments, 0, packed, 6, arguments.length);
        return packed;
    }

    public static Object getOptimizedKeywordArgument(Object[] arguments, int index) {
        return arguments[arguments.length - 1 + index];
    }

    public static boolean isKwOptimized(Object[] arguments) {
        return arguments[arguments.length - 1] instanceof MarkerNode.Marker;
    }

    public static InternalMethod getMethod(Object[] arguments) {
        return (InternalMethod)arguments[0];
    }

    public static Object getSelf(Object[] arguments) {
        return arguments[3];
    }

    public static void setSelf(Object[] arguments, Object self) {
        arguments[3] = self;
    }

    public static DynamicObject getBlock(Object[] arguments) {
        return (DynamicObject)arguments[4];
    }

    public static DeclarationContext getDeclarationContext(Object[] arguments) {
        return (DeclarationContext)arguments[5];
    }

    public static void setDeclarationContext(Object[] arguments, DeclarationContext declarationContext) {
        arguments[5] = declarationContext;
    }

    public static Object[] extractUserArguments(Object[] arguments) {
        return ArrayUtils.extractRange(arguments, 6, arguments.length);
    }

    public static Object[] extractUserArgumentsFrom(Object[] arguments, int start) {
        return ArrayUtils.extractRange(arguments, 6 + start, arguments.length);
    }

    public static Object[] extractUserArgumentsWithUnshift(Object first, Object[] arguments) {
        Object[] range = ArrayUtils.extractRange(arguments, 5, arguments.length);
        range[0] = first;
        return range;
    }

    public static int getUserArgumentsCount(Object[] internalArguments) {
        return internalArguments.length - 6;
    }

    public static int getNamedUserArgumentsCount(Object[] internalArguments) {
        if (RubyArguments.isKwOptimized(internalArguments)) {
            return RubyArguments.getUserArgumentsCount(internalArguments) - RubyArguments.getMethod(internalArguments).getSharedMethodInfo().getArity().getKeywordsCount() - 1;
        }
        return RubyArguments.getUserArgumentsCount(internalArguments);
    }

    public static Object getUserArgument(Object[] internalArguments, int index) {
        return internalArguments[6 + index];
    }

    public static void setUserArgument(Object[] internalArguments, int index, Object value) {
        internalArguments[6 + index] = value;
    }

    public static DynamicObject getUserKeywordsHash(Object[] internalArguments, int minArgumentCount) {
        int argumentCount = RubyArguments.getUserArgumentsCount(internalArguments);
        if (argumentCount <= minArgumentCount) {
            return null;
        }
        Object lastArgument = RubyArguments.getUserArgument(internalArguments, argumentCount - 1);
        if (RubyGuards.isRubyHash(lastArgument)) {
            return (DynamicObject)lastArgument;
        }
        return null;
    }

    public static MaterializedFrame tryGetDeclarationFrame(Object[] arguments) {
        if (1 >= arguments.length) {
            return null;
        }
        Object frame = arguments[1];
        if (frame instanceof MaterializedFrame) {
            return (MaterializedFrame)frame;
        }
        return null;
    }

    public static MaterializedFrame getCallerFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[2];
    }

    public static MaterializedFrame getDeclarationFrame(Object[] arguments) {
        return (MaterializedFrame)arguments[1];
    }

    public static MaterializedFrame getDeclarationFrame(VirtualFrame frame, int level) {
        assert (level > 0);
        MaterializedFrame parentFrame = RubyArguments.getDeclarationFrame(frame.getArguments());
        return RubyArguments.getDeclarationFrame(parentFrame, level - 1);
    }

    @ExplodeLoop
    public static MaterializedFrame getDeclarationFrame(MaterializedFrame frame, int level) {
        assert (frame != null);
        assert (level >= 0);
        MaterializedFrame parentFrame = frame;
        for (int n = 0; n < level; ++n) {
            parentFrame = RubyArguments.getDeclarationFrame(parentFrame.getArguments());
        }
        return parentFrame;
    }
}

