/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNode;
import org.jruby.truffle.nodes.cast.ProcOrNullNodeGen;
import org.jruby.truffle.nodes.methods.CallMethodNode;
import org.jruby.truffle.nodes.methods.CallMethodNodeGen;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class GeneralSuperCallNode
extends RubyNode {
    private final boolean isSplatted;
    @Node.Child
    private RubyNode block;
    @Node.Children
    private final RubyNode[] arguments;
    @Node.Child
    ProcOrNullNode procOrNullNode;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;
    @Node.Child
    CallMethodNode callMethodNode;

    public GeneralSuperCallNode(RubyContext context, SourceSection sourceSection, RubyNode block, RubyNode[] arguments, boolean isSplatted) {
        super(context, sourceSection);
        assert (arguments != null);
        assert (!isSplatted || arguments.length == 1);
        this.block = block;
        this.arguments = arguments;
        this.isSplatted = isSplatted;
        this.procOrNullNode = ProcOrNullNodeGen.create(context, sourceSection, null);
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
        this.callMethodNode = CallMethodNodeGen.create(context, sourceSection, null, new RubyNode[0]);
    }

    @Override
    @ExplodeLoop
    public final Object execute(VirtualFrame frame) {
        CompilerAsserts.compilationConstant(this.arguments.length);
        Object self = RubyArguments.getSelf(frame.getArguments());
        Object[] argumentsObjects = new Object[this.arguments.length];
        for (int i = 0; i < this.arguments.length; ++i) {
            argumentsObjects[i] = this.arguments[i].execute(frame);
        }
        DynamicObject blockObject = this.block != null ? this.procOrNullNode.executeProcOrNull(this.block.execute(frame)) : RubyArguments.getBlock(frame.getArguments());
        Object[] argumentsArray = this.isSplatted ? ArrayOperations.toObjectArray((DynamicObject)argumentsObjects[0]) : argumentsObjects;
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            CompilerDirectives.transferToInterpreter();
            String name = RubyArguments.getMethod(frame.getArguments()).getSharedMethodInfo().getName();
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(String.format("super: no superclass method `%s'", name), name, this));
        }
        Object[] frameArguments = RubyArguments.pack(superMethod, superMethod.getDeclarationFrame(), null, self, blockObject, DeclarationContext.METHOD, argumentsArray);
        return this.callMethodNode.executeCallMethod(frame, superMethod, frameArguments);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("super", (Encoding)UTF8Encoding.INSTANCE));
    }
}

