/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.Regex;
import org.jruby.Ruby;
import org.jruby.truffle.nodes.core.RegexpGuards;
import org.jruby.truffle.nodes.core.RegexpNodes;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitive;
import org.jruby.truffle.nodes.rubinius.RubiniusPrimitiveNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.ByteList;
import org.jruby.util.RegexpSupport;

public abstract class RegexpPrimitiveNodes {

    @RubiniusPrimitive(name="regexp_set_block_last_match")
    public static abstract class RegexpSetBlockLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetBlockLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject setBlockLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_set_last_match")
    public static abstract class RegexpSetLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSetLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object setLastMatch(DynamicObject regexpClass, Object matchData) {
            Layouts.THREAD.getThreadLocals(this.getContext().getThreadManager().getCurrentThread()).define("$~", matchData, 0);
            return matchData;
        }
    }

    @RubiniusPrimitive(name="regexp_search_region", lowerFixnumParameters={1, 2})
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpSearchRegionPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpSearchRegionPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"!isInitialized(regexp)", "isRubyString(string)"})
        public Object searchRegionNotInitialized(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
        }

        @Specialization(guards={"isRubyString(string)", "!isValidEncoding(string)"})
        public Object searchRegionInvalidEncoding(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("invalid byte sequence in %s", StringOperations.getByteList(string).getEncoding()), this));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isInitialized(regexp)", "isRubyString(string)", "isValidEncoding(string)"})
        public Object searchRegion(DynamicObject regexp, DynamicObject string, int start, int end, boolean forward) {
            ByteList stringBl = StringOperations.getByteList(string);
            ByteList bl = Layouts.REGEXP.getSource(regexp);
            Encoding enc = RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(string), true);
            ByteList preprocessed = RegexpSupport.preprocess((Ruby)this.getContext().getRuntime(), (ByteList)bl, (Encoding)enc, (Encoding[])new Encoding[]{null}, (RegexpSupport.ErrorMode)RegexpSupport.ErrorMode.RAISE);
            Regex r = new Regex(preprocessed.getUnsafeBytes(), preprocessed.getBegin(), preprocessed.getBegin() + preprocessed.getRealSize(), Layouts.REGEXP.getRegex(regexp).getOptions(), RegexpNodes.checkEncoding(regexp, StringOperations.getCodeRangeable(string), true));
            Matcher matcher = r.matcher(stringBl.getUnsafeBytes(), stringBl.begin(), stringBl.begin() + stringBl.realSize());
            if (forward) {
                return RegexpNodes.matchCommon(this.getContext(), regexp, string, false, false, matcher, start + stringBl.begin(), end + stringBl.begin());
            }
            return RegexpNodes.matchCommon(this.getContext(), regexp, string, false, false, matcher, end + stringBl.begin(), start + stringBl.begin());
        }
    }

    @RubiniusPrimitive(name="regexp_propagate_last_match")
    public static abstract class RegexpPropagateLastMatchPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpPropagateLastMatchPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject propagateLastMatch(DynamicObject regexpClass) {
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="regexp_options")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpOptionsPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpOptionsPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isInitialized(regexp)"})
        public int options(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).toOptions();
        }

        @Specialization(guards={"!isInitialized(regexp)"})
        public int optionsNotInitialized(DynamicObject regexp) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("uninitialized Regexp", this));
        }
    }

    @RubiniusPrimitive(name="regexp_initialize")
    @ImportStatic(value={RegexpGuards.class})
    public static abstract class RegexpInitializePrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpInitializePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRegexpLiteral(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeRegexpLiteral(DynamicObject regexp, DynamicObject pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().securityError("can't modify literal regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initializeAlreadyInitialized(DynamicObject regexp, DynamicObject pattern, int options) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("already initialized regexp", this));
        }

        @Specialization(guards={"!isRegexpLiteral(regexp)", "!isInitialized(regexp)", "isRubyString(pattern)"})
        public DynamicObject initialize(DynamicObject regexp, DynamicObject pattern, int options) {
            RegexpNodes.initialize(this.getContext(), regexp, this, StringOperations.getByteList(pattern), options);
            return regexp;
        }
    }

    @RubiniusPrimitive(name="regexp_fixed_encoding_p")
    public static abstract class RegexpFixedEncodingPrimitiveNode
    extends RubiniusPrimitiveNode {
        public RegexpFixedEncodingPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean fixedEncoding(DynamicObject regexp) {
            return Layouts.REGEXP.getOptions(regexp).isFixed();
        }
    }
}

