/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;

public class ReadMatchReferenceNode
extends RubyNode {
    public static final int PRE = -1;
    public static final int POST = -2;
    public static final int GLOBAL = -3;
    public static final int HIGHEST = -4;
    private final int index;

    public ReadMatchReferenceNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readMatchReference();
    }

    @CompilerDirectives.TruffleBoundary
    private Object readMatchReference() {
        DynamicObject receiver = Layouts.THREAD.getThreadLocals(this.getContext().getThreadManager().getCurrentThread());
        Object match = receiver.get("$~", this.nil());
        if (match == null || match == this.nil()) {
            return this.nil();
        }
        DynamicObject matchData = (DynamicObject)match;
        if (this.index > 0) {
            Object[] values = Arrays.copyOf(Layouts.MATCH_DATA.getValues(matchData), Layouts.MATCH_DATA.getValues(matchData).length);
            if (this.index >= values.length) {
                return this.nil();
            }
            return values[this.index];
        }
        if (this.index == -1) {
            return Layouts.MATCH_DATA.getPre(matchData);
        }
        if (this.index == -2) {
            return Layouts.MATCH_DATA.getPost(matchData);
        }
        if (this.index == -3) {
            return Layouts.MATCH_DATA.getGlobal(matchData);
        }
        if (this.index == -4) {
            Object[] values = Arrays.copyOf(Layouts.MATCH_DATA.getValues(matchData), Layouts.MATCH_DATA.getValues(matchData).length);
            for (int n = values.length - 1; n >= 0; --n) {
                if (values[n] == this.nil()) continue;
                return values[n];
            }
            return this.nil();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (this.execute(frame) != this.nil()) {
            return this.create7BitString(StringOperations.encodeByteList("global-variable", (Encoding)UTF8Encoding.INSTANCE));
        }
        return this.nil();
    }
}

