/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.util.CodeRangeSupport;
import org.jruby.util.CodeRangeable;

public class StringGuards {
    public static boolean isSingleByteOptimizable(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getCodeRange(string) == 16 || StringOperations.getByteList(string).getEncoding().maxLength() == 1;
    }

    public static boolean is7Bit(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getCodeRange(string) == 16;
    }

    public static boolean isAsciiCompatible(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.getByteList(string).getEncoding().isAsciiCompatible();
    }

    public static boolean isSingleByteOptimizableOrAsciiOnly(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringGuards.isSingleByteOptimizable(string);
    }

    public static boolean isSingleByte(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.getByteList(string).getEncoding().isSingleByte();
    }

    public static boolean isValidOr7BitEncoding(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.isCodeRangeValid(string) || CodeRangeSupport.isCodeRangeAsciiOnly((CodeRangeable)StringOperations.getCodeRangeable(string));
    }

    public static boolean isFixedWidthEncoding(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.getByteList(string).getEncoding().isFixedWidth();
    }

    public static boolean isValidUtf8(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.isCodeRangeValid(string) && StringOperations.getByteList(string).getEncoding() instanceof UTF8Encoding;
    }
}

