/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectFactory;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.DeclarationContext;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.util.ArgumentDescriptorUtils;

@CoreClass(name="Proc")
public abstract class ProcNodes {
    public static Object[] packArguments(DynamicObject proc, Object ... args) {
        return RubyArguments.pack(Layouts.PROC.getMethod(proc), Layouts.PROC.getDeclarationFrame(proc), null, Layouts.PROC.getSelf(proc), Layouts.PROC.getBlock(proc), DeclarationContext.BLOCK, args);
    }

    public static Object rootCall(DynamicObject proc, Object ... args) {
        assert (RubyGuards.isRubyProc(proc));
        return Layouts.PROC.getCallTargetForType(proc).call(ProcNodes.packArguments(proc, args));
    }

    public static DynamicObject createRubyProc(DynamicObject procClass, Type type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, DynamicObject block) {
        return ProcNodes.createRubyProc(Layouts.CLASS.getInstanceFactory(procClass), type, sharedMethodInfo, callTargetForProcs, callTargetForLambdas, declarationFrame, method, self, block);
    }

    public static DynamicObject createRubyProc(DynamicObjectFactory instanceFactory, Type type, SharedMethodInfo sharedMethodInfo, CallTarget callTargetForProcs, CallTarget callTargetForLambdas, MaterializedFrame declarationFrame, InternalMethod method, Object self, DynamicObject block) {
        assert (block == null || RubyGuards.isRubyProc(block));
        CallTarget callTargetForType = type == Type.PROC ? callTargetForProcs : callTargetForLambdas;
        return Layouts.PROC.createProc(instanceFactory, type, sharedMethodInfo, callTargetForType, callTargetForLambdas, declarationFrame, method, self, block);
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object sourceLocation(DynamicObject proc) {
            SourceSection sourceSection = Layouts.PROC.getSharedMethodInfo(proc).getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            DynamicObject file = this.createString(StringOperations.encodeByteList(sourceSection.getSource().getName(), (Encoding)UTF8Encoding.INSTANCE));
            Object[] objects = new Object[]{file, sourceSection.getStartLine()};
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), objects, objects.length);
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodArrayArgumentsNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject parameters(DynamicObject proc) {
            ArgumentDescriptor[] argsDesc = Layouts.PROC.getSharedMethodInfo(proc).getArgumentDescriptors();
            return ArgumentDescriptorUtils.argumentDescriptorsToParameters(this.getContext(), argsDesc, Layouts.PROC.getType(proc) == Type.LAMBDA);
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodArrayArgumentsNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean lambda(DynamicObject proc) {
            return Layouts.PROC.getType(proc) == Type.LAMBDA;
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, rest=true, needsBlock=true)
    public static abstract class CallNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        @Specialization
        public Object call(VirtualFrame frame, DynamicObject proc, Object[] args, NotProvided block) {
            return this.yieldNode.dispatch(frame, proc, args);
        }

        @Specialization(guards={"isRubyProc(block)"})
        public Object call(VirtualFrame frame, DynamicObject proc, Object[] args, DynamicObject block) {
            return this.yieldNode.dispatchWithModifiedBlock(frame, proc, block, args);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodArrayArgumentsNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject binding(DynamicObject proc) {
            MaterializedFrame frame = Layouts.PROC.getDeclarationFrame(proc);
            return BindingNodes.createBinding(this.getContext(), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodArrayArgumentsNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int arity(DynamicObject proc) {
            return Layouts.PROC.getSharedMethodInfo(proc).getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"dup", "clone"})
    public static abstract class DupNode
    extends UnaryCoreMethodNode {
        @Node.Child
        private AllocateObjectNode allocateObjectNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject dup(DynamicObject proc) {
            DynamicObject copy = this.allocateObjectNode.allocate(Layouts.BASIC_OBJECT.getLogicalClass(proc), new Object[]{Layouts.PROC.getType(proc), Layouts.PROC.getSharedMethodInfo(proc), Layouts.PROC.getCallTargetForType(proc), Layouts.PROC.getCallTargetForLambdas(proc), Layouts.PROC.getDeclarationFrame(proc), Layouts.PROC.getMethod(proc), Layouts.PROC.getSelf(proc), Layouts.PROC.getBlock(proc)});
            return copy;
        }
    }

    @CoreMethod(names={"new"}, constructor=true, needsBlock=true, rest=true)
    public static abstract class ProcNewNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode initializeNode;
        @Node.Child
        private AllocateObjectNode allocateObjectNode;
        protected final DynamicObject PROC_CLASS = this.getContext().getCoreLibrary().getProcClass();
        protected final Shape PROC_SHAPE = this.getContext().getCoreLibrary().getProcFactory().getShape();

        public ProcNewNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
            this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        public abstract DynamicObject executeProcNew(VirtualFrame var1, DynamicObject var2, Object[] var3, Object var4);

        @Specialization
        public DynamicObject proc(VirtualFrame frame, DynamicObject procClass, Object[] args, NotProvided block) {
            Frame parentFrame = RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.READ_ONLY, true);
            DynamicObject parentBlock = RubyArguments.getBlock(parentFrame.getArguments());
            if (parentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.executeProcNew(frame, procClass, args, parentBlock);
        }

        @Specialization(guards={"procClass == PROC_CLASS", "block.getShape() == PROC_SHAPE"})
        public DynamicObject procNormalOptimized(DynamicObject procClass, Object[] args, DynamicObject block) {
            return block;
        }

        @Specialization(guards={"procClass == metaClass(block)"})
        public DynamicObject procNormal(DynamicObject procClass, Object[] args, DynamicObject block) {
            return block;
        }

        @Specialization(guards={"procClass != metaClass(block)"})
        public DynamicObject procSpecial(VirtualFrame frame, DynamicObject procClass, Object[] args, DynamicObject block) {
            DynamicObject proc = this.allocateObjectNode.allocate(procClass, new Object[]{Layouts.PROC.getType(block), Layouts.PROC.getSharedMethodInfo(block), Layouts.PROC.getCallTargetForType(block), Layouts.PROC.getCallTargetForLambdas(block), Layouts.PROC.getDeclarationFrame(block), Layouts.PROC.getMethod(block), Layouts.PROC.getSelf(block), Layouts.PROC.getBlock(block)});
            this.initializeNode.call(frame, proc, "initialize", block, args);
            return proc;
        }

        protected DynamicObject metaClass(DynamicObject object) {
            return Layouts.BASIC_OBJECT.getMetaClass(object);
        }
    }

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        public AllocateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    public static enum Type {
        PROC,
        LAMBDA;

    }
}

