/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.RespondToNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.Arity;

public class ShouldDestructureNode
extends RubyNode {
    private final Arity arity;
    @Node.Child
    private RespondToNode respondToCheck;
    private final BranchProfile checkRespondProfile = BranchProfile.create();

    public ShouldDestructureNode(RubyContext context, SourceSection sourceSection, Arity arity, RespondToNode respondToCheck) {
        super(context, sourceSection);
        this.arity = arity;
        this.respondToCheck = respondToCheck;
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) {
        if (!this.arity.hasRest() && this.arity.getRequired() == 0 && this.arity.getOptional() == 0) {
            return false;
        }
        if (!this.arity.hasRest() && this.arity.getRequired() == 1 && this.arity.getOptional() == 0) {
            return false;
        }
        if (RubyArguments.getUserArgumentsCount(frame.getArguments()) != 1) {
            return false;
        }
        if (RubyGuards.isRubyArray(RubyArguments.getUserArgument(frame.getArguments(), 0))) {
            return true;
        }
        this.checkRespondProfile.enter();
        return this.respondToCheck.executeBoolean(frame);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeBoolean(frame);
    }
}

