/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.SyntaxTag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.nodes.NodeVisitor;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public final class NodeUtil {
    static Iterator<Node> makeIterator(Node node) {
        return node.getNodeClass().makeIterator(node);
    }

    public static Iterator<Node> makeRecursiveIterator(Node node) {
        return new RecursiveNodeIterator(node);
    }

    public static <T extends Node> T cloneNode(T orig) {
        return (T)orig.deepCopy();
    }

    static Node deepCopyImpl(Node orig) {
        Node clone = orig.copy();
        NodeClass nodeClass = clone.getNodeClass();
        nodeClass.getParentField().putObject(clone, null);
        NodeFieldAccessor[] nodeFieldAccessorArray = nodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeFieldAccessor childField = nodeFieldAccessorArray[n2];
            Node child = (Node)childField.getObject(orig);
            if (child != null) {
                Node clonedChild = child.deepCopy();
                nodeClass.getParentField().putObject(clonedChild, clone);
                childField.putObject(clone, clonedChild);
            }
            ++n2;
        }
        nodeFieldAccessorArray = nodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            NodeFieldAccessor childrenField = nodeFieldAccessorArray[n2];
            Object[] children = (Object[])childrenField.getObject(orig);
            if (children != null) {
                Object[] clonedChildren = (Object[])Array.newInstance(children.getClass().getComponentType(), children.length);
                int i = 0;
                while (i < children.length) {
                    if (children[i] != null) {
                        Node clonedChild = ((Node)children[i]).deepCopy();
                        clonedChildren[i] = clonedChild;
                        nodeClass.getParentField().putObject(clonedChild, clone);
                    }
                    ++i;
                }
                childrenField.putObject(clone, clonedChildren);
            }
            ++n2;
        }
        nodeFieldAccessorArray = nodeClass.getCloneableFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            NodeFieldAccessor cloneableField = nodeFieldAccessorArray[n2];
            Object cloneable = cloneableField.getObject(clone);
            if (cloneable != null && cloneable == cloneableField.getObject(orig)) {
                cloneableField.putObject(clone, ((NodeCloneable)cloneable).clone());
            }
            ++n2;
        }
        return clone;
    }

    public static List<Node> findNodeChildren(Node node) {
        NodeFieldAccessor nodeField;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeClass nodeClass = node.getNodeClass();
        NodeFieldAccessor[] nodeFieldAccessorArray = nodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            nodeField = nodeFieldAccessorArray[n2];
            Object child = nodeField.getObject(node);
            if (child != null) {
                nodes.add((Node)child);
            }
            ++n2;
        }
        nodeFieldAccessorArray = nodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            nodeField = nodeFieldAccessorArray[n2];
            Object[] children = (Object[])nodeField.getObject(node);
            if (children != null) {
                Object[] objectArray = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object child = objectArray[n4];
                    if (child != null) {
                        nodes.add((Node)child);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return nodes;
    }

    public static <T extends Node> T nonAtomicReplace(Node oldNode, T newNode, CharSequence reason) {
        oldNode.replaceHelper(newNode, reason);
        return newNode;
    }

    public static boolean replaceChild(Node parent, Node oldChild, Node newChild) {
        NodeFieldAccessor nodeField;
        NodeClass nodeClass = parent.getNodeClass();
        NodeFieldAccessor[] nodeFieldAccessorArray = nodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            nodeField = nodeFieldAccessorArray[n2];
            if (nodeField.getObject(parent) == oldChild) {
                assert (NodeUtil.assertAssignable(nodeField, newChild));
                nodeField.putObject(parent, newChild);
                return true;
            }
            ++n2;
        }
        nodeFieldAccessorArray = nodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            nodeField = nodeFieldAccessorArray[n2];
            Object arrayObject = nodeField.getObject(parent);
            if (arrayObject != null) {
                Object[] array = (Object[])arrayObject;
                int i = 0;
                while (i < array.length) {
                    if (array[i] == oldChild) {
                        assert (NodeUtil.assertAssignable(nodeField, newChild));
                        array[i] = newChild;
                        return true;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean assertAssignable(NodeFieldAccessor field, Object newValue) {
        if (newValue == null) {
            return true;
        }
        if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
            if (field.getType().isAssignableFrom(newValue.getClass())) {
                return true;
            }
            assert (false) : "Child class " + newValue.getClass().getName() + " is not assignable to field \"" + field.getName() + "\" of type " + field.getType().getName();
            return false;
        }
        if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
            if (field.getType().getComponentType().isAssignableFrom(newValue.getClass())) {
                return true;
            }
            assert (false) : "Child class " + newValue.getClass().getName() + " is not assignable to field \"" + field.getName() + "\" of type " + field.getType().getName();
            return false;
        }
        throw new IllegalArgumentException();
    }

    public static NodeFieldAccessor findChildField(Node parent, Node child) {
        NodeFieldAccessor field;
        assert (child != null);
        NodeClass parentNodeClass = parent.getNodeClass();
        NodeFieldAccessor[] nodeFieldAccessorArray = parentNodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            if (field.getObject(parent) == child) {
                return field;
            }
            ++n2;
        }
        nodeFieldAccessorArray = parentNodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            Object arrayObject = field.getObject(parent);
            if (arrayObject != null) {
                Object[] array = (Object[])arrayObject;
                int i = 0;
                while (i < array.length) {
                    if (array[i] == child) {
                        return field;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean isReplacementSafe(Node parent, Node oldChild, Node newChild) {
        NodeFieldAccessor field;
        assert (newChild != null);
        if (parent != null && (field = NodeUtil.findChildField(parent, oldChild)) != null) {
            switch (field.getKind()) {
                case CHILD: {
                    return field.getType().isAssignableFrom(newChild.getClass());
                }
                case CHILDREN: {
                    return field.getType().getComponentType().isAssignableFrom(newChild.getClass());
                }
            }
            throw new IllegalStateException();
        }
        return false;
    }

    public static boolean forEachChild(Node parent, NodeVisitor visitor) {
        NodeFieldAccessor field;
        Objects.requireNonNull(visitor);
        NodeClass parentNodeClass = parent.getNodeClass();
        NodeFieldAccessor[] nodeFieldAccessorArray = parentNodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            Object child = field.getObject(parent);
            if (child != null && !visitor.visit((Node)child)) {
                return false;
            }
            ++n2;
        }
        nodeFieldAccessorArray = parentNodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            Object arrayObject = field.getObject(parent);
            if (arrayObject != null) {
                Object[] array = (Object[])arrayObject;
                int i = 0;
                while (i < array.length) {
                    Object child = array[i];
                    if (child != null && !visitor.visit((Node)child)) {
                        return false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return true;
    }

    static boolean forEachChildRecursive(Node parent, NodeVisitor visitor) {
        NodeFieldAccessor field;
        NodeClass parentNodeClass = parent.getNodeClass();
        NodeFieldAccessor[] nodeFieldAccessorArray = parentNodeClass.getChildFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            if (!NodeUtil.visitChild((Node)field.getObject(parent), visitor)) {
                return false;
            }
            ++n2;
        }
        nodeFieldAccessorArray = parentNodeClass.getChildrenFields();
        n = nodeFieldAccessorArray.length;
        n2 = 0;
        while (n2 < n) {
            field = nodeFieldAccessorArray[n2];
            Object arrayObject = field.getObject(parent);
            if (arrayObject != null) {
                Object[] array = (Object[])arrayObject;
                int i = 0;
                while (i < array.length) {
                    if (!NodeUtil.visitChild((Node)array[i], visitor)) {
                        return false;
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return true;
    }

    private static boolean visitChild(Node child, NodeVisitor visitor) {
        if (child == null) {
            return true;
        }
        if (!visitor.visit(child)) {
            return false;
        }
        return NodeUtil.forEachChildRecursive(child, visitor);
    }

    static Field[] getAllFields(Class<? extends Object> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        if (clazz.getSuperclass() != null) {
            return NodeUtil.concat(NodeUtil.getAllFields(clazz.getSuperclass()), declaredFields);
        }
        return declaredFields;
    }

    public static <T> T[] concat(T[] first, T[] second) {
        T[] result = Arrays.copyOf(first, first.length + second.length);
        System.arraycopy(second, 0, result, first.length, second.length);
        return result;
    }

    public static Node getNthParent(Node node, int n) {
        Node parent = node;
        int i = 0;
        while (i < n) {
            if ((parent = parent.getParent()) == null) {
                return null;
            }
            ++i;
        }
        return parent;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz.getAnnotation(annotationClass) != null) {
            return clazz.getAnnotation(annotationClass);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> intf = classArray[n2];
            if (intf.getAnnotation(annotationClass) != null) {
                return intf.getAnnotation(annotationClass);
            }
            ++n2;
        }
        if (clazz.getSuperclass() != null) {
            return NodeUtil.findAnnotation(clazz.getSuperclass(), annotationClass);
        }
        return null;
    }

    public static <T> T findParent(Node start, Class<T> clazz) {
        Node parent = start.getParent();
        if (parent == null) {
            return null;
        }
        if (clazz.isInstance(parent)) {
            return clazz.cast(parent);
        }
        return NodeUtil.findParent(parent, clazz);
    }

    public static <T> List<T> findAllParents(Node start, Class<T> clazz) {
        ArrayList<T> parents = new ArrayList<T>();
        T parent = NodeUtil.findParent(start, clazz);
        while (parent != null) {
            parents.add(parent);
            parent = NodeUtil.findParent((Node)parent, clazz);
        }
        return parents;
    }

    public static List<Node> collectNodes(Node parent, Node child) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node current = child;
        while (current != null) {
            nodes.add(current);
            if (current == parent) {
                return nodes;
            }
            current = current.getParent();
        }
        throw new IllegalArgumentException("Node " + parent + " is not a parent of " + child + ".");
    }

    public static <T> T findFirstNodeInstance(Node root, Class<T> clazz) {
        for (Node childNode : NodeUtil.findNodeChildren(root)) {
            if (clazz.isInstance(childNode)) {
                return clazz.cast(childNode);
            }
            T node = NodeUtil.findFirstNodeInstance(childNode, clazz);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static <T> List<T> findAllNodeInstances(Node root, final Class<T> clazz) {
        final ArrayList nodeList = new ArrayList();
        root.accept(new NodeVisitor(){

            @Override
            public boolean visit(Node node) {
                if (clazz.isInstance(node)) {
                    nodeList.add(clazz.cast(node));
                }
                return true;
            }
        });
        return nodeList;
    }

    public static <T> List<T> findNodeInstancesShallow(Node root, final Class<T> clazz) {
        final ArrayList nodeList = new ArrayList();
        root.accept(new NodeVisitor(){

            @Override
            public boolean visit(Node node) {
                if (clazz.isInstance(node)) {
                    nodeList.add(clazz.cast(node));
                    return false;
                }
                return true;
            }
        });
        return nodeList;
    }

    public static int countNodes(Node root) {
        return NodeUtil.countNodes(root, NodeCountFilter.NO_FILTER);
    }

    public static int countNodes(Node root, NodeCountFilter filter) {
        NodeCounter counter = new NodeCounter(filter);
        root.accept(counter);
        return counter.count;
    }

    public static String printCompactTreeToString(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printCompactTree(new PrintWriter(out), null, node, 1);
        return out.toString();
    }

    public static void printCompactTree(OutputStream out, Node node) {
        NodeUtil.printCompactTree(new PrintWriter(out), null, node, 1);
    }

    private static void printCompactTree(PrintWriter p, Node parent, Node node, int level) {
        if (node == null) {
            return;
        }
        int i = 0;
        while (i < level) {
            p.print("  ");
            ++i;
        }
        if (parent == null) {
            p.println(NodeUtil.nodeName(node));
        } else {
            p.print(NodeUtil.getNodeFieldName(parent, node, "unknownField"));
            p.print(" = ");
            p.println(NodeUtil.nodeName(node));
        }
        for (Node child : node.getChildren()) {
            NodeUtil.printCompactTree(p, node, child, level + 1);
        }
        p.flush();
    }

    public static String printSourceAttributionTree(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printSourceAttributionTree(new PrintWriter(out), null, node, 1);
        return out.toString();
    }

    public static void printSourceAttributionTree(OutputStream out, Node node) {
        NodeUtil.printSourceAttributionTree(new PrintWriter(out), null, node, 1);
    }

    private static void printSourceAttributionTree(PrintWriter p, Node parent, Node node, int level) {
        SourceSection sourceSection;
        if (node == null) {
            return;
        }
        if (parent == null && (sourceSection = node.getSourceSection()) != null) {
            String txt = sourceSection.getSource().getCode();
            p.println("Full source len=(" + txt.length() + ")  ___" + txt + "___");
            p.println("AST source attribution:");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < level) {
            sb.append("| ");
            ++i;
        }
        if (parent != null) {
            sb.append(NodeUtil.getNodeFieldName(parent, node, ""));
        }
        sb.append("  (" + node.getClass().getSimpleName() + ")  ");
        sb.append(NodeUtil.printSyntaxTags(node));
        sb.append(NodeUtil.displaySourceAttribution(node));
        p.println(sb.toString());
        for (Node child : node.getChildren()) {
            NodeUtil.printSourceAttributionTree(p, node, child, level + 1);
        }
        p.flush();
    }

    private static String getNodeFieldName(Node parent, Node node, String defaultName) {
        NodeFieldAccessor[] fields;
        NodeFieldAccessor[] nodeFieldAccessorArray = fields = parent.getNodeClass().getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            NodeFieldAccessor field = nodeFieldAccessorArray[n2];
            Object value = field.loadValue(parent);
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD && value == node) {
                return field.getName();
            }
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                int index = 0;
                Object[] objectArray = (Object[])value;
                int n3 = objectArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object arrayNode = objectArray[n4];
                    if (arrayNode == node) {
                        return String.valueOf(field.getName()) + "[" + index + "]";
                    }
                    ++index;
                    ++n4;
                }
            }
            ++n2;
        }
        return defaultName;
    }

    public static String printSyntaxTags(Object node) {
        if (node instanceof ProbeNode.WrapperNode) {
            Probe probe = ((ProbeNode.WrapperNode)node).getProbe();
            Collection<SyntaxTag> syntaxTags = probe.getSyntaxTags();
            StringBuilder sb = new StringBuilder();
            String prefix = "";
            sb.append("[");
            for (SyntaxTag tag : syntaxTags) {
                sb.append(prefix);
                prefix = ",";
                sb.append(tag.toString());
            }
            sb.append("]");
            return sb.toString();
        }
        return "";
    }

    public static void printTree(OutputStream out, Node node) {
        NodeUtil.printTree(new PrintWriter(out), node);
    }

    public static String printTreeToString(Node node) {
        StringWriter out = new StringWriter();
        NodeUtil.printTree(new PrintWriter(out), node);
        return out.toString();
    }

    public static void printTree(PrintWriter p, Node node) {
        NodeUtil.printTree(p, node, 1);
        p.println();
        p.flush();
    }

    private static void printTree(PrintWriter p, Node node, int level) {
        if (node == null) {
            p.print("null");
            return;
        }
        p.print(NodeUtil.nodeName(node));
        ArrayList<NodeFieldAccessor> childFields = new ArrayList<NodeFieldAccessor>();
        String sep = "";
        p.print("(");
        NodeFieldAccessor[] nodeFieldAccessorArray = NodeClass.get(node).getFields();
        int n = nodeFieldAccessorArray.length;
        int n2 = 0;
        while (n2 < n) {
            NodeFieldAccessor field = nodeFieldAccessorArray[n2];
            if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD || field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                childFields.add(field);
            } else if (field.getKind() == NodeFieldAccessor.NodeFieldKind.DATA) {
                p.print(sep);
                sep = ", ";
                p.print(field.getName());
                p.print(" = ");
                p.print(field.loadValue(node));
            }
            ++n2;
        }
        p.print(")");
        if (childFields.size() != 0) {
            p.print(" {");
            for (NodeFieldAccessor field : childFields) {
                NodeUtil.printNewLine(p, level);
                p.print(field.getName());
                Object value = field.loadValue(node);
                if (value == null) {
                    p.print(" = null ");
                    continue;
                }
                if (field.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD) {
                    p.print(" = ");
                    NodeUtil.printTree(p, (Node)value, level + 1);
                    continue;
                }
                if (field.getKind() != NodeFieldAccessor.NodeFieldKind.CHILDREN) continue;
                NodeUtil.printChildren(p, level, value);
            }
            NodeUtil.printNewLine(p, level - 1);
            p.print("}");
        }
    }

    private static void printChildren(PrintWriter p, int level, Object value) {
        Object[] children = (Object[])value;
        p.print(" = [");
        String sep = "";
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            p.print(sep);
            sep = ", ";
            NodeUtil.printTree(p, (Node)child, level + 1);
            ++n2;
        }
        p.print("]");
    }

    private static void printNewLine(PrintWriter p, int level) {
        p.println();
        int i = 0;
        while (i < level) {
            p.print("    ");
            ++i;
        }
    }

    private static String nodeName(Node node) {
        return node.getClass().getSimpleName();
    }

    private static String displaySourceAttribution(Node node) {
        SourceSection section = node.getSourceSection();
        if (section instanceof NullSourceSection) {
            return "source: " + section.getShortDescription();
        }
        if (section != null) {
            String srcText = section.getCode();
            StringBuilder sb = new StringBuilder();
            sb.append("source:");
            sb.append(" (" + section.getCharIndex() + "," + (section.getCharEndIndex() - 1) + ")");
            sb.append(" line=" + section.getLineLocation().getLineNumber());
            sb.append(" len=" + srcText.length());
            sb.append(" text=\"" + srcText + "\"");
            return sb.toString();
        }
        return "";
    }

    public static boolean verify(Node root) {
        Iterable<Node> children = root.getChildren();
        for (Node child : children) {
            if (child == null) continue;
            if (child.getParent() != root) {
                throw new AssertionError((Object)(String.valueOf(NodeUtil.toStringWithClass(child)) + ": actual parent=" + NodeUtil.toStringWithClass(child.getParent()) + " expected parent=" + NodeUtil.toStringWithClass(root)));
            }
            NodeUtil.verify(child);
        }
        return true;
    }

    private static String toStringWithClass(Object obj) {
        return obj == null ? "null" : obj + "(" + obj.getClass().getName() + ")";
    }

    static void traceRewrite(Node oldNode, Node newNode, CharSequence reason) {
        if (TruffleOptions.TraceRewritesFilterFromCost != null && NodeUtil.filterByKind(oldNode, TruffleOptions.TraceRewritesFilterFromCost)) {
            return;
        }
        if (TruffleOptions.TraceRewritesFilterToCost != null && NodeUtil.filterByKind(newNode, TruffleOptions.TraceRewritesFilterToCost)) {
            return;
        }
        String filter = TruffleOptions.TraceRewritesFilterClass;
        Class<?> from = oldNode.getClass();
        Class<?> to = newNode.getClass();
        if (filter != null && (NodeUtil.filterByContainsClassName(from, filter) || NodeUtil.filterByContainsClassName(to, filter))) {
            return;
        }
        SourceSection reportedSourceSection = oldNode.getEncapsulatingSourceSection();
        PrintStream out = System.out;
        out.printf("[truffle]   rewrite %-50s |From %-40s |To %-40s |Reason %s%s%n", oldNode.toString(), NodeUtil.formatNodeInfo(oldNode), NodeUtil.formatNodeInfo(newNode), reason != null && reason.length() > 0 ? reason : "unknown", reportedSourceSection != null ? " at " + reportedSourceSection.getShortDescription() : "");
    }

    private static String formatNodeInfo(Node node) {
        String cost = "?";
        switch (node.getCost()) {
            case NONE: {
                cost = "G";
                break;
            }
            case MONOMORPHIC: {
                cost = "M";
                break;
            }
            case POLYMORPHIC: {
                cost = "P";
                break;
            }
            case MEGAMORPHIC: {
                cost = "G";
                break;
            }
            default: {
                cost = "?";
            }
        }
        return String.valueOf(cost) + " " + node.getClass().getSimpleName();
    }

    private static boolean filterByKind(Node node, NodeCost cost) {
        return node.getCost() == cost;
    }

    private static boolean filterByContainsClassName(Class<? extends Node> from, String filter) {
        Class<? extends Node> currentFrom = from;
        while (currentFrom != null) {
            if (currentFrom.getName().contains(filter)) {
                return false;
            }
            currentFrom = currentFrom.getSuperclass();
        }
        return true;
    }

    public static interface FieldOffsetProvider {
        public long objectFieldOffset(Field var1);

        public int getTypeSize(Class<?> var1);
    }

    public static interface NodeCountFilter {
        public static final NodeCountFilter NO_FILTER = new NodeCountFilter(){

            @Override
            public boolean isCounted(Node node) {
                return true;
            }
        };

        public boolean isCounted(Node var1);
    }

    private static final class NodeCounter
    implements NodeVisitor {
        public int count;
        private final NodeCountFilter filter;

        public NodeCounter(NodeCountFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean visit(Node node) {
            if (this.filter.isCounted(node)) {
                ++this.count;
            }
            return true;
        }
    }

    private static final class RecursiveNodeIterator
    implements Iterator<Node> {
        private final List<Iterator<Node>> iteratorStack = new ArrayList<Iterator<Node>>();

        public RecursiveNodeIterator(final Node node) {
            this.iteratorStack.add(new Iterator<Node>(){
                private boolean visited;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Node next() {
                    if (this.visited) {
                        throw new NoSuchElementException();
                    }
                    this.visited = true;
                    return node;
                }

                @Override
                public boolean hasNext() {
                    return !this.visited;
                }
            });
        }

        @Override
        public boolean hasNext() {
            return this.peekIterator() != null;
        }

        @Override
        public Node next() {
            Iterator<Node> childIterator;
            Iterator<Node> iterator = this.peekIterator();
            if (iterator == null) {
                throw new NoSuchElementException();
            }
            Node node = iterator.next();
            if (node != null && (childIterator = NodeUtil.makeIterator(node)).hasNext()) {
                this.iteratorStack.add(childIterator);
            }
            return node;
        }

        private Iterator<Node> peekIterator() {
            int tos = this.iteratorStack.size() - 1;
            while (tos >= 0) {
                Iterator<Node> iterable = this.iteratorStack.get(tos);
                if (iterable.hasNext()) {
                    return iterable;
                }
                this.iteratorStack.remove(tos--);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

