/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.invokers;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import org.cliffc.high_scale_lib.NonBlockingHashMapLong;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.RaiseException;
import org.jruby.java.dispatch.CallableSelector;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.ConcreteJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.ParameterTypes;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.collections.IntHashMap;

public abstract class RubyToJavaInvoker<T extends JavaCallable>
extends org.jruby.internal.runtime.methods.JavaMethod {
    static final NonBlockingHashMapLong NULL_CACHE = new NonBlockingHashMapLong();
    protected final T javaCallable;
    protected final T[][] javaCallables;
    protected final T[] javaVarargsCallables;
    final NonBlockingHashMapLong<T> cache;
    private final Ruby runtime;

    RubyToJavaInvoker(RubyModule host, Member member) {
        super(host, Visibility.PUBLIC);
        this.runtime = host.getRuntime();
        JavaCallable[] varargsCallables = null;
        int minVarArgsArity = -1;
        T callable = this.createCallable(this.runtime, member);
        int minArity = ((JavaCallable)callable).getArity();
        if (((JavaCallable)callable).isVarArgs()) {
            varargsCallables = this.createCallableArray((JavaCallable)callable);
            minVarArgsArity = this.getMemberArity(member) - 1;
        }
        this.cache = NULL_CACHE;
        this.javaCallable = callable;
        this.javaCallables = null;
        this.javaVarargsCallables = varargsCallables;
        this.setArity(minArity, minArity, minVarArgsArity);
        this.setupNativeCall();
    }

    RubyToJavaInvoker(RubyModule host, Member[] members2) {
        super(host, Visibility.PUBLIC);
        JavaCallable[][] callables;
        int maxArity;
        int minArity;
        JavaCallable callable;
        this.runtime = host.getRuntime();
        JavaCallable[] varargsCallables = null;
        int minVarArgsArity = -1;
        int length2 = members2.length;
        if (length2 == 1) {
            callable = (JavaCallable)this.createCallable(this.runtime, members2[0]);
            maxArity = minArity = callable.getArity();
            if (callable.isVarArgs()) {
                varargsCallables = this.createCallableArray(callable);
                minVarArgsArity = this.getMemberArity(members2[0]) - 1;
            }
            callables = null;
            this.cache = NULL_CACHE;
        } else {
            callable = null;
            maxArity = -1;
            minArity = Integer.MAX_VALUE;
            IntHashMap<ArrayList<T>> arityMap = new IntHashMap<ArrayList<T>>(length2, 1.0f);
            ArrayList<T> varArgs = null;
            for (int i2 = 0; i2 < length2; ++i2) {
                Member method = members2[i2];
                int currentArity = this.getMemberArity(method);
                maxArity = Math.max(currentArity, maxArity);
                minArity = Math.min(currentArity, minArity);
                T javaMethod = this.createCallable(this.runtime, method);
                ArrayList<T> methodsForArity = (ArrayList<T>)arityMap.get(currentArity);
                if (methodsForArity == null) {
                    methodsForArity = new ArrayList<T>(length2);
                    arityMap.put(currentArity, methodsForArity);
                }
                methodsForArity.add(javaMethod);
                if (!((JavaCallable)javaMethod).isVarArgs()) continue;
                int usableArity = currentArity - 1;
                methodsForArity = (ArrayList<T>)arityMap.get(usableArity);
                if (methodsForArity == null) {
                    methodsForArity = new ArrayList<T>(length2);
                    arityMap.put(usableArity, methodsForArity);
                }
                methodsForArity.add(javaMethod);
                if (varArgs == null) {
                    varArgs = new ArrayList<T>(length2);
                }
                varArgs.add(javaMethod);
                if (minVarArgsArity == -1) {
                    minVarArgsArity = Integer.MAX_VALUE;
                }
                minVarArgsArity = Math.min(usableArity, minVarArgsArity);
            }
            callables = this.createCallableArrayArray(maxArity + 1);
            for (IntHashMap.Entry entry : arityMap.entrySet()) {
                ArrayList methodsForArity = (ArrayList)entry.getValue();
                JavaCallable[] methodsArray = methodsForArity.toArray(this.createCallableArray(methodsForArity.size()));
                callables[entry.getKey()] = methodsArray;
            }
            if (varArgs != null) {
                varargsCallables = varArgs.toArray(this.createCallableArray(varArgs.size()));
            }
            this.cache = new NonBlockingHashMapLong(8);
        }
        this.javaCallable = callable;
        this.javaCallables = callables;
        this.javaVarargsCallables = varargsCallables;
        this.setArity(minArity, maxArity, minVarArgsArity);
        this.setupNativeCall();
    }

    private void setArity(int minArity, int maxArity, int minVarArgsArity) {
        if (minVarArgsArity == -1) {
            if (minArity == maxArity) {
                this.setArity(Arity.fixed(minArity));
            } else {
                this.setArity(Arity.required(minArity));
            }
        } else {
            this.setArity(Arity.required(minVarArgsArity < minArity ? minVarArgsArity : minArity));
        }
    }

    final void setupNativeCall() {
        if (this.javaCallable != null) {
            if (this.javaCallable instanceof JavaMethod) {
                this.setNativeCallIfPublic(((JavaMethod)this.javaCallable).getValue());
            }
        } else {
            Method method;
            T[] callablesForArity;
            for (int i2 = 0; !(i2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[i2]) != null && callablesForArity.length == 1 && callablesForArity[0] instanceof JavaMethod && this.setNativeCallIfPublic(method = ((JavaMethod)callablesForArity[0]).getValue())); ++i2) {
            }
        }
    }

    private boolean setNativeCallIfPublic(Method method) {
        int mod = method.getModifiers();
        if (Modifier.isPublic(mod) && Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.setNativeCall(method.getDeclaringClass(), method.getName(), method.getReturnType(), method.getParameterTypes(), Modifier.isStatic(mod), true);
            return true;
        }
        return false;
    }

    public T getSignature(int signatureCode) {
        return (T)((JavaCallable)this.cache.get(signatureCode));
    }

    public void putSignature(int signatureCode, T callable) {
        this.cache.put(signatureCode, callable);
    }

    protected abstract T createCallable(Ruby var1, Member var2);

    protected abstract T[] createCallableArray(T var1);

    protected abstract T[] createCallableArray(int var1);

    protected abstract T[][] createCallableArrayArray(int var1);

    protected abstract Class[] getMemberParameterTypes(Member var1);

    @Deprecated
    protected abstract boolean isMemberVarArgs(Member var1);

    final int getMemberArity(Member member) {
        return this.getMemberParameterTypes(member).length;
    }

    public static Object[] convertArguments(ParameterTypes method, IRubyObject[] args2) {
        Object[] javaArgs;
        Class<?>[] paramTypes = method.getParameterTypes();
        int len = args2.length;
        if (method.isVarArgs()) {
            int last2 = paramTypes.length - 1;
            javaArgs = new Object[last2 + 1];
            for (int i2 = 0; i2 < last2; ++i2) {
                javaArgs[i2] = args2[i2].toJava(paramTypes[i2]);
            }
            javaArgs[last2] = RubyToJavaInvoker.convertVarArgumentsOnly(paramTypes[last2], last2, args2);
        } else {
            javaArgs = new Object[len];
            for (int i3 = 0; i3 < len; ++i3) {
                javaArgs[i3] = args2[i3].toJava(paramTypes[i3]);
            }
        }
        return javaArgs;
    }

    private static Object convertVarArgumentsOnly(Class<?> varArrayType, int varStart, IRubyObject[] args2) {
        int varCount = args2.length - varStart;
        if (args2.length == 0 || varCount <= 0) {
            return Array.newInstance(varArrayType.getComponentType(), 0);
        }
        if (varCount == 1 && args2[varStart] instanceof ArrayJavaProxy) {
            return args2[varStart].toJava(varArrayType);
        }
        Class<?> compType = varArrayType.getComponentType();
        Object varArgs = Array.newInstance(compType, varCount);
        for (int i2 = 0; i2 < varCount; ++i2) {
            Array.set(varArgs, i2, args2[varStart + i2].toJava(compType));
        }
        return varArgs;
    }

    static JavaProxy castJavaProxy(IRubyObject self2) {
        assert (self2 instanceof JavaProxy) : "Java methods can only be invoked on Java objects";
        return (JavaProxy)self2;
    }

    static <T extends AccessibleObject> T setAccessible(T accessible) {
        if (!Ruby.isSecurityRestricted()) {
            try {
                accessible.setAccessible(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return accessible;
    }

    static <T extends AccessibleObject> T[] setAccessible(T[] accessibles) {
        if (!Ruby.isSecurityRestricted()) {
            try {
                AccessibleObject.setAccessible(accessibles, true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return accessibles;
    }

    protected T findCallable(IRubyObject self2, String name2, IRubyObject[] args2, int arity2) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (arity2 >= this.javaCallables.length || (callablesForArity = this.javaCallables[arity2]) == null) {
                callable = this.matchVarArgsCallableArityN(self2, args2);
                if (callable == null) {
                    throw this.runtime.newArgumentError(args2.length, this.javaCallables.length - 1);
                }
                return callable;
            }
            callable = CallableSelector.matchingCallableArityN((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject[])args2);
            if (callable == null && (callable = this.matchVarArgsCallableArityN(self2, args2)) == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, args2);
            }
        } else if (!((JavaCallable)callable).isVarArgs()) {
            this.checkCallableArity(callable, args2.length);
        }
        return callable;
    }

    private T matchVarArgsCallableArityN(IRubyObject self2, IRubyObject[] args2) {
        T[] varArgsCallables = this.javaVarargsCallables;
        if (varArgsCallables != null) {
            JavaCallable callable = CallableSelector.matchingCallableArityN((Ruby)this.runtime, (RubyToJavaInvoker)this, varArgsCallables, (IRubyObject[])args2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])varArgsCallables, args2);
            }
            return (T)callable;
        }
        return null;
    }

    protected final T findCallableArityZero(IRubyObject self2, String name2) {
        T callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length == 0 || (callablesForArity = this.javaCallables[0]) == null) {
                throw this.newErrorDueNoMatchingCallable(self2, name2);
            }
            callable = callablesForArity[0];
        } else {
            this.checkCallableArity(callable, 0);
        }
        return callable;
    }

    protected final T findCallableArityOne(IRubyObject self2, String name2, IRubyObject arg0) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 1 || (callablesForArity = this.javaCallables[1]) == null) {
                throw this.runtime.newArgumentError(1, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityOne((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0});
            }
        } else {
            this.checkCallableArity(callable, 1);
        }
        return callable;
    }

    protected final T findCallableArityTwo(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 2 || (callablesForArity = this.javaCallables[2]) == null) {
                throw this.runtime.newArgumentError(2, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityTwo((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1});
            }
        } else {
            this.checkCallableArity(callable, 2);
        }
        return callable;
    }

    protected final T findCallableArityThree(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 3 || (callablesForArity = this.javaCallables[3]) == null) {
                throw this.runtime.newArgumentError(3, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityThree((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1, arg2});
            }
        } else {
            this.checkCallableArity(callable, 3);
        }
        return callable;
    }

    protected final T findCallableArityFour(IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, IRubyObject arg3) {
        Object callable = this.javaCallable;
        if (callable == null) {
            T[] callablesForArity;
            if (this.javaCallables.length <= 4 || (callablesForArity = this.javaCallables[4]) == null) {
                throw this.runtime.newArgumentError(4, this.javaCallables.length - 1);
            }
            callable = CallableSelector.matchingCallableArityFour((Ruby)this.runtime, (RubyToJavaInvoker)this, callablesForArity, (IRubyObject)arg0, (IRubyObject)arg1, (IRubyObject)arg2, (IRubyObject)arg3);
            if (callable == null) {
                throw this.newErrorDueArgumentTypeMismatch(self2, (JavaCallable[])callablesForArity, new IRubyObject[]{arg0, arg1, arg2, arg3});
            }
        } else {
            this.checkCallableArity(callable, 4);
        }
        return callable;
    }

    private void checkCallableArity(T callable, int expected) {
        int arity2 = ((JavaCallable)callable).getArity();
        if (arity2 != expected) {
            throw this.runtime.newArgumentError(expected, arity2);
        }
    }

    private T someCallable() {
        if (this.javaCallable == null) {
            for (int i2 = 0; i2 < this.javaCallables.length; ++i2) {
                T[] callables = this.javaCallables[i2];
                if (callables == null || callables.length <= 0) continue;
                for (int j = 0; j < callables.length; ++j) {
                    if (callables[j] == null) continue;
                    return callables[j];
                }
            }
            return null;
        }
        return this.javaCallable;
    }

    private boolean isConstructor() {
        return this.someCallable() instanceof JavaConstructor;
    }

    RaiseException newErrorDueArgumentTypeMismatch(IRubyObject receiver2, T[] methods2, IRubyObject ... args2) {
        Class[] argTypes = new Class[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            argTypes[i2] = RubyToJavaInvoker.getClass(args2[i2]);
        }
        StringBuilder error2 = new StringBuilder(64);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            JavaMethod method = (JavaMethod)methods2[0];
            error2.append("method '").append(method.getValue().getName()).append("'");
        }
        error2.append(" for arguments ");
        CodegenUtils.prettyParams(error2, argTypes);
        error2.append(" on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        if (methods2.length > 1) {
            error2.append("\n  available overloads:");
            for (T method : methods2) {
                Class[] paramTypes = method.getParameterTypes();
                error2.append("\n    ");
                CodegenUtils.prettyParams(error2, paramTypes);
            }
        }
        return this.runtime.newNameError(error2.toString(), null);
    }

    private RaiseException newErrorDueNoMatchingCallable(IRubyObject receiver2, String name2) {
        StringBuilder error2 = new StringBuilder(48);
        error2.append("no ");
        if (this.isConstructor()) {
            error2.append("constructor");
        } else {
            error2.append("method '").append(name2).append("'");
        }
        error2.append(" (for zero arguments) on ").append(RubyToJavaInvoker.formatReceiver(receiver2));
        return this.runtime.newArgumentError(error2.toString());
    }

    private static Class<?> getClass(IRubyObject object) {
        if (object == null) {
            return Void.TYPE;
        }
        if (object instanceof ConcreteJavaProxy) {
            return ((ConcreteJavaProxy)object).getJavaClass();
        }
        return object.getClass();
    }

    private static String formatReceiver(IRubyObject object) {
        if (object instanceof RubyModule) {
            return ((RubyModule)object).getName();
        }
        return object.getMetaClass().getRealClass().getName();
    }
}

