/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;

public class NativeFileChooser
extends AbstractFileChooser {
    private final FileDialog fileDialog = new FileDialog((Frame)Main.parent);
    private FileFilter fileFilter;
    private int selectionMode;

    public NativeFileChooser(File file) {
        if (file != null) {
            this.fileDialog.setDirectory(file.getAbsolutePath());
            if (file.isFile()) {
                this.fileDialog.setFile(file.toString());
            }
        }
    }

    @Override
    public void addChoosableFileFilter(FileFilter fileFilter) {
    }

    @Override
    public FileFilter[] getChoosableFileFilters() {
        return new FileFilter[0];
    }

    @Override
    public File getCurrentDirectory() {
        return new File(this.fileDialog.getDirectory());
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileFilter;
    }

    @Override
    public File getSelectedFile() {
        return new File(this.fileDialog.getDirectory() + this.fileDialog.getFile());
    }

    @Override
    public File[] getSelectedFiles() {
        return this.fileDialog.getFiles();
    }

    @Override
    public boolean isMultiSelectionEnabled() {
        return this.fileDialog.isMultipleMode();
    }

    @Override
    public void setAcceptAllFileFilterUsed(boolean bl) {
    }

    @Override
    public void setCurrentDirectory(File file) {
        this.fileDialog.setDirectory(file.toString());
    }

    @Override
    public void setDialogTitle(String string) {
        this.fileDialog.setTitle(string);
    }

    @Override
    public void setFileFilter(final FileFilter fileFilter) {
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return fileFilter.accept(new File(file.getAbsolutePath() + string));
            }
        };
        this.fileDialog.setFilenameFilter(filenameFilter);
        this.fileFilter = fileFilter;
    }

    @Override
    public void setFileSelectionMode(int n) {
        this.selectionMode = n;
    }

    @Override
    public void setMultiSelectionEnabled(boolean bl) {
        this.fileDialog.setMultipleMode(bl);
    }

    @Override
    public void setSelectedFile(File file) {
        this.fileDialog.setDirectory(file.getAbsolutePath());
        this.fileDialog.setFile(file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showOpenDialog(Component component) {
        boolean bl;
        boolean bl2 = bl = Main.isPlatformOsx() && this.selectionMode == 1;
        if (bl) {
            System.setProperty("apple.awt.fileDialogForDirectories", "true");
        }
        try {
            this.fileDialog.setLocale(locale);
            this.fileDialog.setMode(0);
            this.fileDialog.setVisible(true);
            int n = this.fileDialog.getFile() == null ? 1 : 0;
            return n;
        }
        finally {
            if (bl) {
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            }
        }
    }

    @Override
    public int showSaveDialog(Component component) {
        this.fileDialog.setLocale(locale);
        this.fileDialog.setMode(1);
        this.fileDialog.setVisible(true);
        return this.fileDialog.getFile() == null ? 1 : 0;
    }

    public static boolean supportsSelectionMode(int n) {
        switch (n) {
            case 2: {
                return false;
            }
            case 1: {
                return Main.isPlatformOsx();
            }
        }
        return true;
    }
}

