/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.pair.ConflictResolver;
import org.openstreetmap.josm.gui.help.HelpBrowser;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ConflictResolutionDialog
extends JDialog
implements PropertyChangeListener {
    private ConflictResolver resolver;
    private JLabel titleLabel;
    private ApplyResolutionAction applyResolutionAction;

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unregisterListeners();
    }

    @Override
    public void setVisible(boolean bl) {
        String string = this.getClass().getName() + ".geometry";
        if (bl) {
            this.toFront();
            new WindowGeometry(string, WindowGeometry.centerInWindow(Main.parent, new Dimension(600, 400))).applySafe(this);
        } else {
            if (this.isShowing()) {
                new WindowGeometry(this).remember(string);
            }
            this.unregisterListeners();
        }
        super.setVisible(bl);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    protected JPanel buildButtonRow() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1));
        this.applyResolutionAction = new ApplyResolutionAction();
        JButton jButton = new JButton(this.applyResolutionAction);
        jButton.setName("button.apply");
        jPanel.add(jButton);
        jButton = new JButton(new CancelAction());
        jButton.setName("button.cancel");
        jPanel.add(jButton);
        jButton = new JButton(new HelpAction());
        jButton.setName("button.help");
        jPanel.add(jButton);
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        return jPanel;
    }

    private void registerListeners() {
        this.resolver.addPropertyChangeListener(this.applyResolutionAction);
    }

    private void unregisterListeners() {
        this.resolver.removePropertyChangeListener(this.applyResolutionAction);
        this.resolver.unregisterListeners();
    }

    protected void build() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.titleLabel = new JLabel();
        this.titleLabel.setHorizontalAlignment(0);
        this.getContentPane().add((Component)this.titleLabel, "North");
        this.updateTitle();
        this.resolver = new ConflictResolver();
        this.resolver.setName("panel.conflictresolver");
        this.getContentPane().add((Component)this.resolver, "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.resolver.addPropertyChangeListener(this);
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("Dialog/Conflict"));
        this.registerListeners();
    }

    public ConflictResolutionDialog(Component component) {
        super((Window)JOptionPane.getFrameForComponent(component), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
    }

    public ConflictResolver getConflictResolver() {
        return this.resolver;
    }

    protected void updateTitle() {
        this.updateTitle(null);
    }

    protected void updateTitle(OsmPrimitive osmPrimitive) {
        if (osmPrimitive == null) {
            this.setTitle(I18n.tr("Resolve conflicts", new Object[0]));
        } else {
            this.setTitle(I18n.tr("Resolve conflicts for ''{0}''", osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance())));
        }
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.MY_PRIMITIVE_PROP)) {
            this.updateTitle((OsmPrimitive)propertyChangeEvent.getNewValue());
        }
    }

    class ApplyResolutionAction
    extends AbstractAction
    implements PropertyChangeListener {
        ApplyResolutionAction() {
            this.putValue("ShortDescription", I18n.tr("Apply resolved conflicts and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Apply Resolution", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "conflict"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(ConflictResolutionDialog.this.resolver.isResolvedCompletely());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            if (!ConflictResolutionDialog.this.resolver.isResolvedCompletely()) {
                objectArray = new Object[]{I18n.tr("Close anyway", new Object[0]), I18n.tr("Continue resolving", new Object[0])};
                int n = JOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>You did not finish to merge the differences in this conflict.<br>Conflict resolutions will not be applied unless all differences<br>are resolved.<br>Click <strong>{0}</strong> to close anyway.<strong> Already<br>resolved differences will not be applied.</strong><br>Click <strong>{1}</strong> to return to resolving conflicts.</html>", objectArray[0].toString(), objectArray[1].toString()), I18n.tr("Conflict not resolved completely", new Object[0]), 0, 2, null, objectArray, objectArray[1]);
                switch (n) {
                    case 0: {
                        ConflictResolutionDialog.this.closeDialog();
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            objectArray = ConflictResolutionDialog.this.resolver.buildResolveCommand();
            Main.main.undoRedo.add((Command)objectArray);
            ConflictResolutionDialog.this.closeDialog();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(ConflictResolver.RESOLVED_COMPLETELY_PROP)) {
                this.updateEnabledState();
            }
        }
    }

    static class HelpAction
    extends AbstractAction {
        HelpAction() {
            this.putValue("ShortDescription", I18n.tr("Show help information", new Object[0]));
            this.putValue("Name", I18n.tr("Help", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("help"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HelpBrowser.setUrlForHelpTopic(HelpUtil.ht("/Dialog/Conflict"));
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("ShortDescription", I18n.tr("Cancel conflict resolution and close the dialog", new Object[0]));
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("", "cancel"));
            this.setEnabled(true);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ConflictResolutionDialog.this.closeDialog();
        }
    }
}

