/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.openstreetmap.josm.gui.bbox.SlippyMapBBoxChooser;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class SizeButton
extends JComponent {
    private int x;
    private int y;
    private final ImageIcon enlargeImage;
    private final ImageIcon shrinkImage;
    private boolean isEnlarged;
    private final SlippyMapBBoxChooser slippyMapBBoxChooser;
    private final transient MouseAdapter mouseListener = new MouseAdapter(){

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getButton() == 1) {
                SizeButton.this.toggle();
                SizeButton.this.slippyMapBBoxChooser.resizeSlippyMap();
            }
        }
    };

    public SizeButton(SlippyMapBBoxChooser slippyMapBBoxChooser) {
        this.slippyMapBBoxChooser = slippyMapBBoxChooser;
        this.enlargeImage = ImageProvider.get("view-fullscreen");
        this.shrinkImage = ImageProvider.get("view-fullscreen-revert");
        this.setPreferredSize(new Dimension(this.enlargeImage.getIconWidth(), this.enlargeImage.getIconHeight()));
        this.addMouseListener(this.mouseListener);
        this.setToolTipText(I18n.tr("Enlarge", new Object[0]));
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isEnlarged) {
            if (this.shrinkImage != null) {
                graphics.drawImage(this.shrinkImage.getImage(), this.x, this.y, null);
            }
        } else if (this.enlargeImage != null) {
            graphics.drawImage(this.enlargeImage.getImage(), this.x, this.y, null);
        }
    }

    public void toggle() {
        this.isEnlarged = !this.isEnlarged;
        this.setToolTipText(this.isEnlarged ? I18n.tr("Shrink", new Object[0]) : I18n.tr("Enlarge", new Object[0]));
    }

    public boolean isEnlarged() {
        return this.isEnlarged;
    }

    public boolean hit(Point point) {
        return this.x < point.x && point.x < this.x + this.enlargeImage.getIconWidth() && this.y < point.y && point.y < this.y + this.enlargeImage.getIconHeight();
    }
}

