/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.gui.progress.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressTaskId;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.BugReportExceptionHandler;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.xml.sax.SAXException;

public abstract class PleaseWaitRunnable
implements Runnable,
ProgressMonitor.CancelListener {
    private boolean canceled;
    private boolean ignoreException;
    private final String title;
    protected final ProgressMonitor progressMonitor;

    public PleaseWaitRunnable(String string) {
        this(string, false);
    }

    public PleaseWaitRunnable(String string, boolean bl) {
        this(string, new PleaseWaitProgressMonitor(string), bl);
    }

    public PleaseWaitRunnable(Component component, String string, boolean bl) {
        CheckParameterUtil.ensureParameterNotNull(component, "parent");
        this.title = string;
        this.progressMonitor = new PleaseWaitProgressMonitor(component, string);
        this.ignoreException = bl;
    }

    public PleaseWaitRunnable(String string, ProgressMonitor progressMonitor, boolean bl) {
        this.title = string;
        this.progressMonitor = progressMonitor == null ? new PleaseWaitProgressMonitor(string) : progressMonitor;
        this.ignoreException = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRealRun() {
        block16: {
            try {
                ProgressTaskId progressTaskId = null;
                try {
                    this.progressMonitor.addCancelListener(this);
                    this.progressMonitor.beginTask(this.title);
                    progressTaskId = this.progressMonitor.getProgressTaskId();
                    this.progressMonitor.setProgressTaskId(this.canRunInBackground());
                    try {
                        this.realRun();
                    }
                    catch (Throwable throwable) {
                        if (EventQueue.isDispatchThread()) {
                            this.finish();
                        } else {
                            EventQueue.invokeAndWait(new Runnable(){

                                @Override
                                public void run() {
                                    PleaseWaitRunnable.this.finish();
                                }
                            });
                        }
                        throw throwable;
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.finish();
                    } else {
                        EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                    }
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(progressTaskId);
                }
                catch (Throwable throwable) {
                    this.progressMonitor.finishTask();
                    this.progressMonitor.removeCancelListener(this);
                    this.progressMonitor.setProgressTaskId(progressTaskId);
                    if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                        ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                    }
                    if (EventQueue.isDispatchThread()) {
                        this.afterFinish();
                    } else {
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                PleaseWaitRunnable.this.afterFinish();
                            }
                        });
                    }
                    throw throwable;
                }
                if (this.progressMonitor instanceof PleaseWaitProgressMonitor) {
                    ((PleaseWaitProgressMonitor)this.progressMonitor).close();
                }
                if (EventQueue.isDispatchThread()) {
                    this.afterFinish();
                } else {
                    EventQueue.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                }
            }
            catch (Exception exception) {
                if (this.ignoreException) break block16;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (exception instanceof RuntimeException) {
                            BugReportExceptionHandler.handleException(exception);
                        } else {
                            ExceptionDialogUtil.explainException(exception);
                        }
                    }
                });
            }
        }
    }

    protected void afterFinish() {
    }

    @Override
    public final void run() {
        if (this.canceled) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    PleaseWaitRunnable.this.doRealRun();
                }
            }, this.getClass().getName()).start();
        } else {
            this.doRealRun();
        }
    }

    @Override
    public void operationCanceled() {
        this.cancel();
    }

    protected abstract void cancel();

    protected abstract void realRun() throws SAXException, IOException, OsmTransferException;

    protected abstract void finish();

    public ProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    public ProgressTaskId canRunInBackground() {
        return null;
    }
}

